---
layout: default
title: terraform resource scans
nav_order: 1
---

# terraform resource scans (auto generated)

|      | Id              | Type     | Entity                                                           | Policy                                                                                                                                                                                                   | IaC       | Resource Link                                                                                                                                                                                                                    |
|------|-----------------|----------|------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-----------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
|    0 | CKV2_ADO_1      | resource | azuredevops_branch_policy_min_reviewers                          | Ensure at least two approving reviews for PRs                                                                                                                                                            | Terraform | [ADORepositoryHasMinTwoReviewers.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/azuredevops/ADORepositoryHasMinTwoReviewers.yaml)                                                 |
|    1 | CKV2_ADO_1      | resource | azuredevops_git_repository                                       | Ensure at least two approving reviews for PRs                                                                                                                                                            | Terraform | [ADORepositoryHasMinTwoReviewers.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/azuredevops/ADORepositoryHasMinTwoReviewers.yaml)                                                 |
|    2 | CKV_ALI_1       | resource | alicloud_oss_bucket                                              | Alibaba Cloud OSS bucket accessible to public                                                                                                                                                            | Terraform | [OSSBucketPublic.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/alicloud/OSSBucketPublic.yaml)                                                                                    |
|    3 | CKV_ALI_1       | resource | alicloud_oss_bucket_acl                                          | Alibaba Cloud OSS bucket accessible to public                                                                                                                                                            | Terraform | [OSSBucketPublic.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/alicloud/OSSBucketPublic.yaml)                                                                                    |
|    4 | CKV_ALI_2       | resource | alicloud_security_group_rule                                     | Ensure no security groups allow ingress from 0.0.0.0:0 to port 22                                                                                                                                        | Terraform | [SecurityGroupUnrestrictedIngress22.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/SecurityGroupUnrestrictedIngress22.py)                                                      |
|    5 | CKV_ALI_3       | resource | alicloud_security_group_rule                                     | Ensure no security groups allow ingress from 0.0.0.0:0 to port 3389                                                                                                                                      | Terraform | [SecurityGroupUnrestrictedIngress3389.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/SecurityGroupUnrestrictedIngress3389.py)                                                  |
|    6 | CKV_ALI_4       | resource | alicloud_actiontrail_trail                                       | Ensure Action Trail Logging for all regions                                                                                                                                                              | Terraform | [ActionTrailLogAllRegions.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/ActionTrailLogAllRegions.py)                                                                          |
|    7 | CKV_ALI_5       | resource | alicloud_actiontrail_trail                                       | Ensure Action Trail Logging for all events                                                                                                                                                               | Terraform | [ActionTrailLogAllEvents.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/ActionTrailLogAllEvents.py)                                                                            |
|    8 | CKV_ALI_6       | resource | alicloud_oss_bucket                                              | Ensure OSS bucket is encrypted with Customer Master Key                                                                                                                                                  | Terraform | [OSSBucketEncryptedWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/OSSBucketEncryptedWithCMK.py)                                                                        |
|    9 | CKV_ALI_7       | resource | alicloud_disk                                                    | Ensure disk is encrypted                                                                                                                                                                                 | Terraform | [DiskIsEncrypted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/DiskIsEncrypted.py)                                                                                            |
|   10 | CKV_ALI_8       | resource | alicloud_disk                                                    | Ensure Disk is encrypted with Customer Master Key                                                                                                                                                        | Terraform | [DiskEncryptedWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/DiskEncryptedWithCMK.py)                                                                                  |
|   11 | CKV_ALI_9       | resource | alicloud_db_instance                                             | Ensure database instance is not public                                                                                                                                                                   | Terraform | [RDSIsPublic.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/RDSIsPublic.py)                                                                                                    |
|   12 | CKV_ALI_10      | resource | alicloud_oss_bucket                                              | Ensure OSS bucket has versioning enabled                                                                                                                                                                 | Terraform | [OSSBucketVersioning.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/OSSBucketVersioning.py)                                                                                    |
|   13 | CKV_ALI_11      | resource | alicloud_oss_bucket                                              | Ensure OSS bucket has transfer Acceleration enabled                                                                                                                                                      | Terraform | [OSSBucketTransferAcceleration.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/OSSBucketTransferAcceleration.py)                                                                |
|   14 | CKV_ALI_12      | resource | alicloud_oss_bucket                                              | Ensure the OSS bucket has access logging enabled                                                                                                                                                         | Terraform | [OSSBucketAccessLogs.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/OSSBucketAccessLogs.py)                                                                                    |
|   15 | CKV_ALI_13      | resource | alicloud_ram_account_password_policy                             | Ensure RAM password policy requires minimum length of 14 or greater                                                                                                                                      | Terraform | [RAMPasswordPolicyLength.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/RAMPasswordPolicyLength.py)                                                                            |
|   16 | CKV_ALI_14      | resource | alicloud_ram_account_password_policy                             | Ensure RAM password policy requires at least one number                                                                                                                                                  | Terraform | [RAMPasswordPolicyNumber.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/RAMPasswordPolicyNumber.py)                                                                            |
|   17 | CKV_ALI_15      | resource | alicloud_ram_account_password_policy                             | Ensure RAM password policy requires at least one symbol                                                                                                                                                  | Terraform | [RAMPasswordPolicySymbol.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/RAMPasswordPolicySymbol.py)                                                                            |
|   18 | CKV_ALI_16      | resource | alicloud_ram_account_password_policy                             | Ensure RAM password policy expires passwords within 90 days or less                                                                                                                                      | Terraform | [RAMPasswordPolicyExpiration.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/RAMPasswordPolicyExpiration.py)                                                                    |
|   19 | CKV_ALI_17      | resource | alicloud_ram_account_password_policy                             | Ensure RAM password policy requires at least one lowercase letter                                                                                                                                        | Terraform | [RAMPasswordPolicyLowercaseLetter.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/RAMPasswordPolicyLowercaseLetter.py)                                                          |
|   20 | CKV_ALI_18      | resource | alicloud_ram_account_password_policy                             | Ensure RAM password policy prevents password reuse                                                                                                                                                       | Terraform | [RAMPasswordPolicyReuse.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/RAMPasswordPolicyReuse.py)                                                                              |
|   21 | CKV_ALI_19      | resource | alicloud_ram_account_password_policy                             | Ensure RAM password policy requires at least one uppercase letter                                                                                                                                        | Terraform | [RAMPasswordPolicyUppcaseLetter.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/RAMPasswordPolicyUppcaseLetter.py)                                                              |
|   22 | CKV_ALI_20      | resource | alicloud_db_instance                                             | Ensure RDS instance uses SSL                                                                                                                                                                             | Terraform | [RDSInstanceSSL.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/RDSInstanceSSL.py)                                                                                              |
|   23 | CKV_ALI_21      | resource | alicloud_api_gateway_api                                         | Ensure API Gateway API Protocol HTTPS                                                                                                                                                                    | Terraform | [APIGatewayProtocolHTTPS.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/APIGatewayProtocolHTTPS.py)                                                                            |
|   24 | CKV_ALI_22      | resource | alicloud_db_instance                                             | Ensure Transparent Data Encryption is Enabled on instance                                                                                                                                                | Terraform | [RDSTransparentDataEncryptionEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/RDSTransparentDataEncryptionEnabled.py)                                                    |
|   25 | CKV_ALI_23      | resource | alicloud_ram_account_password_policy                             | Ensure Ram Account Password Policy Max Login Attempts not > 5                                                                                                                                            | Terraform | [RAMPasswordPolicyMaxLogin.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/RAMPasswordPolicyMaxLogin.py)                                                                        |
|   26 | CKV_ALI_24      | resource | alicloud_ram_security_preference                                 | Ensure RAM enforces MFA                                                                                                                                                                                  | Terraform | [RAMSecurityEnforceMFA.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/RAMSecurityEnforceMFA.py)                                                                                |
|   27 | CKV_ALI_25      | resource | alicloud_db_instance                                             | Ensure RDS Instance SQL Collector Retention Period should be greater than 180                                                                                                                            | Terraform | [RDSRetention.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/RDSRetention.py)                                                                                                  |
|   28 | CKV_ALI_26      | resource | alicloud_cs_kubernetes                                           | Ensure Kubernetes installs plugin Terway or Flannel to support standard policies                                                                                                                         | Terraform | [K8sEnableNetworkPolicies.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/K8sEnableNetworkPolicies.py)                                                                          |
|   29 | CKV_ALI_27      | resource | alicloud_kms_key                                                 | Ensure KMS Key Rotation is enabled                                                                                                                                                                       | Terraform | [KMSKeyRotationIsEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/KMSKeyRotationIsEnabled.py)                                                                            |
|   30 | CKV_ALI_28      | resource | alicloud_kms_key                                                 | Ensure KMS Keys are enabled                                                                                                                                                                              | Terraform | [KMSKeyIsEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/KMSKeyIsEnabled.py)                                                                                            |
|   31 | CKV_ALI_29      | resource | alicloud_alb_acl_entry_attachment                                | Alibaba ALB ACL does not restrict Access                                                                                                                                                                 | Terraform | [ALBACLIsUnrestricted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/ALBACLIsUnrestricted.py)                                                                                  |
|   32 | CKV_ALI_30      | resource | alicloud_db_instance                                             | Ensure RDS instance auto upgrades for minor versions                                                                                                                                                     | Terraform | [RDSInstanceAutoUpgrade.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/RDSInstanceAutoUpgrade.py)                                                                              |
|   33 | CKV_ALI_31      | resource | alicloud_cs_kubernetes_node_pool                                 | Ensure K8s nodepools are set to auto repair                                                                                                                                                              | Terraform | [K8sNodePoolAutoRepair.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/K8sNodePoolAutoRepair.py)                                                                                |
|   34 | CKV_ALI_32      | resource | alicloud_ecs_launch_template                                     | Ensure launch template data disks are encrypted                                                                                                                                                          | Terraform | [LaunchTemplateDisksAreEncrypted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/LaunchTemplateDisksAreEncrypted.py)                                                            |
|   35 | CKV_ALI_33      | resource | alicloud_slb_tls_cipher_policy                                   | Alibaba Cloud Cypher Policy are secure                                                                                                                                                                   | Terraform | [TLSPoliciesAreSecure.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/TLSPoliciesAreSecure.py)                                                                                  |
|   36 | CKV_ALI_35      | resource | alicloud_db_instance                                             | Ensure RDS instance has log_duration enabled                                                                                                                                                             | Terraform | [RDSInstanceLogsEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/RDSInstanceLogsEnabled.py)                                                                              |
|   37 | CKV_ALI_36      | resource | alicloud_db_instance                                             | Ensure RDS instance has log_disconnections enabled                                                                                                                                                       | Terraform | [RDSInstanceLogDisconnections.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/RDSInstanceLogDisconnections.py)                                                                  |
|   38 | CKV_ALI_37      | resource | alicloud_db_instance                                             | Ensure RDS instance has log_connections enabled                                                                                                                                                          | Terraform | [RDSInstanceLogConnections.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/RDSInstanceLogConnections.py)                                                                        |
|   39 | CKV_ALI_38      | resource | alicloud_log_audit                                               | Ensure log audit is enabled for RDS                                                                                                                                                                      | Terraform | [LogAuditRDSEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/LogAuditRDSEnabled.py)                                                                                      |
|   40 | CKV_ALI_41      | resource | alicloud_mongodb_instance                                        | Ensure MongoDB is deployed inside a VPC                                                                                                                                                                  | Terraform | [MongoDBInsideVPC.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/MongoDBInsideVPC.py)                                                                                          |
|   41 | CKV_ALI_42      | resource | alicloud_mongodb_instance                                        | Ensure Mongodb instance uses SSL                                                                                                                                                                         | Terraform | [MongoDBInstanceSSL.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/MongoDBInstanceSSL.py)                                                                                      |
|   42 | CKV_ALI_43      | resource | alicloud_mongodb_instance                                        | Ensure MongoDB instance is not public                                                                                                                                                                    | Terraform | [MongoDBIsPublic.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/MongoDBIsPublic.py)                                                                                            |
|   43 | CKV_ALI_44      | resource | alicloud_mongodb_instance                                        | Ensure MongoDB has Transparent Data Encryption Enabled                                                                                                                                                   | Terraform | [MongoDBTransparentDataEncryptionEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/alicloud/MongoDBTransparentDataEncryptionEnabled.py)                                            |
|   44 | CKV_AWS_1       | data     | aws_iam_policy_document                                          | Ensure IAM policies that allow full "*-*" administrative privileges are not created                                                                                                                      | Terraform | [AdminPolicyDocument.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/data/aws/AdminPolicyDocument.py)                                                                                             |
|   45 | CKV_AWS_2       | resource | aws_alb_listener                                                 | Ensure ALB protocol is HTTPS                                                                                                                                                                             | Terraform | [ALBListenerHTTPS.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ALBListenerHTTPS.py)                                                                                               |
|   46 | CKV_AWS_2       | resource | aws_lb_listener                                                  | Ensure ALB protocol is HTTPS                                                                                                                                                                             | Terraform | [ALBListenerHTTPS.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ALBListenerHTTPS.py)                                                                                               |
|   47 | CKV_AWS_3       | resource | aws_ebs_volume                                                   | Ensure all data stored in the EBS is securely encrypted                                                                                                                                                  | Terraform | [EBSEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/EBSEncryption.py)                                                                                                     |
|   48 | CKV_AWS_5       | resource | aws_elasticsearch_domain                                         | Ensure all data stored in the Elasticsearch is securely encrypted at rest                                                                                                                                | Terraform | [ElasticsearchEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ElasticsearchEncryption.py)                                                                                 |
|   49 | CKV_AWS_5       | resource | aws_opensearch_domain                                            | Ensure all data stored in the Elasticsearch is securely encrypted at rest                                                                                                                                | Terraform | [ElasticsearchEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ElasticsearchEncryption.py)                                                                                 |
|   50 | CKV_AWS_6       | resource | aws_elasticsearch_domain                                         | Ensure all Elasticsearch has node-to-node encryption enabled                                                                                                                                             | Terraform | [ElasticsearchNodeToNodeEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ElasticsearchNodeToNodeEncryption.py)                                                             |
|   51 | CKV_AWS_6       | resource | aws_opensearch_domain                                            | Ensure all Elasticsearch has node-to-node encryption enabled                                                                                                                                             | Terraform | [ElasticsearchNodeToNodeEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ElasticsearchNodeToNodeEncryption.py)                                                             |
|   52 | CKV_AWS_7       | resource | aws_kms_key                                                      | Ensure rotation for customer created CMKs is enabled                                                                                                                                                     | Terraform | [KMSRotation.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/KMSRotation.py)                                                                                                         |
|   53 | CKV_AWS_8       | resource | aws_instance                                                     | Ensure all data stored in the Launch configuration or instance Elastic Blocks Store is securely encrypted                                                                                                | Terraform | [LaunchConfigurationEBSEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/LaunchConfigurationEBSEncryption.py)                                                               |
|   54 | CKV_AWS_8       | resource | aws_launch_configuration                                         | Ensure all data stored in the Launch configuration or instance Elastic Blocks Store is securely encrypted                                                                                                | Terraform | [LaunchConfigurationEBSEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/LaunchConfigurationEBSEncryption.py)                                                               |
|   55 | CKV_AWS_9       | resource | aws_iam_account_password_policy                                  | Ensure IAM password policy expires passwords within 90 days or less                                                                                                                                      | Terraform | [PasswordPolicyExpiration.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/PasswordPolicyExpiration.py)                                                                               |
|   56 | CKV_AWS_10      | resource | aws_iam_account_password_policy                                  | Ensure IAM password policy requires minimum length of 14 or greater                                                                                                                                      | Terraform | [PasswordPolicyLength.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/PasswordPolicyLength.py)                                                                                       |
|   57 | CKV_AWS_11      | resource | aws_iam_account_password_policy                                  | Ensure IAM password policy requires at least one lowercase letter                                                                                                                                        | Terraform | [PasswordPolicyLowercaseLetter.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/PasswordPolicyLowercaseLetter.py)                                                                     |
|   58 | CKV_AWS_12      | resource | aws_iam_account_password_policy                                  | Ensure IAM password policy requires at least one number                                                                                                                                                  | Terraform | [PasswordPolicyNumber.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/PasswordPolicyNumber.py)                                                                                       |
|   59 | CKV_AWS_13      | resource | aws_iam_account_password_policy                                  | Ensure IAM password policy prevents password reuse                                                                                                                                                       | Terraform | [PasswordPolicyReuse.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/PasswordPolicyReuse.py)                                                                                         |
|   60 | CKV_AWS_14      | resource | aws_iam_account_password_policy                                  | Ensure IAM password policy requires at least one symbol                                                                                                                                                  | Terraform | [PasswordPolicySymbol.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/PasswordPolicySymbol.py)                                                                                       |
|   61 | CKV_AWS_15      | resource | aws_iam_account_password_policy                                  | Ensure IAM password policy requires at least one uppercase letter                                                                                                                                        | Terraform | [PasswordPolicyUppercaseLetter.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/PasswordPolicyUppercaseLetter.py)                                                                     |
|   62 | CKV_AWS_16      | resource | aws_db_instance                                                  | Ensure all data stored in the RDS is securely encrypted at rest                                                                                                                                          | Terraform | [RDSEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RDSEncryption.py)                                                                                                     |
|   63 | CKV_AWS_17      | resource | aws_db_instance                                                  | Ensure all data stored in RDS is not publicly accessible                                                                                                                                                 | Terraform | [RDSPubliclyAccessible.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RDSPubliclyAccessible.py)                                                                                     |
|   64 | CKV_AWS_17      | resource | aws_rds_cluster_instance                                         | Ensure all data stored in RDS is not publicly accessible                                                                                                                                                 | Terraform | [RDSPubliclyAccessible.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RDSPubliclyAccessible.py)                                                                                     |
|   65 | CKV_AWS_18      | resource | aws_s3_bucket                                                    | Ensure the S3 bucket has access logging enabled                                                                                                                                                          | Terraform | [S3BucketLogging.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/S3BucketLogging.yaml)                                                                                         |
|   66 | CKV_AWS_19      | resource | aws_s3_bucket                                                    | Ensure all data stored in the S3 bucket is securely encrypted at rest                                                                                                                                    | Terraform | [S3BucketEncryption.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/S3BucketEncryption.yaml)                                                                                   |
|   67 | CKV_AWS_19      | resource | aws_s3_bucket_server_side_encryption_configuration               | Ensure all data stored in the S3 bucket is securely encrypted at rest                                                                                                                                    | Terraform | [S3BucketEncryption.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/S3BucketEncryption.yaml)                                                                                   |
|   68 | CKV_AWS_20      | resource | aws_s3_bucket                                                    | S3 Bucket has an ACL defined which allows public READ access.                                                                                                                                            | Terraform | [S3PublicACLRead.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/S3PublicACLRead.yaml)                                                                                         |
|   69 | CKV_AWS_20      | resource | aws_s3_bucket_acl                                                | S3 Bucket has an ACL defined which allows public READ access.                                                                                                                                            | Terraform | [S3PublicACLRead.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/S3PublicACLRead.yaml)                                                                                         |
|   70 | CKV_AWS_21      | resource | aws_s3_bucket                                                    | Ensure all data stored in the S3 bucket have versioning enabled                                                                                                                                          | Terraform | [S3BucketVersioning.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/S3BucketVersioning.yaml)                                                                                   |
|   71 | CKV_AWS_21      | resource | aws_s3_bucket_versioning                                         | Ensure all data stored in the S3 bucket have versioning enabled                                                                                                                                          | Terraform | [S3BucketVersioning.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/S3BucketVersioning.yaml)                                                                                   |
|   72 | CKV_AWS_22      | resource | aws_sagemaker_notebook_instance                                  | Ensure SageMaker Notebook is encrypted at rest using KMS CMK                                                                                                                                             | Terraform | [SagemakerNotebookEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SagemakerNotebookEncryption.py)                                                                         |
|   73 | CKV_AWS_23      | resource | aws_db_security_group                                            | Ensure every security group and rule has a description                                                                                                                                                   | Terraform | [SecurityGroupRuleDescription.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SecurityGroupRuleDescription.py)                                                                       |
|   74 | CKV_AWS_23      | resource | aws_elasticache_security_group                                   | Ensure every security group and rule has a description                                                                                                                                                   | Terraform | [SecurityGroupRuleDescription.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SecurityGroupRuleDescription.py)                                                                       |
|   75 | CKV_AWS_23      | resource | aws_redshift_security_group                                      | Ensure every security group and rule has a description                                                                                                                                                   | Terraform | [SecurityGroupRuleDescription.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SecurityGroupRuleDescription.py)                                                                       |
|   76 | CKV_AWS_23      | resource | aws_security_group                                               | Ensure every security group and rule has a description                                                                                                                                                   | Terraform | [SecurityGroupRuleDescription.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SecurityGroupRuleDescription.py)                                                                       |
|   77 | CKV_AWS_23      | resource | aws_security_group_rule                                          | Ensure every security group and rule has a description                                                                                                                                                   | Terraform | [SecurityGroupRuleDescription.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SecurityGroupRuleDescription.py)                                                                       |
|   78 | CKV_AWS_23      | resource | aws_vpc_security_group_egress_rule                               | Ensure every security group and rule has a description                                                                                                                                                   | Terraform | [SecurityGroupRuleDescription.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SecurityGroupRuleDescription.py)                                                                       |
|   79 | CKV_AWS_23      | resource | aws_vpc_security_group_ingress_rule                              | Ensure every security group and rule has a description                                                                                                                                                   | Terraform | [SecurityGroupRuleDescription.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SecurityGroupRuleDescription.py)                                                                       |
|   80 | CKV_AWS_24      | resource | aws_security_group                                               | Ensure no security groups allow ingress from 0.0.0.0:0 to port 22                                                                                                                                        | Terraform | [SecurityGroupUnrestrictedIngress22.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SecurityGroupUnrestrictedIngress22.py)                                                           |
|   81 | CKV_AWS_24      | resource | aws_security_group_rule                                          | Ensure no security groups allow ingress from 0.0.0.0:0 to port 22                                                                                                                                        | Terraform | [SecurityGroupUnrestrictedIngress22.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SecurityGroupUnrestrictedIngress22.py)                                                           |
|   82 | CKV_AWS_24      | resource | aws_vpc_security_group_ingress_rule                              | Ensure no security groups allow ingress from 0.0.0.0:0 to port 22                                                                                                                                        | Terraform | [SecurityGroupUnrestrictedIngress22.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SecurityGroupUnrestrictedIngress22.py)                                                           |
|   83 | CKV_AWS_25      | resource | aws_security_group                                               | Ensure no security groups allow ingress from 0.0.0.0:0 to port 3389                                                                                                                                      | Terraform | [SecurityGroupUnrestrictedIngress3389.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SecurityGroupUnrestrictedIngress3389.py)                                                       |
|   84 | CKV_AWS_25      | resource | aws_security_group_rule                                          | Ensure no security groups allow ingress from 0.0.0.0:0 to port 3389                                                                                                                                      | Terraform | [SecurityGroupUnrestrictedIngress3389.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SecurityGroupUnrestrictedIngress3389.py)                                                       |
|   85 | CKV_AWS_25      | resource | aws_vpc_security_group_ingress_rule                              | Ensure no security groups allow ingress from 0.0.0.0:0 to port 3389                                                                                                                                      | Terraform | [SecurityGroupUnrestrictedIngress3389.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SecurityGroupUnrestrictedIngress3389.py)                                                       |
|   86 | CKV_AWS_26      | resource | aws_sns_topic                                                    | Ensure all data stored in the SNS topic is encrypted                                                                                                                                                     | Terraform | [SNSTopicEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SNSTopicEncryption.py)                                                                                           |
|   87 | CKV_AWS_27      | resource | aws_sqs_queue                                                    | Ensure all data stored in the SQS queue is encrypted                                                                                                                                                     | Terraform | [SQSQueueEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SQSQueueEncryption.py)                                                                                           |
|   88 | CKV_AWS_28      | resource | aws_dynamodb_table                                               | Ensure DynamoDB point in time recovery (backup) is enabled                                                                                                                                               | Terraform | [DynamodbRecovery.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/DynamodbRecovery.py)                                                                                               |
|   89 | CKV_AWS_29      | resource | aws_elasticache_replication_group                                | Ensure all data stored in the ElastiCache Replication Group is securely encrypted at rest                                                                                                                | Terraform | [ElasticacheReplicationGroupEncryptionAtRest.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ElasticacheReplicationGroupEncryptionAtRest.py)                                         |
|   90 | CKV_AWS_30      | resource | aws_elasticache_replication_group                                | Ensure all data stored in the ElastiCache Replication Group is securely encrypted at transit                                                                                                             | Terraform | [ElasticacheReplicationGroupEncryptionAtTransit.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ElasticacheReplicationGroupEncryptionAtTransit.py)                                   |
|   91 | CKV_AWS_31      | resource | aws_elasticache_replication_group                                | Ensure all data stored in the ElastiCache Replication Group is securely encrypted at transit and has auth token                                                                                          | Terraform | [ElasticacheReplicationGroupEncryptionAtTransitAuthToken.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ElasticacheReplicationGroupEncryptionAtTransitAuthToken.py)                 |
|   92 | CKV_AWS_32      | resource | aws_ecr_repository_policy                                        | Ensure ECR policy is not set to public                                                                                                                                                                   | Terraform | [ECRPolicy.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ECRPolicy.py)                                                                                                             |
|   93 | CKV_AWS_33      | resource | aws_kms_key                                                      | Ensure KMS key policy does not contain wildcard (*) principal                                                                                                                                            | Terraform | [KMSKeyWildcardPrincipal.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/KMSKeyWildcardPrincipal.py)                                                                                 |
|   94 | CKV_AWS_34      | resource | aws_cloudfront_distribution                                      | Ensure CloudFront distribution ViewerProtocolPolicy is set to HTTPS                                                                                                                                      | Terraform | [CloudfrontDistributionEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/CloudfrontDistributionEncryption.py)                                                               |
|   95 | CKV_AWS_35      | resource | aws_cloudtrail                                                   | Ensure CloudTrail logs are encrypted at rest using KMS CMKs                                                                                                                                              | Terraform | [CloudtrailEncryptionWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/CloudtrailEncryptionWithCMK.py)                                                                         |
|   96 | CKV_AWS_36      | resource | aws_cloudtrail                                                   | Ensure CloudTrail log file validation is enabled                                                                                                                                                         | Terraform | [CloudtrailLogValidation.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/CloudtrailLogValidation.py)                                                                                 |
|   97 | CKV_AWS_37      | resource | aws_eks_cluster                                                  | Ensure Amazon EKS control plane logging is enabled for all log types                                                                                                                                     | Terraform | [EKSControlPlaneLogging.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/EKSControlPlaneLogging.py)                                                                                   |
|   98 | CKV_AWS_38      | resource | aws_eks_cluster                                                  | Ensure Amazon EKS public endpoint not accessible to 0.0.0.0/0                                                                                                                                            | Terraform | [EKSPublicAccessCIDR.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/EKSPublicAccessCIDR.py)                                                                                         |
|   99 | CKV_AWS_39      | resource | aws_eks_cluster                                                  | Ensure Amazon EKS public endpoint disabled                                                                                                                                                               | Terraform | [EKSPublicAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/EKSPublicAccess.py)                                                                                                 |
|  100 | CKV_AWS_40      | resource | aws_iam_policy_attachment                                        | Ensure IAM policies are attached only to groups or roles (Reducing access management complexity may in-turn reduce opportunity for a principal to inadvertently receive or retain excessive privileges.) | Terraform | [IAMPolicyAttachedToGroupOrRoles.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMPolicyAttachedToGroupOrRoles.py)                                                                 |
|  101 | CKV_AWS_40      | resource | aws_iam_user_policy                                              | Ensure IAM policies are attached only to groups or roles (Reducing access management complexity may in-turn reduce opportunity for a principal to inadvertently receive or retain excessive privileges.) | Terraform | [IAMPolicyAttachedToGroupOrRoles.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMPolicyAttachedToGroupOrRoles.py)                                                                 |
|  102 | CKV_AWS_40      | resource | aws_iam_user_policy_attachment                                   | Ensure IAM policies are attached only to groups or roles (Reducing access management complexity may in-turn reduce opportunity for a principal to inadvertently receive or retain excessive privileges.) | Terraform | [IAMPolicyAttachedToGroupOrRoles.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMPolicyAttachedToGroupOrRoles.py)                                                                 |
|  103 | CKV_AWS_41      | provider | aws                                                              | Ensure no hard coded AWS access key and secret key exists in provider                                                                                                                                    | Terraform | [credentials.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/provider/aws/credentials.py)                                                                                                         |
|  104 | CKV_AWS_42      | resource | aws_efs_file_system                                              | Ensure EFS is securely encrypted                                                                                                                                                                         | Terraform | [EFSEncryptionEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/EFSEncryptionEnabled.py)                                                                                       |
|  105 | CKV_AWS_43      | resource | aws_kinesis_stream                                               | Ensure Kinesis Stream is securely encrypted                                                                                                                                                              | Terraform | [KinesisStreamEncryptionType.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/KinesisStreamEncryptionType.py)                                                                         |
|  106 | CKV_AWS_44      | resource | aws_neptune_cluster                                              | Ensure Neptune storage is securely encrypted                                                                                                                                                             | Terraform | [NeptuneClusterStorageEncrypted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/NeptuneClusterStorageEncrypted.py)                                                                   |
|  107 | CKV_AWS_45      | resource | aws_lambda_function                                              | Ensure no hard-coded secrets exist in lambda environment                                                                                                                                                 | Terraform | [LambdaEnvironmentCredentials.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/LambdaEnvironmentCredentials.py)                                                                       |
|  108 | CKV_AWS_46      | resource | aws_instance                                                     | Ensure no hard-coded secrets exist in EC2 user data                                                                                                                                                      | Terraform | [EC2Credentials.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/EC2Credentials.py)                                                                                                   |
|  109 | CKV_AWS_46      | resource | aws_launch_configuration                                         | Ensure no hard-coded secrets exist in EC2 user data                                                                                                                                                      | Terraform | [EC2Credentials.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/EC2Credentials.py)                                                                                                   |
|  110 | CKV_AWS_46      | resource | aws_launch_template                                              | Ensure no hard-coded secrets exist in EC2 user data                                                                                                                                                      | Terraform | [EC2Credentials.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/EC2Credentials.py)                                                                                                   |
|  111 | CKV_AWS_47      | resource | aws_dax_cluster                                                  | Ensure DAX is encrypted at rest (default is unencrypted)                                                                                                                                                 | Terraform | [DAXEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/DAXEncryption.py)                                                                                                     |
|  112 | CKV_AWS_48      | resource | aws_mq_broker                                                    | Ensure MQ Broker logging is enabled                                                                                                                                                                      | Terraform | [MQBrokerLogging.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/MQBrokerLogging.py)                                                                                                 |
|  113 | CKV_AWS_49      | data     | aws_iam_policy_document                                          | Ensure no IAM policies documents allow "*" as a statement's actions                                                                                                                                      | Terraform | [StarActionPolicyDocument.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/data/aws/StarActionPolicyDocument.py)                                                                                   |
|  114 | CKV_AWS_50      | resource | aws_lambda_function                                              | X-Ray tracing is enabled for Lambda                                                                                                                                                                      | Terraform | [LambdaXrayEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/LambdaXrayEnabled.py)                                                                                             |
|  115 | CKV_AWS_51      | resource | aws_ecr_repository                                               | Ensure ECR Image Tags are immutable                                                                                                                                                                      | Terraform | [ECRImmutableTags.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ECRImmutableTags.py)                                                                                               |
|  116 | CKV_AWS_53      | resource | aws_s3_bucket_public_access_block                                | Ensure S3 bucket has block public ACLS enabled                                                                                                                                                           | Terraform | [S3BlockPublicACLs.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/S3BlockPublicACLs.py)                                                                                             |
|  117 | CKV_AWS_54      | resource | aws_s3_bucket_public_access_block                                | Ensure S3 bucket has block public policy enabled                                                                                                                                                         | Terraform | [S3BlockPublicPolicy.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/S3BlockPublicPolicy.py)                                                                                         |
|  118 | CKV_AWS_55      | resource | aws_s3_bucket_public_access_block                                | Ensure S3 bucket has ignore public ACLs enabled                                                                                                                                                          | Terraform | [S3IgnorePublicACLs.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/S3IgnorePublicACLs.py)                                                                                           |
|  119 | CKV_AWS_56      | resource | aws_s3_bucket_public_access_block                                | Ensure S3 bucket has 'restrict_public_buckets' enabled                                                                                                                                                   | Terraform | [S3RestrictPublicBuckets.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/S3RestrictPublicBuckets.py)                                                                                 |
|  120 | CKV_AWS_57      | resource | aws_s3_bucket                                                    | S3 Bucket has an ACL defined which allows public WRITE access.                                                                                                                                           | Terraform | [S3PublicACLWrite.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/S3PublicACLWrite.yaml)                                                                                       |
|  121 | CKV_AWS_57      | resource | aws_s3_bucket_acl                                                | S3 Bucket has an ACL defined which allows public WRITE access.                                                                                                                                           | Terraform | [S3PublicACLWrite.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/S3PublicACLWrite.yaml)                                                                                       |
|  122 | CKV_AWS_58      | resource | aws_eks_cluster                                                  | Ensure EKS Cluster has Secrets Encryption Enabled                                                                                                                                                        | Terraform | [EKSSecretsEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/EKSSecretsEncryption.py)                                                                                       |
|  123 | CKV_AWS_59      | resource | aws_api_gateway_method                                           | Ensure there is no open access to back-end resources through API                                                                                                                                         | Terraform | [APIGatewayAuthorization.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/APIGatewayAuthorization.py)                                                                                 |
|  124 | CKV_AWS_60      | resource | aws_iam_role                                                     | Ensure IAM role allows only specific services or principals to assume it                                                                                                                                 | Terraform | [IAMRoleAllowsPublicAssume.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMRoleAllowsPublicAssume.py)                                                                             |
|  125 | CKV_AWS_61      | resource | aws_iam_role                                                     | Ensure AWS IAM policy does not allow assume role permission across all services                                                                                                                          | Terraform | [IAMRoleAllowAssumeFromAccount.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMRoleAllowAssumeFromAccount.py)                                                                     |
|  126 | CKV_AWS_62      | resource | aws_iam_group_policy                                             | Ensure IAM policies that allow full "*-*" administrative privileges are not created                                                                                                                      | Terraform | [IAMAdminPolicyDocument.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMAdminPolicyDocument.py)                                                                                   |
|  127 | CKV_AWS_62      | resource | aws_iam_policy                                                   | Ensure IAM policies that allow full "*-*" administrative privileges are not created                                                                                                                      | Terraform | [IAMAdminPolicyDocument.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMAdminPolicyDocument.py)                                                                                   |
|  128 | CKV_AWS_62      | resource | aws_iam_role_policy                                              | Ensure IAM policies that allow full "*-*" administrative privileges are not created                                                                                                                      | Terraform | [IAMAdminPolicyDocument.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMAdminPolicyDocument.py)                                                                                   |
|  129 | CKV_AWS_62      | resource | aws_iam_user_policy                                              | Ensure IAM policies that allow full "*-*" administrative privileges are not created                                                                                                                      | Terraform | [IAMAdminPolicyDocument.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMAdminPolicyDocument.py)                                                                                   |
|  130 | CKV_AWS_62      | resource | aws_ssoadmin_permission_set_inline_policy                        | Ensure IAM policies that allow full "*-*" administrative privileges are not created                                                                                                                      | Terraform | [IAMAdminPolicyDocument.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMAdminPolicyDocument.py)                                                                                   |
|  131 | CKV_AWS_63      | resource | aws_iam_group_policy                                             | Ensure no IAM policies documents allow "*" as a statement's actions                                                                                                                                      | Terraform | [IAMStarActionPolicyDocument.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMStarActionPolicyDocument.py)                                                                         |
|  132 | CKV_AWS_63      | resource | aws_iam_policy                                                   | Ensure no IAM policies documents allow "*" as a statement's actions                                                                                                                                      | Terraform | [IAMStarActionPolicyDocument.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMStarActionPolicyDocument.py)                                                                         |
|  133 | CKV_AWS_63      | resource | aws_iam_role_policy                                              | Ensure no IAM policies documents allow "*" as a statement's actions                                                                                                                                      | Terraform | [IAMStarActionPolicyDocument.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMStarActionPolicyDocument.py)                                                                         |
|  134 | CKV_AWS_63      | resource | aws_iam_user_policy                                              | Ensure no IAM policies documents allow "*" as a statement's actions                                                                                                                                      | Terraform | [IAMStarActionPolicyDocument.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMStarActionPolicyDocument.py)                                                                         |
|  135 | CKV_AWS_63      | resource | aws_ssoadmin_permission_set_inline_policy                        | Ensure no IAM policies documents allow "*" as a statement's actions                                                                                                                                      | Terraform | [IAMStarActionPolicyDocument.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMStarActionPolicyDocument.py)                                                                         |
|  136 | CKV_AWS_64      | resource | aws_redshift_cluster                                             | Ensure all data stored in the Redshift cluster is securely encrypted at rest                                                                                                                             | Terraform | [RedshiftClusterEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RedshiftClusterEncryption.py)                                                                             |
|  137 | CKV_AWS_65      | resource | aws_ecs_cluster                                                  | Ensure container insights are enabled on ECS cluster                                                                                                                                                     | Terraform | [ECSClusterContainerInsights.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ECSClusterContainerInsights.py)                                                                         |
|  138 | CKV_AWS_66      | resource | aws_cloudwatch_log_group                                         | Ensure that CloudWatch Log Group specifies retention days                                                                                                                                                | Terraform | [CloudWatchLogGroupRetention.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/CloudWatchLogGroupRetention.py)                                                                         |
|  139 | CKV_AWS_67      | resource | aws_cloudtrail                                                   | Ensure CloudTrail is enabled in all Regions                                                                                                                                                              | Terraform | [CloudtrailMultiRegion.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/CloudtrailMultiRegion.py)                                                                                     |
|  140 | CKV_AWS_68      | resource | aws_cloudfront_distribution                                      | CloudFront Distribution should have WAF enabled                                                                                                                                                          | Terraform | [WAFEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/WAFEnabled.py)                                                                                                           |
|  141 | CKV_AWS_69      | resource | aws_mq_broker                                                    | Ensure MQ Broker is not publicly exposed                                                                                                                                                                 | Terraform | [MQBrokerNotPubliclyExposed.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/MQBrokerNotPubliclyExposed.py)                                                                           |
|  142 | CKV_AWS_70      | resource | aws_s3_bucket                                                    | Ensure S3 bucket does not allow an action with any Principal                                                                                                                                             | Terraform | [S3AllowsAnyPrincipal.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/S3AllowsAnyPrincipal.py)                                                                                       |
|  143 | CKV_AWS_70      | resource | aws_s3_bucket_policy                                             | Ensure S3 bucket does not allow an action with any Principal                                                                                                                                             | Terraform | [S3AllowsAnyPrincipal.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/S3AllowsAnyPrincipal.py)                                                                                       |
|  144 | CKV_AWS_71      | resource | aws_redshift_cluster                                             | Ensure Redshift Cluster logging is enabled                                                                                                                                                               | Terraform | [RedshiftClusterLogging.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RedshiftClusterLogging.py)                                                                                   |
|  145 | CKV_AWS_72      | resource | aws_sqs_queue_policy                                             | Ensure SQS policy does not allow ALL (*) actions.                                                                                                                                                        | Terraform | [SQSPolicy.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SQSPolicy.py)                                                                                                             |
|  146 | CKV_AWS_73      | resource | aws_api_gateway_stage                                            | Ensure API Gateway has X-Ray Tracing enabled                                                                                                                                                             | Terraform | [APIGatewayXray.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/APIGatewayXray.py)                                                                                                   |
|  147 | CKV_AWS_74      | resource | aws_docdb_cluster                                                | Ensure DocumentDB is encrypted at rest (default is unencrypted)                                                                                                                                          | Terraform | [DocDBEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/DocDBEncryption.py)                                                                                                 |
|  148 | CKV_AWS_75      | resource | aws_globalaccelerator_accelerator                                | Ensure Global Accelerator accelerator has flow logs enabled                                                                                                                                              | Terraform | [GlobalAcceleratorAcceleratorFlowLogs.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/GlobalAcceleratorAcceleratorFlowLogs.py)                                                       |
|  149 | CKV_AWS_76      | resource | aws_api_gateway_stage                                            | Ensure API Gateway has Access Logging enabled                                                                                                                                                            | Terraform | [APIGatewayAccessLogging.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/APIGatewayAccessLogging.py)                                                                                 |
|  150 | CKV_AWS_76      | resource | aws_apigatewayv2_stage                                           | Ensure API Gateway has Access Logging enabled                                                                                                                                                            | Terraform | [APIGatewayAccessLogging.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/APIGatewayAccessLogging.py)                                                                                 |
|  151 | CKV_AWS_77      | resource | aws_athena_database                                              | Ensure Athena Database is encrypted at rest (default is unencrypted)                                                                                                                                     | Terraform | [AthenaDatabaseEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/AthenaDatabaseEncryption.py)                                                                               |
|  152 | CKV_AWS_78      | resource | aws_codebuild_project                                            | Ensure that CodeBuild Project encryption is not disabled                                                                                                                                                 | Terraform | [CodeBuildProjectEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/CodeBuildProjectEncryption.py)                                                                           |
|  153 | CKV_AWS_79      | resource | aws_instance                                                     | Ensure Instance Metadata Service Version 1 is not enabled                                                                                                                                                | Terraform | [IMDSv1Disabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IMDSv1Disabled.py)                                                                                                   |
|  154 | CKV_AWS_79      | resource | aws_launch_configuration                                         | Ensure Instance Metadata Service Version 1 is not enabled                                                                                                                                                | Terraform | [IMDSv1Disabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IMDSv1Disabled.py)                                                                                                   |
|  155 | CKV_AWS_79      | resource | aws_launch_template                                              | Ensure Instance Metadata Service Version 1 is not enabled                                                                                                                                                | Terraform | [IMDSv1Disabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IMDSv1Disabled.py)                                                                                                   |
|  156 | CKV_AWS_80      | resource | aws_msk_cluster                                                  | Ensure MSK Cluster logging is enabled                                                                                                                                                                    | Terraform | [MSKClusterLogging.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/MSKClusterLogging.py)                                                                                             |
|  157 | CKV_AWS_81      | resource | aws_msk_cluster                                                  | Ensure MSK Cluster encryption in rest and transit is enabled                                                                                                                                             | Terraform | [MSKClusterEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/MSKClusterEncryption.py)                                                                                       |
|  158 | CKV_AWS_82      | resource | aws_athena_workgroup                                             | Ensure Athena Workgroup should enforce configuration to prevent client disabling encryption                                                                                                              | Terraform | [AthenaWorkgroupConfiguration.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/AthenaWorkgroupConfiguration.py)                                                                       |
|  159 | CKV_AWS_83      | resource | aws_elasticsearch_domain                                         | Ensure Elasticsearch Domain enforces HTTPS                                                                                                                                                               | Terraform | [ElasticsearchDomainEnforceHTTPS.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ElasticsearchDomainEnforceHTTPS.py)                                                                 |
|  160 | CKV_AWS_83      | resource | aws_opensearch_domain                                            | Ensure Elasticsearch Domain enforces HTTPS                                                                                                                                                               | Terraform | [ElasticsearchDomainEnforceHTTPS.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ElasticsearchDomainEnforceHTTPS.py)                                                                 |
|  161 | CKV_AWS_84      | resource | aws_elasticsearch_domain                                         | Ensure Elasticsearch Domain Logging is enabled                                                                                                                                                           | Terraform | [ElasticsearchDomainLogging.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ElasticsearchDomainLogging.py)                                                                           |
|  162 | CKV_AWS_84      | resource | aws_opensearch_domain                                            | Ensure Elasticsearch Domain Logging is enabled                                                                                                                                                           | Terraform | [ElasticsearchDomainLogging.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ElasticsearchDomainLogging.py)                                                                           |
|  163 | CKV_AWS_85      | resource | aws_docdb_cluster                                                | Ensure DocumentDB Logging is enabled                                                                                                                                                                     | Terraform | [DocDBLogging.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/DocDBLogging.py)                                                                                                       |
|  164 | CKV_AWS_86      | resource | aws_cloudfront_distribution                                      | Ensure CloudFront distribution has Access Logging enabled                                                                                                                                                | Terraform | [CloudfrontDistributionLogging.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/CloudfrontDistributionLogging.py)                                                                     |
|  165 | CKV_AWS_87      | resource | aws_redshift_cluster                                             | Redshift cluster should not be publicly accessible                                                                                                                                                       | Terraform | [RedshitClusterPubliclyAvailable.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RedshitClusterPubliclyAvailable.py)                                                                 |
|  166 | CKV_AWS_88      | resource | aws_instance                                                     | EC2 instance should not have public IP.                                                                                                                                                                  | Terraform | [EC2PublicIP.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/EC2PublicIP.py)                                                                                                         |
|  167 | CKV_AWS_88      | resource | aws_launch_template                                              | EC2 instance should not have public IP.                                                                                                                                                                  | Terraform | [EC2PublicIP.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/EC2PublicIP.py)                                                                                                         |
|  168 | CKV_AWS_89      | resource | aws_dms_replication_instance                                     | DMS replication instance should not be publicly accessible                                                                                                                                               | Terraform | [DMSReplicationInstancePubliclyAccessible.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/DMSReplicationInstancePubliclyAccessible.py)                                               |
|  169 | CKV_AWS_90      | resource | aws_docdb_cluster_parameter_group                                | Ensure DocumentDB TLS is not disabled                                                                                                                                                                    | Terraform | [DocDBTLS.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/DocDBTLS.py)                                                                                                               |
|  170 | CKV_AWS_91      | resource | aws_alb                                                          | Ensure the ELBv2 (Application/Network) has access logging enabled                                                                                                                                        | Terraform | [ELBv2AccessLogs.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ELBv2AccessLogs.py)                                                                                                 |
|  171 | CKV_AWS_91      | resource | aws_lb                                                           | Ensure the ELBv2 (Application/Network) has access logging enabled                                                                                                                                        | Terraform | [ELBv2AccessLogs.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ELBv2AccessLogs.py)                                                                                                 |
|  172 | CKV_AWS_92      | resource | aws_elb                                                          | Ensure the ELB has access logging enabled                                                                                                                                                                | Terraform | [ELBAccessLogs.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ELBAccessLogs.py)                                                                                                     |
|  173 | CKV_AWS_93      | resource | aws_s3_bucket                                                    | Ensure S3 bucket policy does not lockout all but root user. (Prevent lockouts needing root account fixes)                                                                                                | Terraform | [S3ProtectAgainstPolicyLockout.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/S3ProtectAgainstPolicyLockout.py)                                                                     |
|  174 | CKV_AWS_93      | resource | aws_s3_bucket_policy                                             | Ensure S3 bucket policy does not lockout all but root user. (Prevent lockouts needing root account fixes)                                                                                                | Terraform | [S3ProtectAgainstPolicyLockout.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/S3ProtectAgainstPolicyLockout.py)                                                                     |
|  175 | CKV_AWS_94      | resource | aws_glue_data_catalog_encryption_settings                        | Ensure Glue Data Catalog Encryption is enabled                                                                                                                                                           | Terraform | [GlueDataCatalogEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/GlueDataCatalogEncryption.py)                                                                             |
|  176 | CKV_AWS_96      | resource | aws_rds_cluster                                                  | Ensure all data stored in Aurora is securely encrypted at rest                                                                                                                                           | Terraform | [AuroraEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/AuroraEncryption.py)                                                                                               |
|  177 | CKV_AWS_97      | resource | aws_ecs_task_definition                                          | Ensure Encryption in transit is enabled for EFS volumes in ECS Task definitions                                                                                                                          | Terraform | [ECSTaskDefinitionEFSVolumeEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ECSTaskDefinitionEFSVolumeEncryption.py)                                                       |
|  178 | CKV_AWS_98      | resource | aws_sagemaker_endpoint_configuration                             | Ensure all data stored in the Sagemaker Endpoint is securely encrypted at rest                                                                                                                           | Terraform | [SagemakerEndpointConfigurationEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SagemakerEndpointConfigurationEncryption.py)                                               |
|  179 | CKV_AWS_99      | resource | aws_glue_security_configuration                                  | Ensure Glue Security Configuration Encryption is enabled                                                                                                                                                 | Terraform | [GlueSecurityConfiguration.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/GlueSecurityConfiguration.py)                                                                             |
|  180 | CKV_AWS_100     | resource | aws_eks_node_group                                               | Ensure AWS EKS node group does not have implicit SSH access from 0.0.0.0/0                                                                                                                               | Terraform | [EKSNodeGroupRemoteAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/EKSNodeGroupRemoteAccess.py)                                                                               |
|  181 | CKV_AWS_101     | resource | aws_neptune_cluster                                              | Ensure Neptune logging is enabled                                                                                                                                                                        | Terraform | [NeptuneClusterLogging.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/NeptuneClusterLogging.py)                                                                                     |
|  182 | CKV_AWS_102     | resource | aws_neptune_cluster_instance                                     | Ensure Neptune Cluster instance is not publicly available                                                                                                                                                | Terraform | [NeptuneClusterInstancePublic.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/NeptuneClusterInstancePublic.py)                                                                       |
|  183 | CKV_AWS_103     | resource | aws_alb_listener                                                 | Ensure that load balancer is using at least TLS 1.2                                                                                                                                                      | Terraform | [AppLoadBalancerTLS12.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/AppLoadBalancerTLS12.yaml)                                                                               |
|  184 | CKV_AWS_103     | resource | aws_lb                                                           | Ensure that load balancer is using at least TLS 1.2                                                                                                                                                      | Terraform | [AppLoadBalancerTLS12.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/AppLoadBalancerTLS12.yaml)                                                                               |
|  185 | CKV_AWS_103     | resource | aws_lb_listener                                                  | Ensure that load balancer is using at least TLS 1.2                                                                                                                                                      | Terraform | [AppLoadBalancerTLS12.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/AppLoadBalancerTLS12.yaml)                                                                               |
|  186 | CKV_AWS_104     | resource | aws_docdb_cluster_parameter_group                                | Ensure DocumentDB has audit logs enabled                                                                                                                                                                 | Terraform | [DocDBAuditLogs.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/DocDBAuditLogs.py)                                                                                                   |
|  187 | CKV_AWS_105     | resource | aws_redshift_parameter_group                                     | Ensure Redshift uses SSL                                                                                                                                                                                 | Terraform | [RedShiftSSL.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RedShiftSSL.py)                                                                                                         |
|  188 | CKV_AWS_106     | resource | aws_ebs_encryption_by_default                                    | Ensure EBS default encryption is enabled                                                                                                                                                                 | Terraform | [EBSDefaultEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/EBSDefaultEncryption.py)                                                                                       |
|  189 | CKV_AWS_107     | data     | aws_iam_policy_document                                          | Ensure IAM policies does not allow credentials exposure                                                                                                                                                  | Terraform | [IAMCredentialsExposure.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/data/aws/IAMCredentialsExposure.py)                                                                                       |
|  190 | CKV_AWS_108     | data     | aws_iam_policy_document                                          | Ensure IAM policies does not allow data exfiltration                                                                                                                                                     | Terraform | [IAMDataExfiltration.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/data/aws/IAMDataExfiltration.py)                                                                                             |
|  191 | CKV_AWS_109     | data     | aws_iam_policy_document                                          | Ensure IAM policies does not allow permissions management / resource exposure without constraints                                                                                                        | Terraform | [IAMPermissionsManagement.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/data/aws/IAMPermissionsManagement.py)                                                                                   |
|  192 | CKV_AWS_110     | data     | aws_iam_policy_document                                          | Ensure IAM policies does not allow privilege escalation                                                                                                                                                  | Terraform | [IAMPrivilegeEscalation.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/data/aws/IAMPrivilegeEscalation.py)                                                                                       |
|  193 | CKV_AWS_111     | data     | aws_iam_policy_document                                          | Ensure IAM policies does not allow write access without constraints                                                                                                                                      | Terraform | [IAMWriteAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/data/aws/IAMWriteAccess.py)                                                                                                       |
|  194 | CKV_AWS_112     | resource | aws_ssm_document                                                 | Ensure Session Manager data is encrypted in transit                                                                                                                                                      | Terraform | [SSMSessionManagerDocumentEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SSMSessionManagerDocumentEncryption.py)                                                         |
|  195 | CKV_AWS_113     | resource | aws_ssm_document                                                 | Ensure Session Manager logs are enabled and encrypted                                                                                                                                                    | Terraform | [SSMSessionManagerDocumentLogging.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SSMSessionManagerDocumentLogging.py)                                                               |
|  196 | CKV_AWS_114     | resource | aws_emr_cluster                                                  | Ensure that EMR clusters with Kerberos have Kerberos Realm set                                                                                                                                           | Terraform | [EMRClusterKerberosAttributes.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/EMRClusterKerberosAttributes.py)                                                                       |
|  197 | CKV_AWS_115     | resource | aws_lambda_function                                              | Ensure that AWS Lambda function is configured for function-level concurrent execution limit                                                                                                              | Terraform | [LambdaFunctionLevelConcurrentExecutionLimit.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/LambdaFunctionLevelConcurrentExecutionLimit.py)                                         |
|  198 | CKV_AWS_116     | resource | aws_lambda_function                                              | Ensure that AWS Lambda function is configured for a Dead Letter Queue(DLQ)                                                                                                                               | Terraform | [LambdaDLQConfigured.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/LambdaDLQConfigured.py)                                                                                         |
|  199 | CKV_AWS_117     | resource | aws_lambda_function                                              | Ensure that AWS Lambda function is configured inside a VPC                                                                                                                                               | Terraform | [LambdaInVPC.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/LambdaInVPC.py)                                                                                                         |
|  200 | CKV_AWS_118     | resource | aws_db_instance                                                  | Ensure that enhanced monitoring is enabled for Amazon RDS instances                                                                                                                                      | Terraform | [RDSEnhancedMonitorEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RDSEnhancedMonitorEnabled.py)                                                                             |
|  201 | CKV_AWS_118     | resource | aws_rds_cluster_instance                                         | Ensure that enhanced monitoring is enabled for Amazon RDS instances                                                                                                                                      | Terraform | [RDSEnhancedMonitorEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RDSEnhancedMonitorEnabled.py)                                                                             |
|  202 | CKV_AWS_119     | resource | aws_dynamodb_table                                               | Ensure DynamoDB Tables are encrypted using a KMS Customer Managed CMK                                                                                                                                    | Terraform | [DynamoDBTablesEncrypted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/DynamoDBTablesEncrypted.py)                                                                                 |
|  203 | CKV_AWS_120     | resource | aws_api_gateway_stage                                            | Ensure API Gateway caching is enabled                                                                                                                                                                    | Terraform | [APIGatewayCacheEnable.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/APIGatewayCacheEnable.py)                                                                                     |
|  204 | CKV_AWS_121     | resource | aws_config_configuration_aggregator                              | Ensure AWS Config is enabled in all regions                                                                                                                                                              | Terraform | [ConfigConfgurationAggregatorAllRegions.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ConfigConfgurationAggregatorAllRegions.py)                                                   |
|  205 | CKV_AWS_122     | resource | aws_sagemaker_notebook_instance                                  | Ensure that direct internet access is disabled for an Amazon SageMaker Notebook Instance                                                                                                                 | Terraform | [SageMakerInternetAccessDisabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SageMakerInternetAccessDisabled.py)                                                                 |
|  206 | CKV_AWS_123     | resource | aws_vpc_endpoint_service                                         | Ensure that VPC Endpoint Service is configured for Manual Acceptance                                                                                                                                     | Terraform | [VPCEndpointAcceptanceConfigured.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/VPCEndpointAcceptanceConfigured.py)                                                                 |
|  207 | CKV_AWS_124     | resource | aws_cloudformation_stack                                         | Ensure that CloudFormation stacks are sending event notifications to an SNS topic                                                                                                                        | Terraform | [CloudformationStackNotificationArns.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/CloudformationStackNotificationArns.py)                                                         |
|  208 | CKV_AWS_126     | resource | aws_instance                                                     | Ensure that detailed monitoring is enabled for EC2 instances                                                                                                                                             | Terraform | [EC2DetailedMonitoringEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/EC2DetailedMonitoringEnabled.py)                                                                       |
|  209 | CKV_AWS_127     | resource | aws_elb                                                          | Ensure that Elastic Load Balancer(s) uses SSL certificates provided by AWS Certificate Manager                                                                                                           | Terraform | [ELBUsesSSL.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ELBUsesSSL.py)                                                                                                           |
|  210 | CKV_AWS_129     | resource | aws_db_instance                                                  | Ensure that respective logs of Amazon Relational Database Service (Amazon RDS) are enabled                                                                                                               | Terraform | [DBInstanceLogging.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/DBInstanceLogging.py)                                                                                             |
|  211 | CKV_AWS_130     | resource | aws_subnet                                                       | Ensure VPC subnets do not assign public IP by default                                                                                                                                                    | Terraform | [SubnetPublicIP.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SubnetPublicIP.py)                                                                                                   |
|  212 | CKV_AWS_131     | resource | aws_alb                                                          | Ensure that ALB drops HTTP headers                                                                                                                                                                       | Terraform | [ALBDropHttpHeaders.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ALBDropHttpHeaders.py)                                                                                           |
|  213 | CKV_AWS_131     | resource | aws_lb                                                           | Ensure that ALB drops HTTP headers                                                                                                                                                                       | Terraform | [ALBDropHttpHeaders.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ALBDropHttpHeaders.py)                                                                                           |
|  214 | CKV_AWS_133     | resource | aws_db_instance                                                  | Ensure that RDS instances has backup policy                                                                                                                                                              | Terraform | [DBInstanceBackupRetentionPeriod.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/DBInstanceBackupRetentionPeriod.py)                                                                 |
|  215 | CKV_AWS_133     | resource | aws_rds_cluster                                                  | Ensure that RDS instances has backup policy                                                                                                                                                              | Terraform | [DBInstanceBackupRetentionPeriod.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/DBInstanceBackupRetentionPeriod.py)                                                                 |
|  216 | CKV_AWS_134     | resource | aws_elasticache_cluster                                          | Ensure that Amazon ElastiCache Redis clusters have automatic backup turned on                                                                                                                            | Terraform | [ElasticCacheAutomaticBackup.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ElasticCacheAutomaticBackup.py)                                                                         |
|  217 | CKV_AWS_135     | resource | aws_instance                                                     | Ensure that EC2 is EBS optimized                                                                                                                                                                         | Terraform | [EC2EBSOptimized.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/EC2EBSOptimized.py)                                                                                                 |
|  218 | CKV_AWS_136     | resource | aws_ecr_repository                                               | Ensure that ECR repositories are encrypted using KMS                                                                                                                                                     | Terraform | [ECRRepositoryEncrypted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ECRRepositoryEncrypted.py)                                                                                   |
|  219 | CKV_AWS_137     | resource | aws_elasticsearch_domain                                         | Ensure that Elasticsearch is configured inside a VPC                                                                                                                                                     | Terraform | [ElasticsearchInVPC.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ElasticsearchInVPC.py)                                                                                           |
|  220 | CKV_AWS_137     | resource | aws_opensearch_domain                                            | Ensure that Elasticsearch is configured inside a VPC                                                                                                                                                     | Terraform | [ElasticsearchInVPC.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ElasticsearchInVPC.py)                                                                                           |
|  221 | CKV_AWS_138     | resource | aws_elb                                                          | Ensure that ELB is cross-zone-load-balancing enabled                                                                                                                                                     | Terraform | [ELBCrossZoneEnable.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ELBCrossZoneEnable.py)                                                                                           |
|  222 | CKV_AWS_139     | resource | aws_rds_cluster                                                  | Ensure that RDS clusters have deletion protection enabled                                                                                                                                                | Terraform | [RDSDeletionProtection.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RDSDeletionProtection.py)                                                                                     |
|  223 | CKV_AWS_140     | resource | aws_rds_global_cluster                                           | Ensure that RDS global clusters are encrypted                                                                                                                                                            | Terraform | [RDSClusterEncrypted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RDSClusterEncrypted.py)                                                                                         |
|  224 | CKV_AWS_141     | resource | aws_redshift_cluster                                             | Ensured that Redshift cluster allowing version upgrade by default                                                                                                                                        | Terraform | [RedshiftClusterAllowVersionUpgrade.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RedshiftClusterAllowVersionUpgrade.py)                                                           |
|  225 | CKV_AWS_142     | resource | aws_redshift_cluster                                             | Ensure that Redshift cluster is encrypted by KMS                                                                                                                                                         | Terraform | [RedshiftClusterKMSKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RedshiftClusterKMSKey.py)                                                                                     |
|  226 | CKV_AWS_143     | resource | aws_s3_bucket                                                    | Ensure that S3 bucket has lock configuration enabled by default                                                                                                                                          | Terraform | [S3BucketObjectLock.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/S3BucketObjectLock.py)                                                                                           |
|  227 | CKV_AWS_144     | resource | aws_s3_bucket                                                    | Ensure that S3 bucket has cross-region replication enabled                                                                                                                                               | Terraform | [S3BucketReplicationConfiguration.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/S3BucketReplicationConfiguration.yaml)                                                       |
|  228 | CKV_AWS_144     | resource | aws_s3_bucket_replication_configuration                          | Ensure that S3 bucket has cross-region replication enabled                                                                                                                                               | Terraform | [S3BucketReplicationConfiguration.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/S3BucketReplicationConfiguration.yaml)                                                       |
|  229 | CKV_AWS_145     | resource | aws_s3_bucket                                                    | Ensure that S3 buckets are encrypted with KMS by default                                                                                                                                                 | Terraform | [S3KMSEncryptedByDefault.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/S3KMSEncryptedByDefault.yaml)                                                                         |
|  230 | CKV_AWS_145     | resource | aws_s3_bucket_server_side_encryption_configuration               | Ensure that S3 buckets are encrypted with KMS by default                                                                                                                                                 | Terraform | [S3KMSEncryptedByDefault.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/S3KMSEncryptedByDefault.yaml)                                                                         |
|  231 | CKV_AWS_146     | resource | aws_db_cluster_snapshot                                          | Ensure that RDS database cluster snapshot is encrypted                                                                                                                                                   | Terraform | [RDSClusterSnapshotEncrypted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RDSClusterSnapshotEncrypted.py)                                                                         |
|  232 | CKV_AWS_147     | resource | aws_codebuild_project                                            | Ensure that CodeBuild projects are encrypted using CMK                                                                                                                                                   | Terraform | [CodebuildUsesCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/CodebuildUsesCMK.py)                                                                                               |
|  233 | CKV_AWS_148     | resource | aws_default_vpc                                                  | Ensure no default VPC is planned to be provisioned                                                                                                                                                       | Terraform | [VPCDefaultNetwork.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/VPCDefaultNetwork.py)                                                                                             |
|  234 | CKV_AWS_149     | resource | aws_secretsmanager_secret                                        | Ensure that Secrets Manager secret is encrypted using KMS CMK                                                                                                                                            | Terraform | [SecretManagerSecretEncrypted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SecretManagerSecretEncrypted.py)                                                                       |
|  235 | CKV_AWS_150     | resource | aws_alb                                                          | Ensure that Load Balancer has deletion protection enabled                                                                                                                                                | Terraform | [LBDeletionProtection.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/LBDeletionProtection.py)                                                                                       |
|  236 | CKV_AWS_150     | resource | aws_lb                                                           | Ensure that Load Balancer has deletion protection enabled                                                                                                                                                | Terraform | [LBDeletionProtection.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/LBDeletionProtection.py)                                                                                       |
|  237 | CKV_AWS_152     | resource | aws_alb                                                          | Ensure that Load Balancer (Network/Gateway) has cross-zone load balancing enabled                                                                                                                        | Terraform | [LBCrossZone.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/LBCrossZone.py)                                                                                                         |
|  238 | CKV_AWS_152     | resource | aws_lb                                                           | Ensure that Load Balancer (Network/Gateway) has cross-zone load balancing enabled                                                                                                                        | Terraform | [LBCrossZone.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/LBCrossZone.py)                                                                                                         |
|  239 | CKV_AWS_153     | resource | aws_autoscaling_group                                            | Autoscaling groups should supply tags to launch configurations                                                                                                                                           | Terraform | [AutoScalingTagging.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/AutoScalingTagging.py)                                                                                           |
|  240 | CKV_AWS_154     | resource | aws_redshift_cluster                                             | Ensure Redshift is not deployed outside of a VPC                                                                                                                                                         | Terraform | [RedshiftInEc2ClassicMode.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RedshiftInEc2ClassicMode.py)                                                                               |
|  241 | CKV_AWS_155     | resource | aws_workspaces_workspace                                         | Ensure that Workspace user volumes are encrypted                                                                                                                                                         | Terraform | [WorkspaceUserVolumeEncrypted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/WorkspaceUserVolumeEncrypted.py)                                                                       |
|  242 | CKV_AWS_156     | resource | aws_workspaces_workspace                                         | Ensure that Workspace root volumes are encrypted                                                                                                                                                         | Terraform | [WorkspaceRootVolumeEncrypted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/WorkspaceRootVolumeEncrypted.py)                                                                       |
|  243 | CKV_AWS_157     | resource | aws_db_instance                                                  | Ensure that RDS instances have Multi-AZ enabled                                                                                                                                                          | Terraform | [RDSMultiAZEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RDSMultiAZEnabled.py)                                                                                             |
|  244 | CKV_AWS_158     | resource | aws_cloudwatch_log_group                                         | Ensure that CloudWatch Log Group is encrypted by KMS                                                                                                                                                     | Terraform | [CloudWatchLogGroupKMSKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/CloudWatchLogGroupKMSKey.py)                                                                               |
|  245 | CKV_AWS_159     | resource | aws_athena_workgroup                                             | Ensure that Athena Workgroup is encrypted                                                                                                                                                                | Terraform | [AthenaWorkgroupEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/AthenaWorkgroupEncryption.py)                                                                             |
|  246 | CKV_AWS_160     | resource | aws_timestreamwrite_database                                     | Ensure that Timestream database is encrypted with KMS CMK                                                                                                                                                | Terraform | [TimestreamDatabaseKMSKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/TimestreamDatabaseKMSKey.py)                                                                               |
|  247 | CKV_AWS_161     | resource | aws_db_instance                                                  | Ensure RDS database has IAM authentication enabled                                                                                                                                                       | Terraform | [RDSIAMAuthentication.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RDSIAMAuthentication.py)                                                                                       |
|  248 | CKV_AWS_162     | resource | aws_rds_cluster                                                  | Ensure RDS cluster has IAM authentication enabled                                                                                                                                                        | Terraform | [RDSClusterIAMAuthentication.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RDSClusterIAMAuthentication.py)                                                                         |
|  249 | CKV_AWS_163     | resource | aws_ecr_repository                                               | Ensure ECR image scanning on push is enabled                                                                                                                                                             | Terraform | [ECRImageScanning.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ECRImageScanning.py)                                                                                               |
|  250 | CKV_AWS_164     | resource | aws_transfer_server                                              | Ensure Transfer Server is not exposed publicly.                                                                                                                                                          | Terraform | [TransferServerIsPublic.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/TransferServerIsPublic.py)                                                                                   |
|  251 | CKV_AWS_165     | resource | aws_dynamodb_global_table                                        | Ensure DynamoDB point in time recovery (backup) is enabled for global tables                                                                                                                             | Terraform | [DynamoDBGlobalTableRecovery.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/DynamoDBGlobalTableRecovery.py)                                                                         |
|  252 | CKV_AWS_166     | resource | aws_backup_vault                                                 | Ensure Backup Vault is encrypted at rest using KMS CMK                                                                                                                                                   | Terraform | [BackupVaultEncrypted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/BackupVaultEncrypted.py)                                                                                       |
|  253 | CKV_AWS_167     | resource | aws_glacier_vault                                                | Ensure Glacier Vault access policy is not public by only allowing specific services or principals to access it                                                                                           | Terraform | [GlacierVaultAnyPrincipal.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/GlacierVaultAnyPrincipal.py)                                                                               |
|  254 | CKV_AWS_168     | resource | aws_sqs_queue                                                    | Ensure SQS queue policy is not public by only allowing specific services or principals to access it                                                                                                      | Terraform | [SQSQueuePolicyAnyPrincipal.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SQSQueuePolicyAnyPrincipal.py)                                                                           |
|  255 | CKV_AWS_168     | resource | aws_sqs_queue_policy                                             | Ensure SQS queue policy is not public by only allowing specific services or principals to access it                                                                                                      | Terraform | [SQSQueuePolicyAnyPrincipal.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SQSQueuePolicyAnyPrincipal.py)                                                                           |
|  256 | CKV_AWS_169     | resource | aws_sns_topic_policy                                             | Ensure SNS topic policy is not public by only allowing specific services or principals to access it                                                                                                      | Terraform | [SNSTopicPolicyAnyPrincipal.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SNSTopicPolicyAnyPrincipal.py)                                                                           |
|  257 | CKV_AWS_170     | resource | aws_qldb_ledger                                                  | Ensure QLDB ledger permissions mode is set to STANDARD                                                                                                                                                   | Terraform | [QLDBLedgerPermissionsMode.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/QLDBLedgerPermissionsMode.py)                                                                             |
|  258 | CKV_AWS_171     | resource | aws_emr_security_configuration                                   | Ensure EMR Cluster security configuration encryption is using SSE-KMS                                                                                                                                    | Terraform | [EMRClusterIsEncryptedKMS.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/EMRClusterIsEncryptedKMS.py)                                                                               |
|  259 | CKV_AWS_172     | resource | aws_qldb_ledger                                                  | Ensure QLDB ledger has deletion protection enabled                                                                                                                                                       | Terraform | [QLDBLedgerDeletionProtection.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/QLDBLedgerDeletionProtection.py)                                                                       |
|  260 | CKV_AWS_173     | resource | aws_lambda_function                                              | Check encryption settings for Lambda environmental variable                                                                                                                                              | Terraform | [LambdaEnvironmentEncryptionSettings.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/LambdaEnvironmentEncryptionSettings.py)                                                         |
|  261 | CKV_AWS_174     | resource | aws_cloudfront_distribution                                      | Verify CloudFront Distribution Viewer Certificate is using TLS v1.2 or higher                                                                                                                            | Terraform | [CloudfrontTLS12.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/CloudfrontTLS12.py)                                                                                                 |
|  262 | CKV_AWS_175     | resource | aws_waf_web_acl                                                  | Ensure WAF has associated rules                                                                                                                                                                          | Terraform | [WAFHasAnyRules.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/WAFHasAnyRules.py)                                                                                                   |
|  263 | CKV_AWS_175     | resource | aws_wafregional_web_acl                                          | Ensure WAF has associated rules                                                                                                                                                                          | Terraform | [WAFHasAnyRules.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/WAFHasAnyRules.py)                                                                                                   |
|  264 | CKV_AWS_175     | resource | aws_wafv2_web_acl                                                | Ensure WAF has associated rules                                                                                                                                                                          | Terraform | [WAFHasAnyRules.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/WAFHasAnyRules.py)                                                                                                   |
|  265 | CKV_AWS_176     | resource | aws_waf_web_acl                                                  | Ensure Logging is enabled for WAF Web Access Control Lists                                                                                                                                               | Terraform | [WAFHasLogs.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/WAFHasLogs.py)                                                                                                           |
|  266 | CKV_AWS_176     | resource | aws_wafregional_web_acl                                          | Ensure Logging is enabled for WAF Web Access Control Lists                                                                                                                                               | Terraform | [WAFHasLogs.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/WAFHasLogs.py)                                                                                                           |
|  267 | CKV_AWS_177     | resource | aws_kinesis_video_stream                                         | Ensure Kinesis Video Stream is encrypted by KMS using a customer managed Key (CMK)                                                                                                                       | Terraform | [KinesisVideoEncryptedWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/KinesisVideoEncryptedWithCMK.py)                                                                       |
|  268 | CKV_AWS_178     | resource | aws_fsx_ontap_file_system                                        | Ensure fx ontap file system is encrypted by KMS using a customer managed Key (CMK)                                                                                                                       | Terraform | [FSXOntapFSEncryptedWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/FSXOntapFSEncryptedWithCMK.py)                                                                           |
|  269 | CKV_AWS_179     | resource | aws_fsx_windows_file_system                                      | Ensure FSX Windows filesystem is encrypted by KMS using a customer managed Key (CMK)                                                                                                                     | Terraform | [FSXWindowsFSEncryptedWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/FSXWindowsFSEncryptedWithCMK.py)                                                                       |
|  270 | CKV_AWS_180     | resource | aws_imagebuilder_component                                       | Ensure Image Builder component is encrypted by KMS using a customer managed Key (CMK)                                                                                                                    | Terraform | [ImagebuilderComponentEncryptedWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ImagebuilderComponentEncryptedWithCMK.py)                                                     |
|  271 | CKV_AWS_181     | resource | aws_s3_object_copy                                               | Ensure S3 Object Copy is encrypted by KMS using a customer managed Key (CMK)                                                                                                                             | Terraform | [S3ObjectCopyEncryptedWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/S3ObjectCopyEncryptedWithCMK.py)                                                                       |
|  272 | CKV_AWS_182     | resource | aws_docdb_cluster                                                | Ensure DocumentDB is encrypted by KMS using a customer managed Key (CMK)                                                                                                                                 | Terraform | [DocDBEncryptedWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/DocDBEncryptedWithCMK.py)                                                                                     |
|  273 | CKV_AWS_183     | resource | aws_ebs_snapshot_copy                                            | Ensure EBS Snapshot Copy is encrypted by KMS using a customer managed Key (CMK)                                                                                                                          | Terraform | [EBSSnapshotCopyEncryptedWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/EBSSnapshotCopyEncryptedWithCMK.py)                                                                 |
|  274 | CKV_AWS_184     | resource | aws_efs_file_system                                              | Ensure resource is encrypted by KMS using a customer managed Key (CMK)                                                                                                                                   | Terraform | [EFSFileSystemEncryptedWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/EFSFileSystemEncryptedWithCMK.py)                                                                     |
|  275 | CKV_AWS_185     | resource | aws_kinesis_stream                                               | Ensure Kinesis Stream is encrypted by KMS using a customer managed Key (CMK)                                                                                                                             | Terraform | [KinesisStreamEncryptedWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/KinesisStreamEncryptedWithCMK.py)                                                                     |
|  276 | CKV_AWS_186     | resource | aws_s3_bucket_object                                             | Ensure S3 bucket Object is encrypted by KMS using a customer managed Key (CMK)                                                                                                                           | Terraform | [S3BucketObjectEncryptedWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/S3BucketObjectEncryptedWithCMK.py)                                                                   |
|  277 | CKV_AWS_187     | resource | aws_sagemaker_domain                                             | Ensure Sagemaker domain and notebook instance are encrypted by KMS using a customer managed Key (CMK)                                                                                                    | Terraform | [SagemakerDomainEncryptedWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SagemakerDomainEncryptedWithCMK.py)                                                                 |
|  278 | CKV_AWS_187     | resource | aws_sagemaker_notebook_instance                                  | Ensure Sagemaker domain and notebook instance are encrypted by KMS using a customer managed Key (CMK)                                                                                                    | Terraform | [SagemakerDomainEncryptedWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SagemakerDomainEncryptedWithCMK.py)                                                                 |
|  279 | CKV_AWS_189     | resource | aws_ebs_volume                                                   | Ensure EBS Volume is encrypted by KMS using a customer managed Key (CMK)                                                                                                                                 | Terraform | [EBSVolumeEncryptedWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/EBSVolumeEncryptedWithCMK.py)                                                                             |
|  280 | CKV_AWS_190     | resource | aws_fsx_lustre_file_system                                       | Ensure lustre file systems is encrypted by KMS using a customer managed Key (CMK)                                                                                                                        | Terraform | [LustreFSEncryptedWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/LustreFSEncryptedWithCMK.py)                                                                               |
|  281 | CKV_AWS_191     | resource | aws_elasticache_replication_group                                | Ensure ElastiCache replication group is encrypted by KMS using a customer managed Key (CMK)                                                                                                              | Terraform | [ElasticacheReplicationGroupEncryptedWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ElasticacheReplicationGroupEncryptedWithCMK.py)                                         |
|  282 | CKV_AWS_192     | resource | aws_wafv2_web_acl                                                | Ensure WAF prevents message lookup in Log4j2. See CVE-2021-44228 aka log4jshell                                                                                                                          | Terraform | [WAFACLCVE202144228.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/WAFACLCVE202144228.py)                                                                                           |
|  283 | CKV_AWS_193     | resource | aws_appsync_graphql_api                                          | Ensure AppSync has Logging enabled                                                                                                                                                                       | Terraform | [AppSyncLogging.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/AppSyncLogging.py)                                                                                                   |
|  284 | CKV_AWS_194     | resource | aws_appsync_graphql_api                                          | Ensure AppSync has Field-Level logs enabled                                                                                                                                                              | Terraform | [AppSyncFieldLevelLogs.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/AppSyncFieldLevelLogs.py)                                                                                     |
|  285 | CKV_AWS_195     | resource | aws_glue_crawler                                                 | Ensure Glue component has a security configuration associated                                                                                                                                            | Terraform | [GlueSecurityConfigurationEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/GlueSecurityConfigurationEnabled.py)                                                               |
|  286 | CKV_AWS_195     | resource | aws_glue_dev_endpoint                                            | Ensure Glue component has a security configuration associated                                                                                                                                            | Terraform | [GlueSecurityConfigurationEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/GlueSecurityConfigurationEnabled.py)                                                               |
|  287 | CKV_AWS_195     | resource | aws_glue_job                                                     | Ensure Glue component has a security configuration associated                                                                                                                                            | Terraform | [GlueSecurityConfigurationEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/GlueSecurityConfigurationEnabled.py)                                                               |
|  288 | CKV_AWS_196     | resource | aws_elasticache_security_group                                   | Ensure no aws_elasticache_security_group resources exist                                                                                                                                                 | Terraform | [ElasticacheHasSecurityGroup.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ElasticacheHasSecurityGroup.py)                                                                         |
|  289 | CKV_AWS_197     | resource | aws_mq_broker                                                    | Ensure MQ Broker Audit logging is enabled                                                                                                                                                                | Terraform | [MQBrokerAuditLogging.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/MQBrokerAuditLogging.py)                                                                                       |
|  290 | CKV_AWS_198     | resource | aws_db_security_group                                            | Ensure no aws_db_security_group resources exist                                                                                                                                                          | Terraform | [RDSHasSecurityGroup.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RDSHasSecurityGroup.py)                                                                                         |
|  291 | CKV_AWS_199     | resource | aws_imagebuilder_distribution_configuration                      | Ensure Image Builder Distribution Configuration encrypts AMI's using KMS - a customer managed Key (CMK)                                                                                                  | Terraform | [ImagebuilderDistributionConfigurationEncryptedWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ImagebuilderDistributionConfigurationEncryptedWithCMK.py)                     |
|  292 | CKV_AWS_200     | resource | aws_imagebuilder_image_recipe                                    | Ensure that Image Recipe EBS Disk are encrypted with CMK                                                                                                                                                 | Terraform | [ImagebuilderImageRecipeEBSEncrypted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ImagebuilderImageRecipeEBSEncrypted.py)                                                         |
|  293 | CKV_AWS_201     | resource | aws_memorydb_cluster                                             | Ensure MemoryDB is encrypted at rest using KMS CMKs                                                                                                                                                      | Terraform | [MemoryDBEncryptionWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/MemoryDBEncryptionWithCMK.py)                                                                             |
|  294 | CKV_AWS_202     | resource | aws_memorydb_cluster                                             | Ensure MemoryDB data is encrypted in transit                                                                                                                                                             | Terraform | [MemoryDBClusterIntransitEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/MemoryDBClusterIntransitEncryption.py)                                                           |
|  295 | CKV_AWS_203     | resource | aws_fsx_openzfs_file_system                                      | Ensure resource is encrypted by KMS using a customer managed Key (CMK)                                                                                                                                   | Terraform | [FSXOpenZFSFileSystemEncryptedWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/FSXOpenZFSFileSystemEncryptedWithCMK.py)                                                       |
|  296 | CKV_AWS_204     | resource | aws_ami                                                          | Ensure AMIs are encrypted using KMS CMKs                                                                                                                                                                 | Terraform | [AMIEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/AMIEncryption.py)                                                                                                     |
|  297 | CKV_AWS_205     | resource | aws_ami_launch_permission                                        | Ensure to Limit AMI launch Permissions                                                                                                                                                                   | Terraform | [AMILaunchIsShared.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/AMILaunchIsShared.py)                                                                                             |
|  298 | CKV_AWS_206     | resource | aws_api_gateway_domain_name                                      | Ensure API Gateway Domain uses a modern security Policy                                                                                                                                                  | Terraform | [APIGatewayDomainNameTLS.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/APIGatewayDomainNameTLS.py)                                                                                 |
|  299 | CKV_AWS_207     | resource | aws_mq_broker                                                    | Ensure MQ Broker minor version updates are enabled                                                                                                                                                       | Terraform | [MQBrokerMinorAutoUpgrade.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/MQBrokerMinorAutoUpgrade.py)                                                                               |
|  300 | CKV_AWS_208     | resource | aws_mq_broker                                                    | Ensure MQ Broker version is current                                                                                                                                                                      | Terraform | [MQBrokerVersion.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/MQBrokerVersion.py)                                                                                                 |
|  301 | CKV_AWS_208     | resource | aws_mq_configuration                                             | Ensure MQ Broker version is current                                                                                                                                                                      | Terraform | [MQBrokerVersion.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/MQBrokerVersion.py)                                                                                                 |
|  302 | CKV_AWS_209     | resource | aws_mq_broker                                                    | Ensure MQ broker encrypted by KMS using a customer managed Key (CMK)                                                                                                                                     | Terraform | [MQBrokerEncryptedWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/MQBrokerEncryptedWithCMK.py)                                                                               |
|  303 | CKV_AWS_210     | resource | aws_batch_job_definition                                         | Batch job does not define a privileged container                                                                                                                                                         | Terraform | [BatchJobIsNotPrivileged.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/BatchJobIsNotPrivileged.py)                                                                                 |
|  304 | CKV_AWS_211     | resource | aws_db_instance                                                  | Ensure RDS uses a modern CaCert                                                                                                                                                                          | Terraform | [RDSCACertIsRecent.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RDSCACertIsRecent.py)                                                                                             |
|  305 | CKV_AWS_212     | resource | aws_dms_replication_instance                                     | Ensure DMS replication instance is encrypted by KMS using a customer managed Key (CMK)                                                                                                                   | Terraform | [DMSReplicationInstanceEncryptedWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/DMSReplicationInstanceEncryptedWithCMK.py)                                                   |
|  306 | CKV_AWS_213     | resource | aws_load_balancer_policy                                         | Ensure ELB Policy uses only secure protocols                                                                                                                                                             | Terraform | [ELBPolicyUsesSecureProtocols.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ELBPolicyUsesSecureProtocols.py)                                                                       |
|  307 | CKV_AWS_214     | resource | aws_appsync_api_cache                                            | Ensure AppSync API Cache is encrypted at rest                                                                                                                                                            | Terraform | [AppsyncAPICacheEncryptionAtRest.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/AppsyncAPICacheEncryptionAtRest.py)                                                                 |
|  308 | CKV_AWS_215     | resource | aws_appsync_api_cache                                            | Ensure AppSync API Cache is encrypted in transit                                                                                                                                                         | Terraform | [AppsyncAPICacheEncryptionInTransit.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/AppsyncAPICacheEncryptionInTransit.py)                                                           |
|  309 | CKV_AWS_216     | resource | aws_cloudfront_distribution                                      | Ensure CloudFront distribution is enabled                                                                                                                                                                | Terraform | [CloudfrontDistributionEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/CloudfrontDistributionEnabled.py)                                                                     |
|  310 | CKV_AWS_217     | resource | aws_api_gateway_deployment                                       | Ensure Create before destroy for API deployments                                                                                                                                                         | Terraform | [APIGatewayDeploymentCreateBeforeDestroy.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/APIGatewayDeploymentCreateBeforeDestroy.py)                                                 |
|  311 | CKV_AWS_218     | resource | aws_cloudsearch_domain                                           | Ensure that CloudSearch is using latest TLS                                                                                                                                                              | Terraform | [CloudsearchDomainTLS.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/CloudsearchDomainTLS.py)                                                                                       |
|  312 | CKV_AWS_219     | resource | aws_codepipeline                                                 | Ensure CodePipeline Artifact store is using a KMS CMK                                                                                                                                                    | Terraform | [CodePipelineArtifactsEncrypted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/CodePipelineArtifactsEncrypted.py)                                                                   |
|  313 | CKV_AWS_220     | resource | aws_cloudsearch_domain                                           | Ensure that CloudSearch is using https                                                                                                                                                                   | Terraform | [CloudsearchDomainEnforceHttps.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/CloudsearchDomainEnforceHttps.py)                                                                     |
|  314 | CKV_AWS_221     | resource | aws_codeartifact_domain                                          | Ensure CodeArtifact Domain is encrypted by KMS using a customer managed Key (CMK)                                                                                                                        | Terraform | [CodeArtifactDomainEncryptedWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/CodeArtifactDomainEncryptedWithCMK.py)                                                           |
|  315 | CKV_AWS_222     | resource | aws_dms_replication_instance                                     | Ensure DMS replication instance gets all minor upgrade automatically                                                                                                                                     | Terraform | [DMSReplicationInstanceMinorUpgrade.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/DMSReplicationInstanceMinorUpgrade.py)                                                           |
|  316 | CKV_AWS_223     | resource | aws_ecs_cluster                                                  | Ensure ECS Cluster enables logging of ECS Exec                                                                                                                                                           | Terraform | [ECSClusterLoggingEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ECSClusterLoggingEnabled.py)                                                                               |
|  317 | CKV_AWS_224     | resource | aws_ecs_cluster                                                  | Ensure ECS Cluster logging is enabled and client to container communication uses CMK                                                                                                                     | Terraform | [ECSClusterLoggingEncryptedWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ECSClusterLoggingEncryptedWithCMK.py)                                                             |
|  318 | CKV_AWS_225     | resource | aws_api_gateway_method_settings                                  | Ensure API Gateway method setting caching is enabled                                                                                                                                                     | Terraform | [APIGatewayMethodSettingsCacheEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/APIGatewayMethodSettingsCacheEnabled.py)                                                       |
|  319 | CKV_AWS_226     | resource | aws_db_instance                                                  | Ensure DB instance gets all minor upgrades automatically                                                                                                                                                 | Terraform | [DBInstanceMinorUpgrade.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/DBInstanceMinorUpgrade.py)                                                                                   |
|  320 | CKV_AWS_226     | resource | aws_rds_cluster_instance                                         | Ensure DB instance gets all minor upgrades automatically                                                                                                                                                 | Terraform | [DBInstanceMinorUpgrade.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/DBInstanceMinorUpgrade.py)                                                                                   |
|  321 | CKV_AWS_227     | resource | aws_kms_key                                                      | Ensure KMS key is enabled                                                                                                                                                                                | Terraform | [KMSKeyIsEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/KMSKeyIsEnabled.py)                                                                                                 |
|  322 | CKV_AWS_228     | resource | aws_elasticsearch_domain                                         | Verify Elasticsearch domain is using an up to date TLS policy                                                                                                                                            | Terraform | [ElasticsearchTLSPolicy.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ElasticsearchTLSPolicy.py)                                                                                   |
|  323 | CKV_AWS_228     | resource | aws_opensearch_domain                                            | Verify Elasticsearch domain is using an up to date TLS policy                                                                                                                                            | Terraform | [ElasticsearchTLSPolicy.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ElasticsearchTLSPolicy.py)                                                                                   |
|  324 | CKV_AWS_229     | resource | aws_network_acl                                                  | Ensure no NACL allow ingress from 0.0.0.0:0 to port 21                                                                                                                                                   | Terraform | [NetworkACLUnrestrictedIngress21.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/NetworkACLUnrestrictedIngress21.py)                                                                 |
|  325 | CKV_AWS_229     | resource | aws_network_acl_rule                                             | Ensure no NACL allow ingress from 0.0.0.0:0 to port 21                                                                                                                                                   | Terraform | [NetworkACLUnrestrictedIngress21.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/NetworkACLUnrestrictedIngress21.py)                                                                 |
|  326 | CKV_AWS_230     | resource | aws_network_acl                                                  | Ensure no NACL allow ingress from 0.0.0.0:0 to port 20                                                                                                                                                   | Terraform | [NetworkACLUnrestrictedIngress20.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/NetworkACLUnrestrictedIngress20.py)                                                                 |
|  327 | CKV_AWS_230     | resource | aws_network_acl_rule                                             | Ensure no NACL allow ingress from 0.0.0.0:0 to port 20                                                                                                                                                   | Terraform | [NetworkACLUnrestrictedIngress20.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/NetworkACLUnrestrictedIngress20.py)                                                                 |
|  328 | CKV_AWS_231     | resource | aws_network_acl                                                  | Ensure no NACL allow ingress from 0.0.0.0:0 to port 3389                                                                                                                                                 | Terraform | [NetworkACLUnrestrictedIngress3389.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/NetworkACLUnrestrictedIngress3389.py)                                                             |
|  329 | CKV_AWS_231     | resource | aws_network_acl_rule                                             | Ensure no NACL allow ingress from 0.0.0.0:0 to port 3389                                                                                                                                                 | Terraform | [NetworkACLUnrestrictedIngress3389.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/NetworkACLUnrestrictedIngress3389.py)                                                             |
|  330 | CKV_AWS_232     | resource | aws_network_acl                                                  | Ensure no NACL allow ingress from 0.0.0.0:0 to port 22                                                                                                                                                   | Terraform | [NetworkACLUnrestrictedIngress22.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/NetworkACLUnrestrictedIngress22.py)                                                                 |
|  331 | CKV_AWS_232     | resource | aws_network_acl_rule                                             | Ensure no NACL allow ingress from 0.0.0.0:0 to port 22                                                                                                                                                   | Terraform | [NetworkACLUnrestrictedIngress22.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/NetworkACLUnrestrictedIngress22.py)                                                                 |
|  332 | CKV_AWS_233     | resource | aws_acm_certificate                                              | Ensure Create before destroy for ACM certificates                                                                                                                                                        | Terraform | [ACMCertCreateBeforeDestroy.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ACMCertCreateBeforeDestroy.py)                                                                           |
|  333 | CKV_AWS_234     | resource | aws_acm_certificate                                              | Verify logging preference for ACM certificates                                                                                                                                                           | Terraform | [ACMCertSetLoggingPreference.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ACMCertSetLoggingPreference.py)                                                                         |
|  334 | CKV_AWS_235     | resource | aws_ami_copy                                                     | Ensure that copied AMIs are encrypted                                                                                                                                                                    | Terraform | [AMICopyIsEncrypted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/AMICopyIsEncrypted.py)                                                                                           |
|  335 | CKV_AWS_236     | resource | aws_ami_copy                                                     | Ensure AMI copying uses a CMK                                                                                                                                                                            | Terraform | [AMICopyUsesCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/AMICopyUsesCMK.py)                                                                                                   |
|  336 | CKV_AWS_237     | resource | aws_api_gateway_rest_api                                         | Ensure Create before destroy for API Gateway                                                                                                                                                             | Terraform | [APIGatewayCreateBeforeDestroy.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/APIGatewayCreateBeforeDestroy.py)                                                                     |
|  337 | CKV_AWS_238     | resource | aws_guardduty_detector                                           | Ensure that GuardDuty detector is enabled                                                                                                                                                                | Terraform | [GuarddutyDetectorEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/GuarddutyDetectorEnabled.py)                                                                               |
|  338 | CKV_AWS_239     | resource | aws_dax_cluster                                                  | Ensure DAX cluster endpoint is using TLS                                                                                                                                                                 | Terraform | [DAXEndpointTLS.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/DAXEndpointTLS.py)                                                                                                   |
|  339 | CKV_AWS_240     | resource | aws_kinesis_firehose_delivery_stream                             | Ensure Kinesis Firehose delivery stream is encrypted                                                                                                                                                     | Terraform | [KinesisFirehoseDeliveryStreamSSE.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/KinesisFirehoseDeliveryStreamSSE.py)                                                               |
|  340 | CKV_AWS_241     | resource | aws_kinesis_firehose_delivery_stream                             | Ensure that Kinesis Firehose Delivery Streams are encrypted with CMK                                                                                                                                     | Terraform | [KinesisFirehoseDeliveryStreamUsesCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/KinesisFirehoseDeliveryStreamUsesCMK.py)                                                       |
|  341 | CKV_AWS_242     | resource | aws_mwaa_environment                                             | Ensure MWAA environment has scheduler logs enabled                                                                                                                                                       | Terraform | [MWAASchedulerLogsEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/MWAASchedulerLogsEnabled.py)                                                                               |
|  342 | CKV_AWS_243     | resource | aws_mwaa_environment                                             | Ensure MWAA environment has worker logs enabled                                                                                                                                                          | Terraform | [MWAAWorkerLogsEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/MWAAWorkerLogsEnabled.py)                                                                                     |
|  343 | CKV_AWS_244     | resource | aws_mwaa_environment                                             | Ensure MWAA environment has webserver logs enabled                                                                                                                                                       | Terraform | [MWAAWebserverLogsEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/MWAAWebserverLogsEnabled.py)                                                                               |
|  344 | CKV_AWS_245     | resource | aws_db_instance_automated_backups_replication                    | Ensure replicated backups are encrypted at rest using KMS CMKs                                                                                                                                           | Terraform | [RDSInstanceAutoBackupEncryptionWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RDSInstanceAutoBackupEncryptionWithCMK.py)                                                   |
|  345 | CKV_AWS_246     | resource | aws_rds_cluster_activity_stream                                  | Ensure RDS Cluster activity streams are encrypted using KMS CMKs                                                                                                                                         | Terraform | [RDSClusterActivityStreamEncryptedWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RDSClusterActivityStreamEncryptedWithCMK.py)                                               |
|  346 | CKV_AWS_247     | resource | aws_elasticsearch_domain                                         | Ensure all data stored in the Elasticsearch is encrypted with a CMK                                                                                                                                      | Terraform | [ElasticsearchEncryptionWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ElasticsearchEncryptionWithCMK.py)                                                                   |
|  347 | CKV_AWS_247     | resource | aws_opensearch_domain                                            | Ensure all data stored in the Elasticsearch is encrypted with a CMK                                                                                                                                      | Terraform | [ElasticsearchEncryptionWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ElasticsearchEncryptionWithCMK.py)                                                                   |
|  348 | CKV_AWS_248     | resource | aws_elasticsearch_domain                                         | Ensure that Elasticsearch is not using the default Security Group                                                                                                                                        | Terraform | [ElasticsearchDefaultSG.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ElasticsearchDefaultSG.py)                                                                                   |
|  349 | CKV_AWS_248     | resource | aws_opensearch_domain                                            | Ensure that Elasticsearch is not using the default Security Group                                                                                                                                        | Terraform | [ElasticsearchDefaultSG.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ElasticsearchDefaultSG.py)                                                                                   |
|  350 | CKV_AWS_249     | resource | aws_ecs_task_definition                                          | Ensure that the Execution Role ARN and the Task Role ARN are different in ECS Task definitions                                                                                                           | Terraform | [ECSTaskDefinitionRoleCheck.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ECSTaskDefinitionRoleCheck.py)                                                                           |
|  351 | CKV_AWS_250     | resource | aws_db_instance                                                  | Ensure that RDS PostgreSQL instances use a non vulnerable version with the log_fdw extension (https://aws.amazon.com/security/security-bulletins/AWS-2022-004/)                                          | Terraform | [RDSPostgreSQLLogFDWExtension.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RDSPostgreSQLLogFDWExtension.py)                                                                       |
|  352 | CKV_AWS_250     | resource | aws_rds_cluster                                                  | Ensure that RDS PostgreSQL instances use a non vulnerable version with the log_fdw extension (https://aws.amazon.com/security/security-bulletins/AWS-2022-004/)                                          | Terraform | [RDSPostgreSQLLogFDWExtension.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RDSPostgreSQLLogFDWExtension.py)                                                                       |
|  353 | CKV_AWS_251     | resource | aws_cloudtrail                                                   | Ensure CloudTrail logging is enabled                                                                                                                                                                     | Terraform | [CloudtrailEnableLogging.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/CloudtrailEnableLogging.py)                                                                                 |
|  354 | CKV_AWS_252     | resource | aws_cloudtrail                                                   | Ensure CloudTrail defines an SNS Topic                                                                                                                                                                   | Terraform | [CloudtrailDefinesSNSTopic.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/CloudtrailDefinesSNSTopic.py)                                                                             |
|  355 | CKV_AWS_253     | resource | aws_dlm_lifecycle_policy                                         | Ensure DLM cross region events are encrypted                                                                                                                                                             | Terraform | [DLMEventsCrossRegionEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/DLMEventsCrossRegionEncryption.py)                                                                   |
|  356 | CKV_AWS_254     | resource | aws_dlm_lifecycle_policy                                         | Ensure DLM cross region events are encrypted with Customer Managed Key                                                                                                                                   | Terraform | [DLMEventsCrossRegionEncryptionWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/DLMEventsCrossRegionEncryptionWithCMK.py)                                                     |
|  357 | CKV_AWS_255     | resource | aws_dlm_lifecycle_policy                                         | Ensure DLM cross region schedules are encrypted                                                                                                                                                          | Terraform | [DLMScheduleCrossRegionEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/DLMScheduleCrossRegionEncryption.py)                                                               |
|  358 | CKV_AWS_256     | resource | aws_dlm_lifecycle_policy                                         | Ensure DLM cross region schedules are encrypted using a Customer Managed Key                                                                                                                             | Terraform | [DLMScheduleCrossRegionEncryptionWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/DLMScheduleCrossRegionEncryptionWithCMK.py)                                                 |
|  359 | CKV_AWS_257     | resource | aws_codecommit_approval_rule_template                            | Ensure CodeCommit branch changes have at least 2 approvals                                                                                                                                               | Terraform | [CodecommitApprovalsRulesRequireMin2.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/CodecommitApprovalsRulesRequireMin2.py)                                                         |
|  360 | CKV_AWS_258     | resource | aws_lambda_function_url                                          | Ensure that Lambda function URLs AuthType is not None                                                                                                                                                    | Terraform | [LambdaFunctionURLAuth.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/LambdaFunctionURLAuth.py)                                                                                     |
|  361 | CKV_AWS_259     | resource | aws_cloudfront_response_headers_policy                           | Ensure CloudFront response header policy enforces Strict Transport Security                                                                                                                              | Terraform | [CloudFrontResponseHeaderStrictTransportSecurity.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/CloudFrontResponseHeaderStrictTransportSecurity.py)                                 |
|  362 | CKV_AWS_260     | resource | aws_security_group                                               | Ensure no security groups allow ingress from 0.0.0.0:0 to port 80                                                                                                                                        | Terraform | [SecurityGroupUnrestrictedIngress80.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SecurityGroupUnrestrictedIngress80.py)                                                           |
|  363 | CKV_AWS_260     | resource | aws_security_group_rule                                          | Ensure no security groups allow ingress from 0.0.0.0:0 to port 80                                                                                                                                        | Terraform | [SecurityGroupUnrestrictedIngress80.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SecurityGroupUnrestrictedIngress80.py)                                                           |
|  364 | CKV_AWS_260     | resource | aws_vpc_security_group_ingress_rule                              | Ensure no security groups allow ingress from 0.0.0.0:0 to port 80                                                                                                                                        | Terraform | [SecurityGroupUnrestrictedIngress80.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SecurityGroupUnrestrictedIngress80.py)                                                           |
|  365 | CKV_AWS_261     | resource | aws_alb_target_group                                             | Ensure HTTP HTTPS Target group defines Healthcheck                                                                                                                                                       | Terraform | [LBTargetGroupsDefinesHealthcheck.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/LBTargetGroupsDefinesHealthcheck.py)                                                               |
|  366 | CKV_AWS_261     | resource | aws_lb_target_group                                              | Ensure HTTP HTTPS Target group defines Healthcheck                                                                                                                                                       | Terraform | [LBTargetGroupsDefinesHealthcheck.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/LBTargetGroupsDefinesHealthcheck.py)                                                               |
|  367 | CKV_AWS_262     | resource | aws_kendra_index                                                 | Ensure Kendra index Server side encryption uses CMK                                                                                                                                                      | Terraform | [KendraIndexSSEUsesCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/KendraIndexSSEUsesCMK.py)                                                                                     |
|  368 | CKV_AWS_263     | resource | aws_appflow_flow                                                 | Ensure AppFlow flow uses CMK                                                                                                                                                                             | Terraform | [AppFlowUsesCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/AppFlowUsesCMK.py)                                                                                                   |
|  369 | CKV_AWS_264     | resource | aws_appflow_connector_profile                                    | Ensure AppFlow connector profile uses CMK                                                                                                                                                                | Terraform | [AppFlowConnectorProfileUsesCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/AppFlowConnectorProfileUsesCMK.py)                                                                   |
|  370 | CKV_AWS_265     | resource | aws_keyspaces_table                                              | Ensure Keyspaces Table uses CMK                                                                                                                                                                          | Terraform | [KeyspacesTableUsesCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/KeyspacesTableUsesCMK.py)                                                                                     |
|  371 | CKV_AWS_266     | resource | aws_db_snapshot_copy                                             | Ensure DB Snapshot copy uses CMK                                                                                                                                                                         | Terraform | [DBSnapshotCopyUsesCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/DBSnapshotCopyUsesCMK.py)                                                                                     |
|  372 | CKV_AWS_267     | resource | aws_comprehend_entity_recognizer                                 | Ensure that Comprehend Entity Recognizer's model is encrypted by KMS using a customer managed Key (CMK)                                                                                                  | Terraform | [ComprehendEntityRecognizerModelUsesCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ComprehendEntityRecognizerModelUsesCMK.py)                                                   |
|  373 | CKV_AWS_268     | resource | aws_comprehend_entity_recognizer                                 | Ensure that Comprehend Entity Recognizer's volume is encrypted by KMS using a customer managed Key (CMK)                                                                                                 | Terraform | [ComprehendEntityRecognizerVolumeUsesCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ComprehendEntityRecognizerVolumeUsesCMK.py)                                                 |
|  374 | CKV_AWS_269     | resource | aws_connect_instance_storage_config                              | Ensure Connect Instance Kinesis Video Stream Storage Config uses CMK                                                                                                                                     | Terraform | [ConnectInstanceKinesisVideoStreamStorageConfigUsesCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ConnectInstanceKinesisVideoStreamStorageConfigUsesCMK.py)                     |
|  375 | CKV_AWS_270     | resource | aws_connect_instance_storage_config                              | Ensure Connect Instance S3 Storage Config uses CMK                                                                                                                                                       | Terraform | [ConnectInstanceS3StorageConfigUsesCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ConnectInstanceS3StorageConfigUsesCMK.py)                                                     |
|  376 | CKV_AWS_271     | resource | aws_dynamodb_table_replica                                       | Ensure DynamoDB table replica KMS encryption uses CMK                                                                                                                                                    | Terraform | [DynamoDBTableReplicaKMSUsesCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/DynamoDBTableReplicaKMSUsesCMK.py)                                                                   |
|  377 | CKV_AWS_272     | resource | aws_lambda_function                                              | Ensure AWS Lambda function is configured to validate code-signing                                                                                                                                        | Terraform | [LambdaCodeSigningConfigured.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/LambdaCodeSigningConfigured.py)                                                                         |
|  378 | CKV_AWS_273     | resource | aws_iam_user                                                     | Ensure access is controlled through SSO and not AWS IAM defined users                                                                                                                                    | Terraform | [IAMUserNotUsedForAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMUserNotUsedForAccess.py)                                                                                 |
|  379 | CKV_AWS_274     | resource | aws_iam_group_policy_attachment                                  | Disallow IAM roles, users, and groups from using the AWS AdministratorAccess policy                                                                                                                      | Terraform | [IAMManagedAdminPolicy.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMManagedAdminPolicy.py)                                                                                     |
|  380 | CKV_AWS_274     | resource | aws_iam_policy_attachment                                        | Disallow IAM roles, users, and groups from using the AWS AdministratorAccess policy                                                                                                                      | Terraform | [IAMManagedAdminPolicy.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMManagedAdminPolicy.py)                                                                                     |
|  381 | CKV_AWS_274     | resource | aws_iam_role                                                     | Disallow IAM roles, users, and groups from using the AWS AdministratorAccess policy                                                                                                                      | Terraform | [IAMManagedAdminPolicy.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMManagedAdminPolicy.py)                                                                                     |
|  382 | CKV_AWS_274     | resource | aws_iam_role_policy_attachment                                   | Disallow IAM roles, users, and groups from using the AWS AdministratorAccess policy                                                                                                                      | Terraform | [IAMManagedAdminPolicy.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMManagedAdminPolicy.py)                                                                                     |
|  383 | CKV_AWS_274     | resource | aws_iam_user_policy_attachment                                   | Disallow IAM roles, users, and groups from using the AWS AdministratorAccess policy                                                                                                                      | Terraform | [IAMManagedAdminPolicy.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMManagedAdminPolicy.py)                                                                                     |
|  384 | CKV_AWS_274     | resource | aws_ssoadmin_managed_policy_attachment                           | Disallow IAM roles, users, and groups from using the AWS AdministratorAccess policy                                                                                                                      | Terraform | [IAMManagedAdminPolicy.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMManagedAdminPolicy.py)                                                                                     |
|  385 | CKV_AWS_275     | data     | aws_iam_policy                                                   | Disallow policies from using the AWS AdministratorAccess policy                                                                                                                                          | Terraform | [IAMManagedAdminPolicy.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/data/aws/IAMManagedAdminPolicy.py)                                                                                         |
|  386 | CKV_AWS_276     | resource | aws_api_gateway_method_settings                                  | Ensure Data Trace is not enabled in API Gateway Method Settings                                                                                                                                          | Terraform | [APIGatewayMethodSettingsDataTrace.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/APIGatewayMethodSettingsDataTrace.py)                                                             |
|  387 | CKV_AWS_277     | resource | aws_security_group                                               | Ensure no security groups allow ingress from 0.0.0.0:0 to port -1                                                                                                                                        | Terraform | [SecurityGroupUnrestrictedIngressAny.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SecurityGroupUnrestrictedIngressAny.py)                                                         |
|  388 | CKV_AWS_277     | resource | aws_security_group_rule                                          | Ensure no security groups allow ingress from 0.0.0.0:0 to port -1                                                                                                                                        | Terraform | [SecurityGroupUnrestrictedIngressAny.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SecurityGroupUnrestrictedIngressAny.py)                                                         |
|  389 | CKV_AWS_277     | resource | aws_vpc_security_group_ingress_rule                              | Ensure no security groups allow ingress from 0.0.0.0:0 to port -1                                                                                                                                        | Terraform | [SecurityGroupUnrestrictedIngressAny.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SecurityGroupUnrestrictedIngressAny.py)                                                         |
|  390 | CKV_AWS_278     | resource | aws_memorydb_snapshot                                            | Ensure MemoryDB snapshot is encrypted by KMS using a customer managed Key (CMK)                                                                                                                          | Terraform | [MemoryDBSnapshotEncryptionWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/MemoryDBSnapshotEncryptionWithCMK.py)                                                             |
|  391 | CKV_AWS_279     | resource | aws_neptune_cluster_snapshot                                     | Ensure Neptune snapshot is securely encrypted                                                                                                                                                            | Terraform | [NeptuneClusterSnapshotEncrypted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/NeptuneClusterSnapshotEncrypted.py)                                                                 |
|  392 | CKV_AWS_280     | resource | aws_neptune_cluster_snapshot                                     | Ensure Neptune snapshot is encrypted by KMS using a customer managed Key (CMK)                                                                                                                           | Terraform | [NeptuneClusterSnapshotEncryptedWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/NeptuneClusterSnapshotEncryptedWithCMK.py)                                                   |
|  393 | CKV_AWS_281     | resource | aws_redshift_snapshot_copy_grant                                 | Ensure RedShift snapshot copy is encrypted by KMS using a customer managed Key (CMK)                                                                                                                     | Terraform | [RedshiftClusterSnapshotCopyGrantEncryptedWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RedshiftClusterSnapshotCopyGrantEncryptedWithCMK.py)                               |
|  394 | CKV_AWS_282     | resource | aws_redshiftserverless_namespace                                 | Ensure that Redshift Serverless namespace is encrypted by KMS using a customer managed key (CMK)                                                                                                         | Terraform | [RedshiftServerlessNamespaceKMSKey.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RedshiftServerlessNamespaceKMSKey.py)                                                             |
|  395 | CKV_AWS_283     | data     | aws_iam_policy_document                                          | Ensure no IAM policies documents allow ALL or any AWS principal permissions to the resource                                                                                                              | Terraform | [IAMPublicActionsPolicy.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/data/aws/IAMPublicActionsPolicy.py)                                                                                       |
|  396 | CKV_AWS_284     | resource | aws_sfn_state_machine                                            | Ensure State Machine has X-Ray tracing enabled                                                                                                                                                           | Terraform | [StateMachineXray.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/StateMachineXray.py)                                                                                               |
|  397 | CKV_AWS_285     | resource | aws_sfn_state_machine                                            | Ensure State Machine has execution history logging enabled                                                                                                                                               | Terraform | [StateMachineLoggingExecutionHistory.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/StateMachineLoggingExecutionHistory.py)                                                         |
|  398 | CKV_AWS_286     | resource | aws_iam_group_policy                                             | Ensure IAM policies does not allow privilege escalation                                                                                                                                                  | Terraform | [IAMPrivilegeEscalation.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMPrivilegeEscalation.py)                                                                                   |
|  399 | CKV_AWS_286     | resource | aws_iam_policy                                                   | Ensure IAM policies does not allow privilege escalation                                                                                                                                                  | Terraform | [IAMPrivilegeEscalation.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMPrivilegeEscalation.py)                                                                                   |
|  400 | CKV_AWS_286     | resource | aws_iam_role_policy                                              | Ensure IAM policies does not allow privilege escalation                                                                                                                                                  | Terraform | [IAMPrivilegeEscalation.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMPrivilegeEscalation.py)                                                                                   |
|  401 | CKV_AWS_286     | resource | aws_iam_user_policy                                              | Ensure IAM policies does not allow privilege escalation                                                                                                                                                  | Terraform | [IAMPrivilegeEscalation.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMPrivilegeEscalation.py)                                                                                   |
|  402 | CKV_AWS_286     | resource | aws_ssoadmin_permission_set_inline_policy                        | Ensure IAM policies does not allow privilege escalation                                                                                                                                                  | Terraform | [IAMPrivilegeEscalation.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMPrivilegeEscalation.py)                                                                                   |
|  403 | CKV_AWS_287     | resource | aws_iam_group_policy                                             | Ensure IAM policies does not allow credentials exposure                                                                                                                                                  | Terraform | [IAMCredentialsExposure.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMCredentialsExposure.py)                                                                                   |
|  404 | CKV_AWS_287     | resource | aws_iam_policy                                                   | Ensure IAM policies does not allow credentials exposure                                                                                                                                                  | Terraform | [IAMCredentialsExposure.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMCredentialsExposure.py)                                                                                   |
|  405 | CKV_AWS_287     | resource | aws_iam_role_policy                                              | Ensure IAM policies does not allow credentials exposure                                                                                                                                                  | Terraform | [IAMCredentialsExposure.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMCredentialsExposure.py)                                                                                   |
|  406 | CKV_AWS_287     | resource | aws_iam_user_policy                                              | Ensure IAM policies does not allow credentials exposure                                                                                                                                                  | Terraform | [IAMCredentialsExposure.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMCredentialsExposure.py)                                                                                   |
|  407 | CKV_AWS_287     | resource | aws_ssoadmin_permission_set_inline_policy                        | Ensure IAM policies does not allow credentials exposure                                                                                                                                                  | Terraform | [IAMCredentialsExposure.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMCredentialsExposure.py)                                                                                   |
|  408 | CKV_AWS_288     | resource | aws_iam_group_policy                                             | Ensure IAM policies does not allow data exfiltration                                                                                                                                                     | Terraform | [IAMDataExfiltration.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMDataExfiltration.py)                                                                                         |
|  409 | CKV_AWS_288     | resource | aws_iam_policy                                                   | Ensure IAM policies does not allow data exfiltration                                                                                                                                                     | Terraform | [IAMDataExfiltration.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMDataExfiltration.py)                                                                                         |
|  410 | CKV_AWS_288     | resource | aws_iam_role_policy                                              | Ensure IAM policies does not allow data exfiltration                                                                                                                                                     | Terraform | [IAMDataExfiltration.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMDataExfiltration.py)                                                                                         |
|  411 | CKV_AWS_288     | resource | aws_iam_user_policy                                              | Ensure IAM policies does not allow data exfiltration                                                                                                                                                     | Terraform | [IAMDataExfiltration.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMDataExfiltration.py)                                                                                         |
|  412 | CKV_AWS_288     | resource | aws_ssoadmin_permission_set_inline_policy                        | Ensure IAM policies does not allow data exfiltration                                                                                                                                                     | Terraform | [IAMDataExfiltration.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMDataExfiltration.py)                                                                                         |
|  413 | CKV_AWS_289     | resource | aws_iam_group_policy                                             | Ensure IAM policies does not allow permissions management / resource exposure without constraints                                                                                                        | Terraform | [IAMPermissionsManagement.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMPermissionsManagement.py)                                                                               |
|  414 | CKV_AWS_289     | resource | aws_iam_policy                                                   | Ensure IAM policies does not allow permissions management / resource exposure without constraints                                                                                                        | Terraform | [IAMPermissionsManagement.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMPermissionsManagement.py)                                                                               |
|  415 | CKV_AWS_289     | resource | aws_iam_role_policy                                              | Ensure IAM policies does not allow permissions management / resource exposure without constraints                                                                                                        | Terraform | [IAMPermissionsManagement.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMPermissionsManagement.py)                                                                               |
|  416 | CKV_AWS_289     | resource | aws_iam_user_policy                                              | Ensure IAM policies does not allow permissions management / resource exposure without constraints                                                                                                        | Terraform | [IAMPermissionsManagement.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMPermissionsManagement.py)                                                                               |
|  417 | CKV_AWS_289     | resource | aws_ssoadmin_permission_set_inline_policy                        | Ensure IAM policies does not allow permissions management / resource exposure without constraints                                                                                                        | Terraform | [IAMPermissionsManagement.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMPermissionsManagement.py)                                                                               |
|  418 | CKV_AWS_290     | resource | aws_iam_group_policy                                             | Ensure IAM policies does not allow write access without constraints                                                                                                                                      | Terraform | [IAMWriteAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMWriteAccess.py)                                                                                                   |
|  419 | CKV_AWS_290     | resource | aws_iam_policy                                                   | Ensure IAM policies does not allow write access without constraints                                                                                                                                      | Terraform | [IAMWriteAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMWriteAccess.py)                                                                                                   |
|  420 | CKV_AWS_290     | resource | aws_iam_role_policy                                              | Ensure IAM policies does not allow write access without constraints                                                                                                                                      | Terraform | [IAMWriteAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMWriteAccess.py)                                                                                                   |
|  421 | CKV_AWS_290     | resource | aws_iam_user_policy                                              | Ensure IAM policies does not allow write access without constraints                                                                                                                                      | Terraform | [IAMWriteAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMWriteAccess.py)                                                                                                   |
|  422 | CKV_AWS_290     | resource | aws_ssoadmin_permission_set_inline_policy                        | Ensure IAM policies does not allow write access without constraints                                                                                                                                      | Terraform | [IAMWriteAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMWriteAccess.py)                                                                                                   |
|  423 | CKV_AWS_291     | resource | aws_msk_cluster                                                  | Ensure MSK nodes are private                                                                                                                                                                             | Terraform | [MSKClusterNodesArePrivate.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/MSKClusterNodesArePrivate.py)                                                                             |
|  424 | CKV_AWS_292     | resource | aws_docdb_global_cluster                                         | Ensure DocumentDB Global Cluster is encrypted at rest (default is unencrypted)                                                                                                                           | Terraform | [DocDBGlobalClusterEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/DocDBGlobalClusterEncryption.py)                                                                       |
|  425 | CKV_AWS_293     | resource | aws_db_instance                                                  | Ensure that AWS database instances have deletion protection enabled                                                                                                                                      | Terraform | [RDSInstanceDeletionProtection.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RDSInstanceDeletionProtection.py)                                                                     |
|  426 | CKV_AWS_294     | resource | aws_cloudtrail_event_data_store                                  | Ensure CloudTrail Event Data Store uses CMK                                                                                                                                                              | Terraform | [CloudtrailEventDataStoreUsesCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/CloudtrailEventDataStoreUsesCMK.py)                                                                 |
|  427 | CKV_AWS_295     | resource | aws_datasync_location_object_storage                             | Ensure DataSync Location Object Storage doesn't expose secrets                                                                                                                                           | Terraform | [DatasyncLocationExposesSecrets.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/DatasyncLocationExposesSecrets.py)                                                                   |
|  428 | CKV_AWS_296     | resource | aws_dms_endpoint                                                 | Ensure DMS endpoint uses Customer Managed Key (CMK)                                                                                                                                                      | Terraform | [DMSEndpointUsesCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/DMSEndpointUsesCMK.py)                                                                                           |
|  429 | CKV_AWS_297     | resource | aws_scheduler_schedule                                           | Ensure EventBridge Scheduler Schedule uses Customer Managed Key (CMK)                                                                                                                                    | Terraform | [SchedulerScheduleUsesCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SchedulerScheduleUsesCMK.py)                                                                               |
|  430 | CKV_AWS_298     | resource | aws_dms_s3_endpoint                                              | Ensure DMS S3 uses Customer Managed Key (CMK)                                                                                                                                                            | Terraform | [DMSS3UsesCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/DMSS3UsesCMK.py)                                                                                                       |
|  431 | CKV_AWS_300     | resource | aws_s3_bucket_lifecycle_configuration                            | Ensure S3 lifecycle configuration sets period for aborting failed uploads                                                                                                                                | Terraform | [S3AbortIncompleteUploads.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/S3AbortIncompleteUploads.py)                                                                               |
|  432 | CKV_AWS_301     | resource | aws_lambda_permission                                            | Ensure that AWS Lambda function is not publicly accessible                                                                                                                                               | Terraform | [LambdaFunctionIsNotPublic.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/LambdaFunctionIsNotPublic.py)                                                                             |
|  433 | CKV_AWS_302     | resource | aws_db_snapshot                                                  | Ensure DB Snapshots are not Public                                                                                                                                                                       | Terraform | [DBSnapshotsArePrivate.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/DBSnapshotsArePrivate.py)                                                                                     |
|  434 | CKV_AWS_303     | resource | aws_ssm_document                                                 | Ensure SSM documents are not Public                                                                                                                                                                      | Terraform | [SSMDocumentsArePrivate.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SSMDocumentsArePrivate.py)                                                                                   |
|  435 | CKV_AWS_304     | resource | aws_secretsmanager_secret_rotation                               | Ensure Secrets Manager secrets should be rotated within 90 days                                                                                                                                          | Terraform | [SecretManagerSecret90days.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SecretManagerSecret90days.py)                                                                             |
|  436 | CKV_AWS_305     | resource | aws_cloudfront_distribution                                      | Ensure CloudFront distribution has a default root object configured                                                                                                                                      | Terraform | [CloudfrontDistributionDefaultRoot.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/CloudfrontDistributionDefaultRoot.py)                                                             |
|  437 | CKV_AWS_306     | resource | aws_sagemaker_notebook_instance                                  | Ensure SageMaker notebook instances should be launched into a custom VPC                                                                                                                                 | Terraform | [SagemakerNotebookInCustomVPC.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SagemakerNotebookInCustomVPC.py)                                                                       |
|  438 | CKV_AWS_307     | resource | aws_sagemaker_notebook_instance                                  | Ensure SageMaker Users should not have root access to SageMaker notebook instances                                                                                                                       | Terraform | [SagemakerNotebookRoot.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SagemakerNotebookRoot.py)                                                                                     |
|  439 | CKV_AWS_308     | resource | aws_api_gateway_method_settings                                  | Ensure API Gateway method setting caching is set to encrypted                                                                                                                                            | Terraform | [APIGatewayMethodSettingsCacheEncrypted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/APIGatewayMethodSettingsCacheEncrypted.py)                                                   |
|  440 | CKV_AWS_309     | resource | aws_apigatewayv2_route                                           | Ensure API GatewayV2 routes specify an authorization type                                                                                                                                                | Terraform | [APIGatewayV2RouteDefinesAuthorizationType.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/APIGatewayV2RouteDefinesAuthorizationType.py)                                             |
|  441 | CKV_AWS_310     | resource | aws_cloudfront_distribution                                      | Ensure CloudFront distributions should have origin failover configured                                                                                                                                   | Terraform | [CloudfrontDistributionOriginFailover.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/CloudfrontDistributionOriginFailover.py)                                                       |
|  442 | CKV_AWS_311     | resource | aws_codebuild_project                                            | Ensure that CodeBuild S3 logs are encrypted                                                                                                                                                              | Terraform | [CodebuildS3LogsEncrypted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/CodebuildS3LogsEncrypted.py)                                                                               |
|  443 | CKV_AWS_312     | resource | aws_elastic_beanstalk_environment                                | Ensure Elastic Beanstalk environments have enhanced health reporting enabled                                                                                                                             | Terraform | [ElasticBeanstalkUseEnhancedHealthChecks.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ElasticBeanstalkUseEnhancedHealthChecks.py)                                                 |
|  444 | CKV_AWS_313     | resource | aws_rds_cluster                                                  | Ensure RDS cluster configured to copy tags to snapshots                                                                                                                                                  | Terraform | [RDSClusterCopyTags.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RDSClusterCopyTags.py)                                                                                           |
|  445 | CKV_AWS_314     | resource | aws_codebuild_project                                            | Ensure CodeBuild project environments have a logging configuration                                                                                                                                       | Terraform | [CodebuildHasLogs.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/CodebuildHasLogs.py)                                                                                               |
|  446 | CKV_AWS_315     | resource | aws_autoscaling_group                                            | Ensure EC2 Auto Scaling groups use EC2 launch templates                                                                                                                                                  | Terraform | [AutoScalingLaunchTemplate.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/AutoScalingLaunchTemplate.py)                                                                             |
|  447 | CKV_AWS_316     | resource | aws_codebuild_project                                            | Ensure CodeBuild project environments do not have privileged mode enabled                                                                                                                                | Terraform | [CodeBuildPrivilegedMode.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/CodeBuildPrivilegedMode.py)                                                                                 |
|  448 | CKV_AWS_317     | resource | aws_elasticsearch_domain                                         | Ensure Elasticsearch Domain Audit Logging is enabled                                                                                                                                                     | Terraform | [ElasticsearchDomainAuditLogging.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ElasticsearchDomainAuditLogging.py)                                                                 |
|  449 | CKV_AWS_317     | resource | aws_opensearch_domain                                            | Ensure Elasticsearch Domain Audit Logging is enabled                                                                                                                                                     | Terraform | [ElasticsearchDomainAuditLogging.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ElasticsearchDomainAuditLogging.py)                                                                 |
|  450 | CKV_AWS_318     | resource | aws_elasticsearch_domain                                         | Ensure Elasticsearch domains are configured with at least three dedicated master nodes for HA                                                                                                            | Terraform | [ElasticsearchDomainHA.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ElasticsearchDomainHA.py)                                                                                     |
|  451 | CKV_AWS_318     | resource | aws_opensearch_domain                                            | Ensure Elasticsearch domains are configured with at least three dedicated master nodes for HA                                                                                                            | Terraform | [ElasticsearchDomainHA.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ElasticsearchDomainHA.py)                                                                                     |
|  452 | CKV_AWS_319     | resource | aws_cloudwatch_metric_alarm                                      | Ensure that CloudWatch alarm actions are enabled                                                                                                                                                         | Terraform | [CloudWatchAlarmsEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/CloudWatchAlarmsEnabled.py)                                                                                 |
|  453 | CKV_AWS_320     | resource | aws_redshift_cluster                                             | Ensure Redshift clusters do not use the default database name                                                                                                                                            | Terraform | [RedshiftClusterDatabaseName.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RedshiftClusterDatabaseName.py)                                                                         |
|  454 | CKV_AWS_321     | resource | aws_redshift_cluster                                             | Ensure Redshift clusters use enhanced VPC routing                                                                                                                                                        | Terraform | [RedshiftClusterUseEnhancedVPCRouting.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RedshiftClusterUseEnhancedVPCRouting.py)                                                       |
|  455 | CKV_AWS_322     | resource | aws_elasticache_cluster                                          | Ensure ElastiCache for Redis cache clusters have auto minor version upgrades enabled                                                                                                                     | Terraform | [ElasticCacheAutomaticMinorUpgrades.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ElasticCacheAutomaticMinorUpgrades.py)                                                           |
|  456 | CKV_AWS_323     | resource | aws_elasticache_cluster                                          | Ensure ElastiCache clusters do not use the default subnet group                                                                                                                                          | Terraform | [ElastiCacheHasCustomSubnet.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ElastiCacheHasCustomSubnet.py)                                                                           |
|  457 | CKV_AWS_324     | resource | aws_rds_cluster                                                  | Ensure that RDS Cluster log capture is enabled                                                                                                                                                           | Terraform | [RDSClusterLogging.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RDSClusterLogging.py)                                                                                             |
|  458 | CKV_AWS_325     | resource | aws_rds_cluster                                                  | Ensure that RDS Cluster audit logging is enabled for MySQL engine                                                                                                                                        | Terraform | [RDSClusterAuditLogging.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RDSClusterAuditLogging.py)                                                                                   |
|  459 | CKV_AWS_326     | resource | aws_rds_cluster                                                  | Ensure that RDS Aurora Clusters have backtracking enabled                                                                                                                                                | Terraform | [RDSClusterAuroraBacktrack.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RDSClusterAuroraBacktrack.py)                                                                             |
|  460 | CKV_AWS_327     | resource | aws_rds_cluster                                                  | Ensure RDS Clusters are encrypted using KMS CMKs                                                                                                                                                         | Terraform | [RDSClusterEncryptedWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RDSClusterEncryptedWithCMK.py)                                                                           |
|  461 | CKV_AWS_328     | resource | aws_alb                                                          | Ensure that ALB is configured with defensive or strictest desync mitigation mode                                                                                                                         | Terraform | [ALBDesyncMode.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ALBDesyncMode.py)                                                                                                     |
|  462 | CKV_AWS_328     | resource | aws_elb                                                          | Ensure that ALB is configured with defensive or strictest desync mitigation mode                                                                                                                         | Terraform | [ALBDesyncMode.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ALBDesyncMode.py)                                                                                                     |
|  463 | CKV_AWS_328     | resource | aws_lb                                                           | Ensure that ALB is configured with defensive or strictest desync mitigation mode                                                                                                                         | Terraform | [ALBDesyncMode.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ALBDesyncMode.py)                                                                                                     |
|  464 | CKV_AWS_329     | resource | aws_efs_access_point                                             | EFS access points should enforce a root directory                                                                                                                                                        | Terraform | [EFSAccessPointRoot.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/EFSAccessPointRoot.py)                                                                                           |
|  465 | CKV_AWS_330     | resource | aws_efs_access_point                                             | EFS access points should enforce a user identity                                                                                                                                                         | Terraform | [EFSAccessUserIdentity.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/EFSAccessUserIdentity.py)                                                                                     |
|  466 | CKV_AWS_331     | resource | aws_ec2_transit_gateway                                          | Ensure Transit Gateways do not automatically accept VPC attachment requests                                                                                                                              | Terraform | [Ec2TransitGatewayAutoAccept.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/Ec2TransitGatewayAutoAccept.py)                                                                         |
|  467 | CKV_AWS_332     | resource | aws_ecs_service                                                  | Ensure ECS Fargate services run on the latest Fargate platform version                                                                                                                                   | Terraform | [ECSServiceFargateLatest.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ECSServiceFargateLatest.py)                                                                                 |
|  468 | CKV_AWS_333     | resource | aws_ecs_service                                                  | Ensure ECS services do not have public IP addresses assigned to them automatically                                                                                                                       | Terraform | [ECSServicePublicIP.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ECSServicePublicIP.py)                                                                                           |
|  469 | CKV_AWS_334     | resource | aws_ecs_task_definition                                          | Ensure ECS containers should run as non-privileged                                                                                                                                                       | Terraform | [ECSContainerPrivilege.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ECSContainerPrivilege.py)                                                                                     |
|  470 | CKV_AWS_335     | resource | aws_ecs_task_definition                                          | Ensure ECS task definitions should not share the host's process namespace                                                                                                                                | Terraform | [ECSContainerHostProcess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ECSContainerHostProcess.py)                                                                                 |
|  471 | CKV_AWS_336     | resource | aws_ecs_task_definition                                          | Ensure ECS containers are limited to read-only access to root filesystems                                                                                                                                | Terraform | [ECSContainerReadOnlyRoot.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ECSContainerReadOnlyRoot.py)                                                                               |
|  472 | CKV_AWS_337     | resource | aws_ssm_parameter                                                | Ensure SSM parameters are using KMS CMK                                                                                                                                                                  | Terraform | [SSMParameterUsesCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SSMParameterUsesCMK.py)                                                                                         |
|  473 | CKV_AWS_338     | resource | aws_cloudwatch_log_group                                         | Ensure CloudWatch log groups retains logs for at least 1 year                                                                                                                                            | Terraform | [CloudWatchLogGroupRetentionYear.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/CloudWatchLogGroupRetentionYear.py)                                                                 |
|  474 | CKV_AWS_339     | resource | aws_eks_cluster                                                  | Ensure EKS clusters run on a supported Kubernetes version                                                                                                                                                | Terraform | [EKSPlatformVersion.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/EKSPlatformVersion.py)                                                                                           |
|  475 | CKV_AWS_340     | resource | aws_elastic_beanstalk_environment                                | Ensure Elastic Beanstalk managed platform updates are enabled                                                                                                                                            | Terraform | [ElasticBeanstalkUseManagedUpdates.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ElasticBeanstalkUseManagedUpdates.py)                                                             |
|  476 | CKV_AWS_341     | resource | aws_launch_configuration                                         | Ensure Launch template should not have a metadata response hop limit greater than 1                                                                                                                      | Terraform | [LaunchTemplateMetadataHop.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/LaunchTemplateMetadataHop.py)                                                                             |
|  477 | CKV_AWS_341     | resource | aws_launch_template                                              | Ensure Launch template should not have a metadata response hop limit greater than 1                                                                                                                      | Terraform | [LaunchTemplateMetadataHop.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/LaunchTemplateMetadataHop.py)                                                                             |
|  478 | CKV_AWS_342     | resource | aws_waf_rule_group                                               | Ensure WAF rule has any actions                                                                                                                                                                          | Terraform | [WAFRuleHasAnyActions.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/WAFRuleHasAnyActions.py)                                                                                       |
|  479 | CKV_AWS_342     | resource | aws_waf_web_acl                                                  | Ensure WAF rule has any actions                                                                                                                                                                          | Terraform | [WAFRuleHasAnyActions.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/WAFRuleHasAnyActions.py)                                                                                       |
|  480 | CKV_AWS_342     | resource | aws_wafregional_rule_group                                       | Ensure WAF rule has any actions                                                                                                                                                                          | Terraform | [WAFRuleHasAnyActions.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/WAFRuleHasAnyActions.py)                                                                                       |
|  481 | CKV_AWS_342     | resource | aws_wafregional_web_acl                                          | Ensure WAF rule has any actions                                                                                                                                                                          | Terraform | [WAFRuleHasAnyActions.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/WAFRuleHasAnyActions.py)                                                                                       |
|  482 | CKV_AWS_342     | resource | aws_wafv2_rule_group                                             | Ensure WAF rule has any actions                                                                                                                                                                          | Terraform | [WAFRuleHasAnyActions.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/WAFRuleHasAnyActions.py)                                                                                       |
|  483 | CKV_AWS_342     | resource | aws_wafv2_web_acl                                                | Ensure WAF rule has any actions                                                                                                                                                                          | Terraform | [WAFRuleHasAnyActions.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/WAFRuleHasAnyActions.py)                                                                                       |
|  484 | CKV_AWS_343     | resource | aws_redshift_cluster                                             | Ensure Amazon Redshift clusters should have automatic snapshots enabled                                                                                                                                  | Terraform | [RedshiftClusterAutoSnap.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RedshiftClusterAutoSnap.py)                                                                                 |
|  485 | CKV_AWS_344     | resource | aws_networkfirewall_firewall                                     | Ensure that Network firewalls have deletion protection enabled                                                                                                                                           | Terraform | [NetworkFirewallDeletionProtection.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/NetworkFirewallDeletionProtection.py)                                                             |
|  486 | CKV_AWS_345     | resource | aws_networkfirewall_firewall                                     | Ensure that Network firewall encryption is via a CMK                                                                                                                                                     | Terraform | [NetworkFirewallUsesCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/NetworkFirewallUsesCMK.py)                                                                                   |
|  487 | CKV_AWS_345     | resource | aws_networkfirewall_rule_group                                   | Ensure that Network firewall encryption is via a CMK                                                                                                                                                     | Terraform | [NetworkFirewallUsesCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/NetworkFirewallUsesCMK.py)                                                                                   |
|  488 | CKV_AWS_346     | resource | aws_networkfirewall_firewall_policy                              | Ensure Network Firewall Policy defines an encryption configuration that uses a customer managed Key (CMK)                                                                                                | Terraform | [NetworkFirewallPolicyDefinesCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/NetworkFirewallPolicyDefinesCMK.py)                                                                 |
|  489 | CKV_AWS_347     | resource | aws_neptune_cluster                                              | Ensure Neptune is encrypted by KMS using a customer managed Key (CMK)                                                                                                                                    | Terraform | [NeptuneClusterEncryptedWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/NeptuneClusterEncryptedWithCMK.py)                                                                   |
|  490 | CKV_AWS_348     | resource | aws_iam_access_key                                               | Ensure IAM root user does not have Access keys                                                                                                                                                           | Terraform | [IAMUserRootAccessKeys.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMUserRootAccessKeys.py)                                                                                     |
|  491 | CKV_AWS_349     | resource | aws_emr_security_configuration                                   | Ensure EMR Cluster security configuration encrypts local disks                                                                                                                                           | Terraform | [EMRClusterConfEncryptsLocalDisk.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/EMRClusterConfEncryptsLocalDisk.py)                                                                 |
|  492 | CKV_AWS_350     | resource | aws_emr_security_configuration                                   | Ensure EMR Cluster security configuration encrypts EBS disks                                                                                                                                             | Terraform | [EMRClusterConfEncryptsEBS.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/EMRClusterConfEncryptsEBS.py)                                                                             |
|  493 | CKV_AWS_351     | resource | aws_emr_security_configuration                                   | Ensure EMR Cluster security configuration encrypts InTransit                                                                                                                                             | Terraform | [EMRClusterConfEncryptsInTransit.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/EMRClusterConfEncryptsInTransit.py)                                                                 |
|  494 | CKV_AWS_352     | resource | aws_network_acl_rule                                             | Ensure NACL ingress does not allow all Ports                                                                                                                                                             | Terraform | [NetworkACLUnrestricted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/NetworkACLUnrestricted.py)                                                                                   |
|  495 | CKV_AWS_353     | resource | aws_db_instance                                                  | Ensure that RDS instances have performance insights enabled                                                                                                                                              | Terraform | [RDSInstancePerformanceInsights.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RDSInstancePerformanceInsights.py)                                                                   |
|  496 | CKV_AWS_353     | resource | aws_rds_cluster_instance                                         | Ensure that RDS instances have performance insights enabled                                                                                                                                              | Terraform | [RDSInstancePerformanceInsights.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RDSInstancePerformanceInsights.py)                                                                   |
|  497 | CKV_AWS_354     | resource | aws_db_instance                                                  | Ensure RDS Performance Insights are encrypted using KMS CMKs                                                                                                                                             | Terraform | [RDSInstancePerfInsightsEncryptionWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RDSInstancePerfInsightsEncryptionWithCMK.py)                                               |
|  498 | CKV_AWS_354     | resource | aws_rds_cluster_instance                                         | Ensure RDS Performance Insights are encrypted using KMS CMKs                                                                                                                                             | Terraform | [RDSInstancePerfInsightsEncryptionWithCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RDSInstancePerfInsightsEncryptionWithCMK.py)                                               |
|  499 | CKV_AWS_355     | resource | aws_iam_group_policy                                             | Ensure no IAM policies documents allow "*" as a statement's resource for restrictable actions                                                                                                            | Terraform | [IAMStarResourcePolicyDocument.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMStarResourcePolicyDocument.py)                                                                     |
|  500 | CKV_AWS_355     | resource | aws_iam_policy                                                   | Ensure no IAM policies documents allow "*" as a statement's resource for restrictable actions                                                                                                            | Terraform | [IAMStarResourcePolicyDocument.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMStarResourcePolicyDocument.py)                                                                     |
|  501 | CKV_AWS_355     | resource | aws_iam_role_policy                                              | Ensure no IAM policies documents allow "*" as a statement's resource for restrictable actions                                                                                                            | Terraform | [IAMStarResourcePolicyDocument.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMStarResourcePolicyDocument.py)                                                                     |
|  502 | CKV_AWS_355     | resource | aws_iam_user_policy                                              | Ensure no IAM policies documents allow "*" as a statement's resource for restrictable actions                                                                                                            | Terraform | [IAMStarResourcePolicyDocument.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMStarResourcePolicyDocument.py)                                                                     |
|  503 | CKV_AWS_355     | resource | aws_ssoadmin_permission_set_inline_policy                        | Ensure no IAM policies documents allow "*" as a statement's resource for restrictable actions                                                                                                            | Terraform | [IAMStarResourcePolicyDocument.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/IAMStarResourcePolicyDocument.py)                                                                     |
|  504 | CKV_AWS_356     | data     | aws_iam_policy_document                                          | Ensure no IAM policies documents allow "*" as a statement's resource for restrictable actions                                                                                                            | Terraform | [ResourcePolicyDocument.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/data/aws/ResourcePolicyDocument.py)                                                                                       |
|  505 | CKV_AWS_357     | resource | aws_transfer_server                                              | Ensure Transfer Server allows only secure protocols                                                                                                                                                      | Terraform | [TransferServerAllowsOnlySecureProtocols.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/TransferServerAllowsOnlySecureProtocols.py)                                                 |
|  506 | CKV_AWS_358     | data     | aws_iam_policy_document                                          | Ensure AWS GitHub Actions OIDC authorization policies only allow safe claims and claim order                                                                                                             | Terraform | [GithubActionsOIDCTrustPolicy.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/data/aws/GithubActionsOIDCTrustPolicy.py)                                                                           |
|  507 | CKV_AWS_359     | resource | aws_neptune_cluster                                              | Neptune DB clusters should have IAM database authentication enabled                                                                                                                                      | Terraform | [NeptuneDBClustersIAMDatabaseAuthenticationEnabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/NeptuneDBClustersIAMDatabaseAuthenticationEnabled.py)                             |
|  508 | CKV_AWS_360     | resource | aws_docdb_cluster                                                | Ensure DocumentDB has an adequate backup retention period                                                                                                                                                | Terraform | [DocDBBackupRetention.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/DocDBBackupRetention.py)                                                                                       |
|  509 | CKV_AWS_361     | resource | aws_neptune_cluster                                              | Ensure that Neptune DB cluster has automated backups enabled with adequate retention                                                                                                                     | Terraform | [NeptuneClusterBackupRetention.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/NeptuneClusterBackupRetention.py)                                                                     |
|  510 | CKV_AWS_362     | resource | aws_neptune_cluster                                              | Neptune DB clusters should be configured to copy tags to snapshots                                                                                                                                       | Terraform | [NeptuneDBClustersCopyTagsToSnapshots.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/NeptuneDBClustersCopyTagsToSnapshots.py)                                                       |
|  511 | CKV_AWS_363     | resource | aws_lambda_function                                              | Ensure Lambda Runtime is not deprecated                                                                                                                                                                  | Terraform | [DeprecatedLambdaRuntime.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/DeprecatedLambdaRuntime.py)                                                                                 |
|  512 | CKV_AWS_364     | resource | aws_lambda_permission                                            | Ensure that AWS Lambda function permissions delegated to AWS services are limited by SourceArn or SourceAccount                                                                                          | Terraform | [LambdaServicePermission.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/LambdaServicePermission.py)                                                                                 |
|  513 | CKV_AWS_365     | resource | aws_ses_configuration_set                                        | Ensure SES Configuration Set enforces TLS usage                                                                                                                                                          | Terraform | [SesConfigurationSetDefinesTLS.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SesConfigurationSetDefinesTLS.py)                                                                     |
|  514 | CKV_AWS_366     | resource | aws_cognito_identity_pool                                        | Ensure AWS Cognito identity pool does not allow unauthenticated guest access                                                                                                                             | Terraform | [CognitoUnauthenticatedIdentities.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/CognitoUnauthenticatedIdentities.py)                                                               |
|  515 | CKV_AWS_367     | resource | aws_sagemaker_data_quality_job_definition                        | Ensure Amazon Sagemaker Data Quality Job uses KMS to encrypt model artifacts                                                                                                                             | Terraform | [SagemakerDataQualityJobDefinitionEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SagemakerDataQualityJobDefinitionEncryption.py)                                         |
|  516 | CKV_AWS_368     | resource | aws_sagemaker_data_quality_job_definition                        | Ensure Amazon Sagemaker Data Quality Job uses KMS to encrypt data on attached storage volume                                                                                                             | Terraform | [SagemakerDataQualityJobDefinitionVolumeEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SagemakerDataQualityJobDefinitionVolumeEncryption.py)                             |
|  517 | CKV_AWS_369     | resource | aws_sagemaker_data_quality_job_definition                        | Ensure Amazon Sagemaker Data Quality Job encrypts all communications between instances used for monitoring jobs                                                                                          | Terraform | [SagemakerDataQualityJobDefinitionTrafficEncryption.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SagemakerDataQualityJobDefinitionTrafficEncryption.py)                           |
|  518 | CKV_AWS_370     | resource | aws_sagemaker_model                                              | Ensure Amazon SageMaker model uses network isolation                                                                                                                                                     | Terraform | [SagemakerModelWithNetworkIsolation.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SagemakerModelWithNetworkIsolation.py)                                                           |
|  519 | CKV_AWS_371     | resource | aws_sagemaker_notebook_instance                                  | Ensure Amazon SageMaker Notebook Instance only allows for IMDSv2                                                                                                                                         | Terraform | [SagemakerNotebookInstanceAllowsIMDSv2.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SagemakerNotebookInstanceAllowsIMDSv2.py)                                                     |
|  520 | CKV_AWS_372     | resource | aws_sagemaker_flow_definition                                    | Ensure Amazon SageMaker Flow Definition uses KMS for output configurations                                                                                                                               | Terraform | [SagemakerFlowDefinitionUsesKMS.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SagemakerFlowDefinitionUsesKMS.py)                                                                   |
|  521 | CKV_AWS_373     | resource | aws_bedrockagent_agent                                           | Ensure Bedrock Agent is encrypted with a CMK                                                                                                                                                             | Terraform | [BedrockAgentEncrypted.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/BedrockAgentEncrypted.py)                                                                                     |
|  522 | CKV_AWS_374     | resource | aws_cloudfront_distribution                                      | Ensure AWS CloudFront web distribution has geo restriction enabled                                                                                                                                       | Terraform | [CloudFrontGeoRestrictionDisabled.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/CloudFrontGeoRestrictionDisabled.py)                                                               |
|  523 | CKV_AWS_375     | resource | aws_s3_bucket_acl                                                | Ensure AWS S3 bucket does not have global view ACL permissions enabled                                                                                                                                   | Terraform | [S3GlobalViewACL.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/S3GlobalViewACL.py)                                                                                                 |
|  524 | CKV_AWS_376     | resource | aws_elb                                                          | Ensure AWS Elastic Load Balancer listener uses TLS/SSL                                                                                                                                                   | Terraform | [ELBwListenerNotTLSSSL.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/ELBwListenerNotTLSSSL.py)                                                                                     |
|  525 | CKV_AWS_377     | resource | aws_route53domains_registered_domain                             | Ensure Route 53 domains have transfer lock protection                                                                                                                                                    | Terraform | [Route53TransferLock.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/Route53TransferLock.py)                                                                                         |
|  526 | CKV_AWS_378     | resource | aws_alb_listener                                                 | Ensure AWS Load Balancer doesn't use HTTP protocol                                                                                                                                                       | Terraform | [LBTargetGroup.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/LBTargetGroup.yaml)                                                                                             |
|  527 | CKV_AWS_378     | resource | aws_alb_target_group                                             | Ensure AWS Load Balancer doesn't use HTTP protocol                                                                                                                                                       | Terraform | [LBTargetGroup.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/LBTargetGroup.yaml)                                                                                             |
|  528 | CKV_AWS_378     | resource | aws_lb_listener                                                  | Ensure AWS Load Balancer doesn't use HTTP protocol                                                                                                                                                       | Terraform | [LBTargetGroup.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/LBTargetGroup.yaml)                                                                                             |
|  529 | CKV_AWS_378     | resource | aws_lb_target_group                                              | Ensure AWS Load Balancer doesn't use HTTP protocol                                                                                                                                                       | Terraform | [LBTargetGroup.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/LBTargetGroup.yaml)                                                                                             |
|  530 | CKV_AWS_379     | resource | aws_s3_bucket_acl                                                | Ensure AWS S3 bucket is configured with secure data transport policy                                                                                                                                     | Terraform | [S3SecureDataTransport.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/S3SecureDataTransport.py)                                                                                     |
|  531 | CKV_AWS_380     | resource | aws_transfer_server                                              | Ensure AWS Transfer Server uses latest Security Policy                                                                                                                                                   | Terraform | [TransferServerLatestPolicy.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/TransferServerLatestPolicy.py)                                                                           |
|  532 | CKV_AWS_381     | resource | aws_codegurureviewer_repository_association                      | Make sure that aws_codegurureviewer_repository_association has a CMK                                                                                                                                     | Terraform | [AWSCodeGuruHasCMK.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/AWSCodeGuruHasCMK.py)                                                                                             |
|  533 | CKV_AWS_382     | resource | aws_security_group                                               | Ensure no security groups allow egress from 0.0.0.0:0 to port -1                                                                                                                                         | Terraform | [SecurityGroupUnrestrictedEgressAny.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SecurityGroupUnrestrictedEgressAny.py)                                                           |
|  534 | CKV_AWS_382     | resource | aws_security_group_rule                                          | Ensure no security groups allow egress from 0.0.0.0:0 to port -1                                                                                                                                         | Terraform | [SecurityGroupUnrestrictedEgressAny.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SecurityGroupUnrestrictedEgressAny.py)                                                           |
|  535 | CKV_AWS_382     | resource | aws_vpc_security_group_egress_rule                               | Ensure no security groups allow egress from 0.0.0.0:0 to port -1                                                                                                                                         | Terraform | [SecurityGroupUnrestrictedEgressAny.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SecurityGroupUnrestrictedEgressAny.py)                                                           |
|  536 | CKV_AWS_383     | resource | aws_bedrockagent_agent                                           | Ensure AWS Bedrock agent is associated with Bedrock guardrails                                                                                                                                           | Terraform | [BedrockGuardrails.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/BedrockGuardrails.py)                                                                                             |
|  537 | CKV_AWS_385     | resource | aws_sns_topic_policy                                             | Ensure AWS SNS topic policies do not allow cross-account access                                                                                                                                          | Terraform | [SNSCrossAccountAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SNSCrossAccountAccess.py)                                                                                     |
|  538 | CKV_AWS_386     | data     | aws_ami                                                          | Reduce potential for WhoAMI cloud image name confusion attack                                                                                                                                            | Terraform | [WhoAMI.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/data/aws/WhoAMI.py)                                                                                                                       |
|  539 | CKV_AWS_387     | resource | aws_sqs_queue_policy                                             | Ensure SQS policy does not allow public access through wildcards                                                                                                                                         | Terraform | [SQSOverlyPermissive.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/SQSOverlyPermissive.py)                                                                                         |
|  540 | CKV_AWS_388     | resource | aws_db_instance                                                  | Ensure AWS Aurora PostgreSQL is not exposed to local file read vulnerability                                                                                                                             | Terraform | [UnpatchedAuroraPostgresDB.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/UnpatchedAuroraPostgresDB.py)                                                                             |
|  541 | CKV_AWS_389     | resource | aws_launch_configuration                                         | Ensure AWS Auto Scaling group launch configuration doesn't have public IP address assignment enabled                                                                                                     | Terraform | [AutoScalingGroupWithPublicAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/AutoScalingGroupWithPublicAccess.py)                                                               |
|  542 | CKV_AWS_390     | resource | aws_emr_block_public_access_configuration                        | Ensure AWS EMR block public access setting is enabled                                                                                                                                                    | Terraform | [EMRPubliclyAccessible.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/EMRPubliclyAccessible.py)                                                                                     |
|  543 | CKV_AWS_391     | resource | aws_redshift_cluster                                             | Avoid AWS Redshift cluster with commonly used master username and public access setting enabled                                                                                                          | Terraform | [RedshiftClusterWithCommonUsernameAndPublicAccess.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/RedshiftClusterWithCommonUsernameAndPublicAccess.py)                               |
|  544 | CKV_AWS_392     | resource | aws_s3_access_point                                              | Ensure AWS S3 access point block public access setting is enabled                                                                                                                                        | Terraform | [S3AccessPointPubliclyAccessible.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/resource/aws/S3AccessPointPubliclyAccessible.py)                                                                 |
|  545 | CKV2_AWS_1      | resource | aws_network_acl                                                  | Ensure that all NACL are attached to subnets                                                                                                                                                             | Terraform | [SubnetHasACL.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/SubnetHasACL.yaml)                                                                                               |
|  546 | CKV2_AWS_1      | resource | aws_subnet                                                       | Ensure that all NACL are attached to subnets                                                                                                                                                             | Terraform | [SubnetHasACL.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/SubnetHasACL.yaml)                                                                                               |
|  547 | CKV2_AWS_2      | resource | aws_ebs_volume                                                   | Ensure that only encrypted EBS volumes are attached to EC2 instances                                                                                                                                     | Terraform | [EncryptedEBSVolumeOnlyConnectedToEC2s.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/EncryptedEBSVolumeOnlyConnectedToEC2s.yaml)                                             |
|  548 | CKV2_AWS_2      | resource | aws_volume_attachment                                            | Ensure that only encrypted EBS volumes are attached to EC2 instances                                                                                                                                     | Terraform | [EncryptedEBSVolumeOnlyConnectedToEC2s.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/EncryptedEBSVolumeOnlyConnectedToEC2s.yaml)                                             |
|  549 | CKV2_AWS_3      | resource | aws_guardduty_detector                                           | Ensure GuardDuty is enabled to specific org/region                                                                                                                                                       | Terraform | [GuardDutyIsEnabled.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/GuardDutyIsEnabled.yaml)                                                                                   |
|  550 | CKV2_AWS_3      | resource | aws_guardduty_organization_configuration                         | Ensure GuardDuty is enabled to specific org/region                                                                                                                                                       | Terraform | [GuardDutyIsEnabled.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/GuardDutyIsEnabled.yaml)                                                                                   |
|  551 | CKV2_AWS_4      | resource | aws_api_gateway_method_settings                                  | Ensure API Gateway stage have logging level defined as appropriate                                                                                                                                       | Terraform | [APIGWLoggingLevelsDefinedProperly.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/APIGWLoggingLevelsDefinedProperly.yaml)                                                     |
|  552 | CKV2_AWS_4      | resource | aws_api_gateway_stage                                            | Ensure API Gateway stage have logging level defined as appropriate                                                                                                                                       | Terraform | [APIGWLoggingLevelsDefinedProperly.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/APIGWLoggingLevelsDefinedProperly.yaml)                                                     |
|  553 | CKV2_AWS_5      | resource | aws_security_group                                               | Ensure that Security Groups are attached to another resource                                                                                                                                             | Terraform | [SGAttachedToResource.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/SGAttachedToResource.yaml)                                                                               |
|  554 | CKV2_AWS_6      | resource | aws_s3_bucket                                                    | Ensure that S3 bucket has a Public Access block                                                                                                                                                          | Terraform | [S3BucketHasPublicAccessBlock.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/S3BucketHasPublicAccessBlock.yaml)                                                               |
|  555 | CKV2_AWS_6      | resource | aws_s3_bucket_public_access_block                                | Ensure that S3 bucket has a Public Access block                                                                                                                                                          | Terraform | [S3BucketHasPublicAccessBlock.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/S3BucketHasPublicAccessBlock.yaml)                                                               |
|  556 | CKV2_AWS_7      | resource | aws_emr_cluster                                                  | Ensure that Amazon EMR clusters' security groups are not open to the world                                                                                                                               | Terraform | [AMRClustersNotOpenToInternet.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/AMRClustersNotOpenToInternet.yaml)                                                               |
|  557 | CKV2_AWS_7      | resource | aws_security_group                                               | Ensure that Amazon EMR clusters' security groups are not open to the world                                                                                                                               | Terraform | [AMRClustersNotOpenToInternet.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/AMRClustersNotOpenToInternet.yaml)                                                               |
|  558 | CKV2_AWS_8      | resource | aws_rds_cluster                                                  | Ensure that RDS clusters has backup plan of AWS Backup                                                                                                                                                   | Terraform | [RDSClusterHasBackupPlan.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/RDSClusterHasBackupPlan.yaml)                                                                         |
|  559 | CKV2_AWS_9      | resource | aws_backup_selection                                             | Ensure that EBS are added in the backup plans of AWS Backup                                                                                                                                              | Terraform | [EBSAddedBackup.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/EBSAddedBackup.yaml)                                                                                           |
|  560 | CKV2_AWS_10     | resource | aws_cloudtrail                                                   | Ensure CloudTrail trails are integrated with CloudWatch Logs                                                                                                                                             | Terraform | [CloudtrailHasCloudwatch.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CloudtrailHasCloudwatch.yaml)                                                                         |
|  561 | CKV2_AWS_11     | resource | aws_vpc                                                          | Ensure VPC flow logging is enabled in all VPCs                                                                                                                                                           | Terraform | [VPCHasFlowLog.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/VPCHasFlowLog.yaml)                                                                                             |
|  562 | CKV2_AWS_12     | resource | aws_default_security_group                                       | Ensure the default security group of every VPC restricts all traffic                                                                                                                                     | Terraform | [VPCHasRestrictedSG.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/VPCHasRestrictedSG.yaml)                                                                                   |
|  563 | CKV2_AWS_12     | resource | aws_vpc                                                          | Ensure the default security group of every VPC restricts all traffic                                                                                                                                     | Terraform | [VPCHasRestrictedSG.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/VPCHasRestrictedSG.yaml)                                                                                   |
|  564 | CKV2_AWS_14     | resource | aws_iam_group                                                    | Ensure that IAM groups includes at least one IAM user                                                                                                                                                    | Terraform | [IAMGroupHasAtLeastOneUser.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/IAMGroupHasAtLeastOneUser.yaml)                                                                     |
|  565 | CKV2_AWS_14     | resource | aws_iam_group_membership                                         | Ensure that IAM groups includes at least one IAM user                                                                                                                                                    | Terraform | [IAMGroupHasAtLeastOneUser.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/IAMGroupHasAtLeastOneUser.yaml)                                                                     |
|  566 | CKV2_AWS_15     | resource | aws_autoscaling_group                                            | Ensure that auto Scaling groups that are associated with a load balancer are using Elastic Load Balancing health checks.                                                                                 | Terraform | [AutoScallingEnabledELB.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/AutoScallingEnabledELB.yaml)                                                                           |
|  567 | CKV2_AWS_15     | resource | aws_elb                                                          | Ensure that auto Scaling groups that are associated with a load balancer are using Elastic Load Balancing health checks.                                                                                 | Terraform | [AutoScallingEnabledELB.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/AutoScallingEnabledELB.yaml)                                                                           |
|  568 | CKV2_AWS_15     | resource | aws_lb_target_group                                              | Ensure that auto Scaling groups that are associated with a load balancer are using Elastic Load Balancing health checks.                                                                                 | Terraform | [AutoScallingEnabledELB.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/AutoScallingEnabledELB.yaml)                                                                           |
|  569 | CKV2_AWS_16     | resource | aws_appautoscaling_target                                        | Ensure that Auto Scaling is enabled on your DynamoDB tables                                                                                                                                              | Terraform | [AutoScalingEnableOnDynamoDBTables.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/AutoScalingEnableOnDynamoDBTables.yaml)                                                     |
|  570 | CKV2_AWS_16     | resource | aws_dynamodb_table                                               | Ensure that Auto Scaling is enabled on your DynamoDB tables                                                                                                                                              | Terraform | [AutoScalingEnableOnDynamoDBTables.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/AutoScalingEnableOnDynamoDBTables.yaml)                                                     |
|  571 | CKV2_AWS_18     | resource | aws_backup_selection                                             | Ensure that Elastic File System (Amazon EFS) file systems are added in the backup plans of AWS Backup                                                                                                    | Terraform | [EFSAddedBackup.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/EFSAddedBackup.yaml)                                                                                           |
|  572 | CKV2_AWS_19     | resource | aws_eip                                                          | Ensure that all EIP addresses allocated to a VPC are attached to EC2 instances                                                                                                                           | Terraform | [EIPAllocatedToVPCAttachedEC2.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/EIPAllocatedToVPCAttachedEC2.yaml)                                                               |
|  573 | CKV2_AWS_19     | resource | aws_eip_association                                              | Ensure that all EIP addresses allocated to a VPC are attached to EC2 instances                                                                                                                           | Terraform | [EIPAllocatedToVPCAttachedEC2.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/EIPAllocatedToVPCAttachedEC2.yaml)                                                               |
|  574 | CKV2_AWS_20     | resource | aws_alb                                                          | Ensure that ALB redirects HTTP requests into HTTPS ones                                                                                                                                                  | Terraform | [ALBRedirectsHTTPToHTTPS.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/ALBRedirectsHTTPToHTTPS.yaml)                                                                         |
|  575 | CKV2_AWS_20     | resource | aws_alb_listener                                                 | Ensure that ALB redirects HTTP requests into HTTPS ones                                                                                                                                                  | Terraform | [ALBRedirectsHTTPToHTTPS.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/ALBRedirectsHTTPToHTTPS.yaml)                                                                         |
|  576 | CKV2_AWS_20     | resource | aws_lb                                                           | Ensure that ALB redirects HTTP requests into HTTPS ones                                                                                                                                                  | Terraform | [ALBRedirectsHTTPToHTTPS.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/ALBRedirectsHTTPToHTTPS.yaml)                                                                         |
|  577 | CKV2_AWS_20     | resource | aws_lb_listener                                                  | Ensure that ALB redirects HTTP requests into HTTPS ones                                                                                                                                                  | Terraform | [ALBRedirectsHTTPToHTTPS.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/ALBRedirectsHTTPToHTTPS.yaml)                                                                         |
|  578 | CKV2_AWS_21     | resource | aws_iam_group_membership                                         | Ensure that all IAM users are members of at least one IAM group.                                                                                                                                         | Terraform | [IAMUsersAreMembersAtLeastOneGroup.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/IAMUsersAreMembersAtLeastOneGroup.yaml)                                                     |
|  579 | CKV2_AWS_22     | resource | aws_iam_user                                                     | Ensure an IAM User does not have access to the console                                                                                                                                                   | Terraform | [IAMUserHasNoConsoleAccess.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/IAMUserHasNoConsoleAccess.yaml)                                                                     |
|  580 | CKV2_AWS_23     | resource | aws_route53_record                                               | Route53 A Record has Attached Resource                                                                                                                                                                   | Terraform | [Route53ARecordAttachedResource.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/Route53ARecordAttachedResource.yaml)                                                           |
|  581 | CKV2_AWS_27     | resource | aws_rds_cluster                                                  | Ensure Postgres RDS as aws_rds_cluster has Query Logging enabled                                                                                                                                         | Terraform | [PostgresRDSHasQueryLoggingEnabled.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/PostgresRDSHasQueryLoggingEnabled.yaml)                                                     |
|  582 | CKV2_AWS_27     | resource | aws_rds_cluster_parameter_group                                  | Ensure Postgres RDS as aws_rds_cluster has Query Logging enabled                                                                                                                                         | Terraform | [PostgresRDSHasQueryLoggingEnabled.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/PostgresRDSHasQueryLoggingEnabled.yaml)                                                     |
|  583 | CKV2_AWS_28     | resource | aws_alb                                                          | Ensure public facing ALB are protected by WAF                                                                                                                                                            | Terraform | [ALBProtectedByWAF.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/ALBProtectedByWAF.yaml)                                                                                     |
|  584 | CKV2_AWS_28     | resource | aws_lb                                                           | Ensure public facing ALB are protected by WAF                                                                                                                                                            | Terraform | [ALBProtectedByWAF.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/ALBProtectedByWAF.yaml)                                                                                     |
|  585 | CKV2_AWS_29     | resource | aws_api_gateway_rest_api                                         | Ensure public API gateway are protected by WAF                                                                                                                                                           | Terraform | [APIProtectedByWAF.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/APIProtectedByWAF.yaml)                                                                                     |
|  586 | CKV2_AWS_29     | resource | aws_api_gateway_stage                                            | Ensure public API gateway are protected by WAF                                                                                                                                                           | Terraform | [APIProtectedByWAF.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/APIProtectedByWAF.yaml)                                                                                     |
|  587 | CKV2_AWS_30     | resource | aws_db_instance                                                  | Ensure Postgres RDS as aws_db_instance has Query Logging enabled                                                                                                                                         | Terraform | [PostgresDBHasQueryLoggingEnabled.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/PostgresDBHasQueryLoggingEnabled.yaml)                                                       |
|  588 | CKV2_AWS_30     | resource | aws_db_parameter_group                                           | Ensure Postgres RDS as aws_db_instance has Query Logging enabled                                                                                                                                         | Terraform | [PostgresDBHasQueryLoggingEnabled.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/PostgresDBHasQueryLoggingEnabled.yaml)                                                       |
|  589 | CKV2_AWS_31     | resource | aws_wafv2_web_acl                                                | Ensure WAF2 has a Logging Configuration                                                                                                                                                                  | Terraform | [WAF2HasLogs.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/WAF2HasLogs.yaml)                                                                                                 |
|  590 | CKV2_AWS_32     | resource | aws_cloudfront_distribution                                      | Ensure CloudFront distribution has a response headers policy attached                                                                                                                                    | Terraform | [CloudFrontHasResponseHeadersPolicy.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CloudFrontHasResponseHeadersPolicy.yaml)                                                   |
|  591 | CKV2_AWS_33     | resource | aws_appsync_graphql_api                                          | Ensure AppSync is protected by WAF                                                                                                                                                                       | Terraform | [AppSyncProtectedByWAF.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/AppSyncProtectedByWAF.yaml)                                                                             |
|  592 | CKV2_AWS_34     | resource | aws_ssm_parameter                                                | AWS SSM Parameter should be Encrypted                                                                                                                                                                    | Terraform | [AWSSSMParameterShouldBeEncrypted.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/AWSSSMParameterShouldBeEncrypted.yaml)                                                       |
|  593 | CKV2_AWS_35     | resource | aws_route                                                        | AWS NAT Gateways should be utilized for the default route                                                                                                                                                | Terraform | [AWSNATGatewaysshouldbeutilized.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/AWSNATGatewaysshouldbeutilized.yaml)                                                           |
|  594 | CKV2_AWS_35     | resource | aws_route_table                                                  | AWS NAT Gateways should be utilized for the default route                                                                                                                                                | Terraform | [AWSNATGatewaysshouldbeutilized.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/AWSNATGatewaysshouldbeutilized.yaml)                                                           |
|  595 | CKV2_AWS_36     | resource | aws_ssm_parameter                                                | Ensure terraform is not sending SSM secrets to untrusted domains over HTTP                                                                                                                               | Terraform | [HTTPNotSendingPasswords.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/HTTPNotSendingPasswords.yaml)                                                                         |
|  596 | CKV2_AWS_36     | resource | data.http                                                        | Ensure terraform is not sending SSM secrets to untrusted domains over HTTP                                                                                                                               | Terraform | [HTTPNotSendingPasswords.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/HTTPNotSendingPasswords.yaml)                                                                         |
|  597 | CKV2_AWS_37     | resource | aws                                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  598 | CKV2_AWS_37     | resource | aws_accessanalyzer_analyzer                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  599 | CKV2_AWS_37     | resource | aws_accessanalyzer_archive_rule                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  600 | CKV2_AWS_37     | resource | aws_account_alternate_contact                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  601 | CKV2_AWS_37     | resource | aws_account_primary_contact                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  602 | CKV2_AWS_37     | resource | aws_account_region                                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  603 | CKV2_AWS_37     | resource | aws_acm_certificate                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  604 | CKV2_AWS_37     | resource | aws_acm_certificate_validation                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  605 | CKV2_AWS_37     | resource | aws_acmpca_certificate                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  606 | CKV2_AWS_37     | resource | aws_acmpca_certificate_authority                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  607 | CKV2_AWS_37     | resource | aws_acmpca_certificate_authority_certificate                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  608 | CKV2_AWS_37     | resource | aws_acmpca_permission                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  609 | CKV2_AWS_37     | resource | aws_acmpca_policy                                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  610 | CKV2_AWS_37     | resource | aws_alb                                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  611 | CKV2_AWS_37     | resource | aws_alb_listener                                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  612 | CKV2_AWS_37     | resource | aws_alb_listener_certificate                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  613 | CKV2_AWS_37     | resource | aws_alb_listener_rule                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  614 | CKV2_AWS_37     | resource | aws_alb_target_group                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  615 | CKV2_AWS_37     | resource | aws_alb_target_group_attachment                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  616 | CKV2_AWS_37     | resource | aws_ami                                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  617 | CKV2_AWS_37     | resource | aws_ami_copy                                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  618 | CKV2_AWS_37     | resource | aws_ami_from_instance                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  619 | CKV2_AWS_37     | resource | aws_ami_launch_permission                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  620 | CKV2_AWS_37     | resource | aws_amplify_app                                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  621 | CKV2_AWS_37     | resource | aws_amplify_backend_environment                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  622 | CKV2_AWS_37     | resource | aws_amplify_branch                                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  623 | CKV2_AWS_37     | resource | aws_amplify_domain_association                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  624 | CKV2_AWS_37     | resource | aws_amplify_webhook                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  625 | CKV2_AWS_37     | resource | aws_api_gateway_account                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  626 | CKV2_AWS_37     | resource | aws_api_gateway_api_key                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  627 | CKV2_AWS_37     | resource | aws_api_gateway_authorizer                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  628 | CKV2_AWS_37     | resource | aws_api_gateway_base_path_mapping                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  629 | CKV2_AWS_37     | resource | aws_api_gateway_client_certificate                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  630 | CKV2_AWS_37     | resource | aws_api_gateway_deployment                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  631 | CKV2_AWS_37     | resource | aws_api_gateway_documentation_part                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  632 | CKV2_AWS_37     | resource | aws_api_gateway_documentation_version                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  633 | CKV2_AWS_37     | resource | aws_api_gateway_domain_name                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  634 | CKV2_AWS_37     | resource | aws_api_gateway_domain_name_access_association                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  635 | CKV2_AWS_37     | resource | aws_api_gateway_gateway_response                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  636 | CKV2_AWS_37     | resource | aws_api_gateway_integration                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  637 | CKV2_AWS_37     | resource | aws_api_gateway_integration_response                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  638 | CKV2_AWS_37     | resource | aws_api_gateway_method                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  639 | CKV2_AWS_37     | resource | aws_api_gateway_method_response                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  640 | CKV2_AWS_37     | resource | aws_api_gateway_method_settings                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  641 | CKV2_AWS_37     | resource | aws_api_gateway_model                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  642 | CKV2_AWS_37     | resource | aws_api_gateway_request_validator                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  643 | CKV2_AWS_37     | resource | aws_api_gateway_resource                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  644 | CKV2_AWS_37     | resource | aws_api_gateway_rest_api                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  645 | CKV2_AWS_37     | resource | aws_api_gateway_rest_api_policy                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  646 | CKV2_AWS_37     | resource | aws_api_gateway_stage                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  647 | CKV2_AWS_37     | resource | aws_api_gateway_usage_plan                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  648 | CKV2_AWS_37     | resource | aws_api_gateway_usage_plan_key                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  649 | CKV2_AWS_37     | resource | aws_api_gateway_vpc_link                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  650 | CKV2_AWS_37     | resource | aws_apigatewayv2_api                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  651 | CKV2_AWS_37     | resource | aws_apigatewayv2_api_mapping                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  652 | CKV2_AWS_37     | resource | aws_apigatewayv2_authorizer                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  653 | CKV2_AWS_37     | resource | aws_apigatewayv2_deployment                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  654 | CKV2_AWS_37     | resource | aws_apigatewayv2_domain_name                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  655 | CKV2_AWS_37     | resource | aws_apigatewayv2_integration                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  656 | CKV2_AWS_37     | resource | aws_apigatewayv2_integration_response                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  657 | CKV2_AWS_37     | resource | aws_apigatewayv2_model                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  658 | CKV2_AWS_37     | resource | aws_apigatewayv2_route                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  659 | CKV2_AWS_37     | resource | aws_apigatewayv2_route_response                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  660 | CKV2_AWS_37     | resource | aws_apigatewayv2_stage                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  661 | CKV2_AWS_37     | resource | aws_apigatewayv2_vpc_link                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  662 | CKV2_AWS_37     | resource | aws_app_cookie_stickiness_policy                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  663 | CKV2_AWS_37     | resource | aws_appautoscaling_policy                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  664 | CKV2_AWS_37     | resource | aws_appautoscaling_scheduled_action                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  665 | CKV2_AWS_37     | resource | aws_appautoscaling_target                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  666 | CKV2_AWS_37     | resource | aws_appconfig_application                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  667 | CKV2_AWS_37     | resource | aws_appconfig_configuration_profile                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  668 | CKV2_AWS_37     | resource | aws_appconfig_deployment                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  669 | CKV2_AWS_37     | resource | aws_appconfig_deployment_strategy                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  670 | CKV2_AWS_37     | resource | aws_appconfig_environment                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  671 | CKV2_AWS_37     | resource | aws_appconfig_extension                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  672 | CKV2_AWS_37     | resource | aws_appconfig_extension_association                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  673 | CKV2_AWS_37     | resource | aws_appconfig_hosted_configuration_version                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  674 | CKV2_AWS_37     | resource | aws_appfabric_app_authorization                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  675 | CKV2_AWS_37     | resource | aws_appfabric_app_authorization_connection                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  676 | CKV2_AWS_37     | resource | aws_appfabric_app_bundle                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  677 | CKV2_AWS_37     | resource | aws_appfabric_ingestion                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  678 | CKV2_AWS_37     | resource | aws_appfabric_ingestion_destination                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  679 | CKV2_AWS_37     | resource | aws_appflow_connector_profile                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  680 | CKV2_AWS_37     | resource | aws_appflow_flow                                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  681 | CKV2_AWS_37     | resource | aws_appintegrations_data_integration                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  682 | CKV2_AWS_37     | resource | aws_appintegrations_event_integration                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  683 | CKV2_AWS_37     | resource | aws_applicationinsights_application                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  684 | CKV2_AWS_37     | resource | aws_appmesh_gateway_route                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  685 | CKV2_AWS_37     | resource | aws_appmesh_mesh                                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  686 | CKV2_AWS_37     | resource | aws_appmesh_route                                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  687 | CKV2_AWS_37     | resource | aws_appmesh_virtual_gateway                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  688 | CKV2_AWS_37     | resource | aws_appmesh_virtual_node                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  689 | CKV2_AWS_37     | resource | aws_appmesh_virtual_router                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  690 | CKV2_AWS_37     | resource | aws_appmesh_virtual_service                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  691 | CKV2_AWS_37     | resource | aws_apprunner_auto_scaling_configuration_version                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  692 | CKV2_AWS_37     | resource | aws_apprunner_connection                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  693 | CKV2_AWS_37     | resource | aws_apprunner_custom_domain_association                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  694 | CKV2_AWS_37     | resource | aws_apprunner_default_auto_scaling_configuration_version         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  695 | CKV2_AWS_37     | resource | aws_apprunner_deployment                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  696 | CKV2_AWS_37     | resource | aws_apprunner_observability_configuration                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  697 | CKV2_AWS_37     | resource | aws_apprunner_service                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  698 | CKV2_AWS_37     | resource | aws_apprunner_vpc_connector                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  699 | CKV2_AWS_37     | resource | aws_apprunner_vpc_ingress_connection                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  700 | CKV2_AWS_37     | resource | aws_appstream_directory_config                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  701 | CKV2_AWS_37     | resource | aws_appstream_fleet                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  702 | CKV2_AWS_37     | resource | aws_appstream_fleet_stack_association                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  703 | CKV2_AWS_37     | resource | aws_appstream_image_builder                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  704 | CKV2_AWS_37     | resource | aws_appstream_stack                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  705 | CKV2_AWS_37     | resource | aws_appstream_user                                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  706 | CKV2_AWS_37     | resource | aws_appstream_user_stack_association                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  707 | CKV2_AWS_37     | resource | aws_appsync_api_cache                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  708 | CKV2_AWS_37     | resource | aws_appsync_api_key                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  709 | CKV2_AWS_37     | resource | aws_appsync_datasource                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  710 | CKV2_AWS_37     | resource | aws_appsync_domain_name                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  711 | CKV2_AWS_37     | resource | aws_appsync_domain_name_api_association                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  712 | CKV2_AWS_37     | resource | aws_appsync_function                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  713 | CKV2_AWS_37     | resource | aws_appsync_graphql_api                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  714 | CKV2_AWS_37     | resource | aws_appsync_resolver                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  715 | CKV2_AWS_37     | resource | aws_appsync_source_api_association                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  716 | CKV2_AWS_37     | resource | aws_appsync_type                                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  717 | CKV2_AWS_37     | resource | aws_athena_data_catalog                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  718 | CKV2_AWS_37     | resource | aws_athena_database                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  719 | CKV2_AWS_37     | resource | aws_athena_named_query                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  720 | CKV2_AWS_37     | resource | aws_athena_prepared_statement                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  721 | CKV2_AWS_37     | resource | aws_athena_workgroup                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  722 | CKV2_AWS_37     | resource | aws_auditmanager_account_registration                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  723 | CKV2_AWS_37     | resource | aws_auditmanager_assessment                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  724 | CKV2_AWS_37     | resource | aws_auditmanager_assessment_delegation                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  725 | CKV2_AWS_37     | resource | aws_auditmanager_assessment_report                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  726 | CKV2_AWS_37     | resource | aws_auditmanager_control                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  727 | CKV2_AWS_37     | resource | aws_auditmanager_framework                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  728 | CKV2_AWS_37     | resource | aws_auditmanager_framework_share                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  729 | CKV2_AWS_37     | resource | aws_auditmanager_organization_admin_account_registration         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  730 | CKV2_AWS_37     | resource | aws_autoscaling_attachment                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  731 | CKV2_AWS_37     | resource | aws_autoscaling_group                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  732 | CKV2_AWS_37     | resource | aws_autoscaling_group_tag                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  733 | CKV2_AWS_37     | resource | aws_autoscaling_lifecycle_hook                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  734 | CKV2_AWS_37     | resource | aws_autoscaling_notification                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  735 | CKV2_AWS_37     | resource | aws_autoscaling_policy                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  736 | CKV2_AWS_37     | resource | aws_autoscaling_schedule                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  737 | CKV2_AWS_37     | resource | aws_autoscaling_traffic_source_attachment                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  738 | CKV2_AWS_37     | resource | aws_autoscalingplans_scaling_plan                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  739 | CKV2_AWS_37     | resource | aws_az_info                                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  740 | CKV2_AWS_37     | resource | aws_backup_framework                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  741 | CKV2_AWS_37     | resource | aws_backup_global_settings                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  742 | CKV2_AWS_37     | resource | aws_backup_logically_air_gapped_vault                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  743 | CKV2_AWS_37     | resource | aws_backup_plan                                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  744 | CKV2_AWS_37     | resource | aws_backup_region_settings                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  745 | CKV2_AWS_37     | resource | aws_backup_report_plan                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  746 | CKV2_AWS_37     | resource | aws_backup_restore_testing_plan                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  747 | CKV2_AWS_37     | resource | aws_backup_restore_testing_selection                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  748 | CKV2_AWS_37     | resource | aws_backup_selection                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  749 | CKV2_AWS_37     | resource | aws_backup_vault                                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  750 | CKV2_AWS_37     | resource | aws_backup_vault_lock_configuration                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  751 | CKV2_AWS_37     | resource | aws_backup_vault_notifications                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  752 | CKV2_AWS_37     | resource | aws_backup_vault_policy                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  753 | CKV2_AWS_37     | resource | aws_batch_compute_environment                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  754 | CKV2_AWS_37     | resource | aws_batch_job_definition                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  755 | CKV2_AWS_37     | resource | aws_batch_job_queue                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  756 | CKV2_AWS_37     | resource | aws_batch_scheduling_policy                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  757 | CKV2_AWS_37     | resource | aws_bcmdataexports_export                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  758 | CKV2_AWS_37     | resource | aws_bedrock_custom_model                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  759 | CKV2_AWS_37     | resource | aws_bedrock_guardrail                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  760 | CKV2_AWS_37     | resource | aws_bedrock_guardrail_version                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  761 | CKV2_AWS_37     | resource | aws_bedrock_inference_profile                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  762 | CKV2_AWS_37     | resource | aws_bedrock_model_invocation_logging_configuration               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  763 | CKV2_AWS_37     | resource | aws_bedrock_provisioned_model_throughput                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  764 | CKV2_AWS_37     | resource | aws_bedrockagent_agent                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  765 | CKV2_AWS_37     | resource | aws_bedrockagent_agent_action_group                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  766 | CKV2_AWS_37     | resource | aws_bedrockagent_agent_alias                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  767 | CKV2_AWS_37     | resource | aws_bedrockagent_agent_collaborator                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  768 | CKV2_AWS_37     | resource | aws_bedrockagent_agent_knowledge_base_association                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  769 | CKV2_AWS_37     | resource | aws_bedrockagent_data_source                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  770 | CKV2_AWS_37     | resource | aws_bedrockagent_knowledge_base                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  771 | CKV2_AWS_37     | resource | aws_budgets_budget                                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  772 | CKV2_AWS_37     | resource | aws_budgets_budget_action                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  773 | CKV2_AWS_37     | resource | aws_caller_info                                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  774 | CKV2_AWS_37     | resource | aws_ce_anomaly_monitor                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  775 | CKV2_AWS_37     | resource | aws_ce_anomaly_subscription                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  776 | CKV2_AWS_37     | resource | aws_ce_cost_allocation_tag                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  777 | CKV2_AWS_37     | resource | aws_ce_cost_category                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  778 | CKV2_AWS_37     | resource | aws_chatbot_slack_channel_configuration                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  779 | CKV2_AWS_37     | resource | aws_chatbot_teams_channel_configuration                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  780 | CKV2_AWS_37     | resource | aws_chime_voice_connector                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  781 | CKV2_AWS_37     | resource | aws_chime_voice_connector_group                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  782 | CKV2_AWS_37     | resource | aws_chime_voice_connector_logging                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  783 | CKV2_AWS_37     | resource | aws_chime_voice_connector_origination                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  784 | CKV2_AWS_37     | resource | aws_chime_voice_connector_streaming                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  785 | CKV2_AWS_37     | resource | aws_chime_voice_connector_termination                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  786 | CKV2_AWS_37     | resource | aws_chime_voice_connector_termination_credentials                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  787 | CKV2_AWS_37     | resource | aws_chimesdkmediapipelines_media_insights_pipeline_configuration | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  788 | CKV2_AWS_37     | resource | aws_chimesdkvoice_global_settings                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  789 | CKV2_AWS_37     | resource | aws_chimesdkvoice_sip_media_application                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  790 | CKV2_AWS_37     | resource | aws_chimesdkvoice_sip_rule                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  791 | CKV2_AWS_37     | resource | aws_chimesdkvoice_voice_profile_domain                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  792 | CKV2_AWS_37     | resource | aws_cleanrooms_collaboration                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  793 | CKV2_AWS_37     | resource | aws_cleanrooms_configured_table                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  794 | CKV2_AWS_37     | resource | aws_cleanrooms_membership                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  795 | CKV2_AWS_37     | resource | aws_cloud9_environment_ec2                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  796 | CKV2_AWS_37     | resource | aws_cloud9_environment_membership                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  797 | CKV2_AWS_37     | resource | aws_cloudcontrolapi_resource                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  798 | CKV2_AWS_37     | resource | aws_cloudformation_stack                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  799 | CKV2_AWS_37     | resource | aws_cloudformation_stack_instances                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  800 | CKV2_AWS_37     | resource | aws_cloudformation_stack_set                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  801 | CKV2_AWS_37     | resource | aws_cloudformation_stack_set_instance                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  802 | CKV2_AWS_37     | resource | aws_cloudformation_type                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  803 | CKV2_AWS_37     | resource | aws_cloudfront_cache_policy                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  804 | CKV2_AWS_37     | resource | aws_cloudfront_continuous_deployment_policy                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  805 | CKV2_AWS_37     | resource | aws_cloudfront_distribution                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  806 | CKV2_AWS_37     | resource | aws_cloudfront_field_level_encryption_config                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  807 | CKV2_AWS_37     | resource | aws_cloudfront_field_level_encryption_profile                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  808 | CKV2_AWS_37     | resource | aws_cloudfront_function                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  809 | CKV2_AWS_37     | resource | aws_cloudfront_key_group                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  810 | CKV2_AWS_37     | resource | aws_cloudfront_key_value_store                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  811 | CKV2_AWS_37     | resource | aws_cloudfront_monitoring_subscription                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  812 | CKV2_AWS_37     | resource | aws_cloudfront_origin_access_control                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  813 | CKV2_AWS_37     | resource | aws_cloudfront_origin_access_identity                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  814 | CKV2_AWS_37     | resource | aws_cloudfront_origin_request_policy                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  815 | CKV2_AWS_37     | resource | aws_cloudfront_public_key                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  816 | CKV2_AWS_37     | resource | aws_cloudfront_realtime_log_config                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  817 | CKV2_AWS_37     | resource | aws_cloudfront_response_headers_policy                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  818 | CKV2_AWS_37     | resource | aws_cloudfront_vpc_origin                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  819 | CKV2_AWS_37     | resource | aws_cloudfrontkeyvaluestore_key                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  820 | CKV2_AWS_37     | resource | aws_cloudhsm_v2_cluster                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  821 | CKV2_AWS_37     | resource | aws_cloudhsm_v2_hsm                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  822 | CKV2_AWS_37     | resource | aws_cloudsearch_domain                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  823 | CKV2_AWS_37     | resource | aws_cloudsearch_domain_service_access_policy                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  824 | CKV2_AWS_37     | resource | aws_cloudtrail                                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  825 | CKV2_AWS_37     | resource | aws_cloudtrail_event_data_store                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  826 | CKV2_AWS_37     | resource | aws_cloudtrail_organization_delegated_admin_account              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  827 | CKV2_AWS_37     | resource | aws_cloudwatch_composite_alarm                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  828 | CKV2_AWS_37     | resource | aws_cloudwatch_dashboard                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  829 | CKV2_AWS_37     | resource | aws_cloudwatch_event_api_destination                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  830 | CKV2_AWS_37     | resource | aws_cloudwatch_event_archive                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  831 | CKV2_AWS_37     | resource | aws_cloudwatch_event_bus                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  832 | CKV2_AWS_37     | resource | aws_cloudwatch_event_bus_policy                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  833 | CKV2_AWS_37     | resource | aws_cloudwatch_event_connection                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  834 | CKV2_AWS_37     | resource | aws_cloudwatch_event_endpoint                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  835 | CKV2_AWS_37     | resource | aws_cloudwatch_event_permission                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  836 | CKV2_AWS_37     | resource | aws_cloudwatch_event_rule                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  837 | CKV2_AWS_37     | resource | aws_cloudwatch_event_target                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  838 | CKV2_AWS_37     | resource | aws_cloudwatch_log_account_policy                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  839 | CKV2_AWS_37     | resource | aws_cloudwatch_log_anomaly_detector                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  840 | CKV2_AWS_37     | resource | aws_cloudwatch_log_data_protection_policy                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  841 | CKV2_AWS_37     | resource | aws_cloudwatch_log_delivery                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  842 | CKV2_AWS_37     | resource | aws_cloudwatch_log_delivery_destination                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  843 | CKV2_AWS_37     | resource | aws_cloudwatch_log_delivery_destination_policy                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  844 | CKV2_AWS_37     | resource | aws_cloudwatch_log_delivery_source                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  845 | CKV2_AWS_37     | resource | aws_cloudwatch_log_destination                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  846 | CKV2_AWS_37     | resource | aws_cloudwatch_log_destination_policy                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  847 | CKV2_AWS_37     | resource | aws_cloudwatch_log_group                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  848 | CKV2_AWS_37     | resource | aws_cloudwatch_log_index_policy                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  849 | CKV2_AWS_37     | resource | aws_cloudwatch_log_metric_filter                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  850 | CKV2_AWS_37     | resource | aws_cloudwatch_log_resource_policy                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  851 | CKV2_AWS_37     | resource | aws_cloudwatch_log_stream                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  852 | CKV2_AWS_37     | resource | aws_cloudwatch_log_subscription_filter                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  853 | CKV2_AWS_37     | resource | aws_cloudwatch_metric_alarm                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  854 | CKV2_AWS_37     | resource | aws_cloudwatch_metric_stream                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  855 | CKV2_AWS_37     | resource | aws_cloudwatch_query_definition                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  856 | CKV2_AWS_37     | resource | aws_codeartifact_domain                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  857 | CKV2_AWS_37     | resource | aws_codeartifact_domain_permissions_policy                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  858 | CKV2_AWS_37     | resource | aws_codeartifact_repository                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  859 | CKV2_AWS_37     | resource | aws_codeartifact_repository_permissions_policy                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  860 | CKV2_AWS_37     | resource | aws_codebuild_fleet                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  861 | CKV2_AWS_37     | resource | aws_codebuild_project                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  862 | CKV2_AWS_37     | resource | aws_codebuild_report_group                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  863 | CKV2_AWS_37     | resource | aws_codebuild_resource_policy                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  864 | CKV2_AWS_37     | resource | aws_codebuild_source_credential                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  865 | CKV2_AWS_37     | resource | aws_codebuild_webhook                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  866 | CKV2_AWS_37     | resource | aws_codecatalyst_dev_environment                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  867 | CKV2_AWS_37     | resource | aws_codecatalyst_project                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  868 | CKV2_AWS_37     | resource | aws_codecatalyst_source_repository                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  869 | CKV2_AWS_37     | resource | aws_codecommit_approval_rule_template                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  870 | CKV2_AWS_37     | resource | aws_codecommit_approval_rule_template_association                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  871 | CKV2_AWS_37     | resource | aws_codecommit_repository                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  872 | CKV2_AWS_37     | resource | aws_codecommit_trigger                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  873 | CKV2_AWS_37     | resource | aws_codeconnections_connection                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  874 | CKV2_AWS_37     | resource | aws_codeconnections_host                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  875 | CKV2_AWS_37     | resource | aws_codedeploy_app                                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  876 | CKV2_AWS_37     | resource | aws_codedeploy_deployment_config                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  877 | CKV2_AWS_37     | resource | aws_codedeploy_deployment_group                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  878 | CKV2_AWS_37     | resource | aws_codeguruprofiler_profiling_group                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  879 | CKV2_AWS_37     | resource | aws_codegurureviewer_repository_association                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  880 | CKV2_AWS_37     | resource | aws_codepipeline                                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  881 | CKV2_AWS_37     | resource | aws_codepipeline_custom_action_type                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  882 | CKV2_AWS_37     | resource | aws_codepipeline_webhook                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  883 | CKV2_AWS_37     | resource | aws_codestarconnections_connection                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  884 | CKV2_AWS_37     | resource | aws_codestarconnections_host                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  885 | CKV2_AWS_37     | resource | aws_codestarnotifications_notification_rule                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  886 | CKV2_AWS_37     | resource | aws_cognito_identity_pool                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  887 | CKV2_AWS_37     | resource | aws_cognito_identity_pool_provider_principal_tag                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  888 | CKV2_AWS_37     | resource | aws_cognito_identity_pool_roles_attachment                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  889 | CKV2_AWS_37     | resource | aws_cognito_identity_provider                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  890 | CKV2_AWS_37     | resource | aws_cognito_managed_user_pool_client                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  891 | CKV2_AWS_37     | resource | aws_cognito_resource_server                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  892 | CKV2_AWS_37     | resource | aws_cognito_risk_configuration                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  893 | CKV2_AWS_37     | resource | aws_cognito_user                                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  894 | CKV2_AWS_37     | resource | aws_cognito_user_group                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  895 | CKV2_AWS_37     | resource | aws_cognito_user_in_group                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  896 | CKV2_AWS_37     | resource | aws_cognito_user_pool                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  897 | CKV2_AWS_37     | resource | aws_cognito_user_pool_client                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  898 | CKV2_AWS_37     | resource | aws_cognito_user_pool_domain                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  899 | CKV2_AWS_37     | resource | aws_cognito_user_pool_ui_customization                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  900 | CKV2_AWS_37     | resource | aws_comprehend_document_classifier                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  901 | CKV2_AWS_37     | resource | aws_comprehend_entity_recognizer                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  902 | CKV2_AWS_37     | resource | aws_computeoptimizer_enrollment_status                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  903 | CKV2_AWS_37     | resource | aws_computeoptimizer_recommendation_preferences                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  904 | CKV2_AWS_37     | resource | aws_config_aggregate_authorization                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  905 | CKV2_AWS_37     | resource | aws_config_config_rule                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  906 | CKV2_AWS_37     | resource | aws_config_configuration_aggregator                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  907 | CKV2_AWS_37     | resource | aws_config_configuration_recorder                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  908 | CKV2_AWS_37     | resource | aws_config_configuration_recorder_status                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  909 | CKV2_AWS_37     | resource | aws_config_conformance_pack                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  910 | CKV2_AWS_37     | resource | aws_config_delivery_channel                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  911 | CKV2_AWS_37     | resource | aws_config_organization_conformance_pack                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  912 | CKV2_AWS_37     | resource | aws_config_organization_custom_policy_rule                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  913 | CKV2_AWS_37     | resource | aws_config_organization_custom_rule                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  914 | CKV2_AWS_37     | resource | aws_config_organization_managed_rule                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  915 | CKV2_AWS_37     | resource | aws_config_remediation_configuration                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  916 | CKV2_AWS_37     | resource | aws_config_retention_configuration                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  917 | CKV2_AWS_37     | resource | aws_connect_bot_association                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  918 | CKV2_AWS_37     | resource | aws_connect_contact_flow                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  919 | CKV2_AWS_37     | resource | aws_connect_contact_flow_module                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  920 | CKV2_AWS_37     | resource | aws_connect_hours_of_operation                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  921 | CKV2_AWS_37     | resource | aws_connect_instance                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  922 | CKV2_AWS_37     | resource | aws_connect_instance_storage_config                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  923 | CKV2_AWS_37     | resource | aws_connect_lambda_function_association                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  924 | CKV2_AWS_37     | resource | aws_connect_phone_number                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  925 | CKV2_AWS_37     | resource | aws_connect_queue                                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  926 | CKV2_AWS_37     | resource | aws_connect_quick_connect                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  927 | CKV2_AWS_37     | resource | aws_connect_routing_profile                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  928 | CKV2_AWS_37     | resource | aws_connect_security_profile                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  929 | CKV2_AWS_37     | resource | aws_connect_user                                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  930 | CKV2_AWS_37     | resource | aws_connect_user_hierarchy_group                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  931 | CKV2_AWS_37     | resource | aws_connect_user_hierarchy_structure                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  932 | CKV2_AWS_37     | resource | aws_connect_vocabulary                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  933 | CKV2_AWS_37     | resource | aws_controltower_control                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  934 | CKV2_AWS_37     | resource | aws_controltower_landing_zone                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  935 | CKV2_AWS_37     | resource | aws_costoptimizationhub_enrollment_status                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  936 | CKV2_AWS_37     | resource | aws_costoptimizationhub_preferences                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  937 | CKV2_AWS_37     | resource | aws_cur_report_definition                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  938 | CKV2_AWS_37     | resource | aws_customer_gateway                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  939 | CKV2_AWS_37     | resource | aws_customerprofiles_domain                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  940 | CKV2_AWS_37     | resource | aws_customerprofiles_profile                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  941 | CKV2_AWS_37     | resource | aws_dataexchange_data_set                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  942 | CKV2_AWS_37     | resource | aws_dataexchange_revision                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  943 | CKV2_AWS_37     | resource | aws_datapipeline_pipeline                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  944 | CKV2_AWS_37     | resource | aws_datapipeline_pipeline_definition                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  945 | CKV2_AWS_37     | resource | aws_datasync_agent                                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  946 | CKV2_AWS_37     | resource | aws_datasync_location_azure_blob                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  947 | CKV2_AWS_37     | resource | aws_datasync_location_efs                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  948 | CKV2_AWS_37     | resource | aws_datasync_location_fsx_lustre_file_system                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  949 | CKV2_AWS_37     | resource | aws_datasync_location_fsx_ontap_file_system                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  950 | CKV2_AWS_37     | resource | aws_datasync_location_fsx_openzfs_file_system                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  951 | CKV2_AWS_37     | resource | aws_datasync_location_fsx_windows_file_system                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  952 | CKV2_AWS_37     | resource | aws_datasync_location_hdfs                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  953 | CKV2_AWS_37     | resource | aws_datasync_location_nfs                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  954 | CKV2_AWS_37     | resource | aws_datasync_location_object_storage                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  955 | CKV2_AWS_37     | resource | aws_datasync_location_s3                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  956 | CKV2_AWS_37     | resource | aws_datasync_location_smb                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  957 | CKV2_AWS_37     | resource | aws_datasync_task                                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  958 | CKV2_AWS_37     | resource | aws_datazone_asset_type                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  959 | CKV2_AWS_37     | resource | aws_datazone_domain                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  960 | CKV2_AWS_37     | resource | aws_datazone_environment                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  961 | CKV2_AWS_37     | resource | aws_datazone_environment_blueprint_configuration                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  962 | CKV2_AWS_37     | resource | aws_datazone_environment_profile                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  963 | CKV2_AWS_37     | resource | aws_datazone_form_type                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  964 | CKV2_AWS_37     | resource | aws_datazone_glossary                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  965 | CKV2_AWS_37     | resource | aws_datazone_glossary_term                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  966 | CKV2_AWS_37     | resource | aws_datazone_project                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  967 | CKV2_AWS_37     | resource | aws_datazone_user_profile                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  968 | CKV2_AWS_37     | resource | aws_dax_cluster                                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  969 | CKV2_AWS_37     | resource | aws_dax_parameter_group                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  970 | CKV2_AWS_37     | resource | aws_dax_subnet_group                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  971 | CKV2_AWS_37     | resource | aws_db_cluster_snapshot                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  972 | CKV2_AWS_37     | resource | aws_db_event_subscription                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  973 | CKV2_AWS_37     | resource | aws_db_instance                                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  974 | CKV2_AWS_37     | resource | aws_db_instance_automated_backups_replication                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  975 | CKV2_AWS_37     | resource | aws_db_instance_role_association                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  976 | CKV2_AWS_37     | resource | aws_db_option_group                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  977 | CKV2_AWS_37     | resource | aws_db_parameter_group                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  978 | CKV2_AWS_37     | resource | aws_db_proxy                                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  979 | CKV2_AWS_37     | resource | aws_db_proxy_default_target_group                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  980 | CKV2_AWS_37     | resource | aws_db_proxy_endpoint                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  981 | CKV2_AWS_37     | resource | aws_db_proxy_target                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  982 | CKV2_AWS_37     | resource | aws_db_security_group                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  983 | CKV2_AWS_37     | resource | aws_db_snapshot                                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  984 | CKV2_AWS_37     | resource | aws_db_snapshot_copy                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  985 | CKV2_AWS_37     | resource | aws_db_subnet_group                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  986 | CKV2_AWS_37     | resource | aws_default_network_acl                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  987 | CKV2_AWS_37     | resource | aws_default_route_table                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  988 | CKV2_AWS_37     | resource | aws_default_security_group                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  989 | CKV2_AWS_37     | resource | aws_default_subnet                                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  990 | CKV2_AWS_37     | resource | aws_default_vpc                                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  991 | CKV2_AWS_37     | resource | aws_default_vpc_dhcp_options                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  992 | CKV2_AWS_37     | resource | aws_detective_graph                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  993 | CKV2_AWS_37     | resource | aws_detective_invitation_accepter                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  994 | CKV2_AWS_37     | resource | aws_detective_member                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  995 | CKV2_AWS_37     | resource | aws_detective_organization_admin_account                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  996 | CKV2_AWS_37     | resource | aws_detective_organization_configuration                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  997 | CKV2_AWS_37     | resource | aws_devicefarm_device_pool                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  998 | CKV2_AWS_37     | resource | aws_devicefarm_instance_profile                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
|  999 | CKV2_AWS_37     | resource | aws_devicefarm_network_profile                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1000 | CKV2_AWS_37     | resource | aws_devicefarm_project                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1001 | CKV2_AWS_37     | resource | aws_devicefarm_test_grid_project                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1002 | CKV2_AWS_37     | resource | aws_devicefarm_upload                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1003 | CKV2_AWS_37     | resource | aws_devopsguru_event_sources_config                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1004 | CKV2_AWS_37     | resource | aws_devopsguru_notification_channel                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1005 | CKV2_AWS_37     | resource | aws_devopsguru_resource_collection                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1006 | CKV2_AWS_37     | resource | aws_devopsguru_service_integration                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1007 | CKV2_AWS_37     | resource | aws_directory_service_conditional_forwarder                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1008 | CKV2_AWS_37     | resource | aws_directory_service_directory                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1009 | CKV2_AWS_37     | resource | aws_directory_service_log_subscription                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1010 | CKV2_AWS_37     | resource | aws_directory_service_radius_settings                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1011 | CKV2_AWS_37     | resource | aws_directory_service_region                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1012 | CKV2_AWS_37     | resource | aws_directory_service_shared_directory                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1013 | CKV2_AWS_37     | resource | aws_directory_service_shared_directory_accepter                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1014 | CKV2_AWS_37     | resource | aws_directory_service_trust                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1015 | CKV2_AWS_37     | resource | aws_dlm_lifecycle_policy                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1016 | CKV2_AWS_37     | resource | aws_dms_certificate                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1017 | CKV2_AWS_37     | resource | aws_dms_endpoint                                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1018 | CKV2_AWS_37     | resource | aws_dms_event_subscription                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1019 | CKV2_AWS_37     | resource | aws_dms_replication_config                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1020 | CKV2_AWS_37     | resource | aws_dms_replication_instance                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1021 | CKV2_AWS_37     | resource | aws_dms_replication_subnet_group                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1022 | CKV2_AWS_37     | resource | aws_dms_replication_task                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1023 | CKV2_AWS_37     | resource | aws_dms_s3_endpoint                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1024 | CKV2_AWS_37     | resource | aws_docdb_cluster                                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1025 | CKV2_AWS_37     | resource | aws_docdb_cluster_instance                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1026 | CKV2_AWS_37     | resource | aws_docdb_cluster_parameter_group                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1027 | CKV2_AWS_37     | resource | aws_docdb_cluster_snapshot                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1028 | CKV2_AWS_37     | resource | aws_docdb_event_subscription                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1029 | CKV2_AWS_37     | resource | aws_docdb_global_cluster                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1030 | CKV2_AWS_37     | resource | aws_docdb_subnet_group                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1031 | CKV2_AWS_37     | resource | aws_docdbelastic_cluster                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1032 | CKV2_AWS_37     | resource | aws_drs_replication_configuration_template                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1033 | CKV2_AWS_37     | resource | aws_dx_bgp_peer                                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1034 | CKV2_AWS_37     | resource | aws_dx_connection                                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1035 | CKV2_AWS_37     | resource | aws_dx_connection_association                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1036 | CKV2_AWS_37     | resource | aws_dx_connection_confirmation                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1037 | CKV2_AWS_37     | resource | aws_dx_gateway                                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1038 | CKV2_AWS_37     | resource | aws_dx_gateway_association                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1039 | CKV2_AWS_37     | resource | aws_dx_gateway_association_proposal                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1040 | CKV2_AWS_37     | resource | aws_dx_hosted_connection                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1041 | CKV2_AWS_37     | resource | aws_dx_hosted_private_virtual_interface                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1042 | CKV2_AWS_37     | resource | aws_dx_hosted_private_virtual_interface_accepter                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1043 | CKV2_AWS_37     | resource | aws_dx_hosted_public_virtual_interface                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1044 | CKV2_AWS_37     | resource | aws_dx_hosted_public_virtual_interface_accepter                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1045 | CKV2_AWS_37     | resource | aws_dx_hosted_transit_virtual_interface                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1046 | CKV2_AWS_37     | resource | aws_dx_hosted_transit_virtual_interface_accepter                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1047 | CKV2_AWS_37     | resource | aws_dx_lag                                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1048 | CKV2_AWS_37     | resource | aws_dx_macsec_key_association                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1049 | CKV2_AWS_37     | resource | aws_dx_private_virtual_interface                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1050 | CKV2_AWS_37     | resource | aws_dx_public_virtual_interface                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1051 | CKV2_AWS_37     | resource | aws_dx_transit_virtual_interface                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1052 | CKV2_AWS_37     | resource | aws_dynamodb_contributor_insights                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1053 | CKV2_AWS_37     | resource | aws_dynamodb_global_table                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1054 | CKV2_AWS_37     | resource | aws_dynamodb_kinesis_streaming_destination                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1055 | CKV2_AWS_37     | resource | aws_dynamodb_resource_policy                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1056 | CKV2_AWS_37     | resource | aws_dynamodb_table                                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1057 | CKV2_AWS_37     | resource | aws_dynamodb_table_export                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1058 | CKV2_AWS_37     | resource | aws_dynamodb_table_item                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1059 | CKV2_AWS_37     | resource | aws_dynamodb_table_replica                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1060 | CKV2_AWS_37     | resource | aws_dynamodb_tag                                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1061 | CKV2_AWS_37     | resource | aws_ebs_default_kms_key                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1062 | CKV2_AWS_37     | resource | aws_ebs_encryption_by_default                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1063 | CKV2_AWS_37     | resource | aws_ebs_fast_snapshot_restore                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1064 | CKV2_AWS_37     | resource | aws_ebs_snapshot                                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1065 | CKV2_AWS_37     | resource | aws_ebs_snapshot_block_public_access                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1066 | CKV2_AWS_37     | resource | aws_ebs_snapshot_copy                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1067 | CKV2_AWS_37     | resource | aws_ebs_snapshot_import                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1068 | CKV2_AWS_37     | resource | aws_ebs_volume                                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1069 | CKV2_AWS_37     | resource | aws_ec2_availability_zone_group                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1070 | CKV2_AWS_37     | resource | aws_ec2_capacity_block_reservation                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1071 | CKV2_AWS_37     | resource | aws_ec2_capacity_reservation                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1072 | CKV2_AWS_37     | resource | aws_ec2_carrier_gateway                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1073 | CKV2_AWS_37     | resource | aws_ec2_client_vpn_authorization_rule                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1074 | CKV2_AWS_37     | resource | aws_ec2_client_vpn_endpoint                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1075 | CKV2_AWS_37     | resource | aws_ec2_client_vpn_network_association                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1076 | CKV2_AWS_37     | resource | aws_ec2_client_vpn_route                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1077 | CKV2_AWS_37     | resource | aws_ec2_fleet                                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1078 | CKV2_AWS_37     | resource | aws_ec2_host                                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1079 | CKV2_AWS_37     | resource | aws_ec2_image_block_public_access                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1080 | CKV2_AWS_37     | resource | aws_ec2_instance_connect_endpoint                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1081 | CKV2_AWS_37     | resource | aws_ec2_instance_metadata_defaults                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1082 | CKV2_AWS_37     | resource | aws_ec2_instance_state                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1083 | CKV2_AWS_37     | resource | aws_ec2_local_gateway_route                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1084 | CKV2_AWS_37     | resource | aws_ec2_local_gateway_route_table_vpc_association                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1085 | CKV2_AWS_37     | resource | aws_ec2_managed_prefix_list                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1086 | CKV2_AWS_37     | resource | aws_ec2_managed_prefix_list_entry                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1087 | CKV2_AWS_37     | resource | aws_ec2_network_insights_analysis                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1088 | CKV2_AWS_37     | resource | aws_ec2_network_insights_path                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1089 | CKV2_AWS_37     | resource | aws_ec2_serial_console_access                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1090 | CKV2_AWS_37     | resource | aws_ec2_subnet_cidr_reservation                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1091 | CKV2_AWS_37     | resource | aws_ec2_tag                                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1092 | CKV2_AWS_37     | resource | aws_ec2_traffic_mirror_filter                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1093 | CKV2_AWS_37     | resource | aws_ec2_traffic_mirror_filter_rule                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1094 | CKV2_AWS_37     | resource | aws_ec2_traffic_mirror_session                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1095 | CKV2_AWS_37     | resource | aws_ec2_traffic_mirror_target                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1096 | CKV2_AWS_37     | resource | aws_ec2_transit_gateway                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1097 | CKV2_AWS_37     | resource | aws_ec2_transit_gateway_connect                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1098 | CKV2_AWS_37     | resource | aws_ec2_transit_gateway_connect_peer                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1099 | CKV2_AWS_37     | resource | aws_ec2_transit_gateway_default_route_table_association          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1100 | CKV2_AWS_37     | resource | aws_ec2_transit_gateway_default_route_table_propagation          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1101 | CKV2_AWS_37     | resource | aws_ec2_transit_gateway_multicast_domain                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1102 | CKV2_AWS_37     | resource | aws_ec2_transit_gateway_multicast_domain_association             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1103 | CKV2_AWS_37     | resource | aws_ec2_transit_gateway_multicast_group_member                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1104 | CKV2_AWS_37     | resource | aws_ec2_transit_gateway_multicast_group_source                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1105 | CKV2_AWS_37     | resource | aws_ec2_transit_gateway_peering_attachment                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1106 | CKV2_AWS_37     | resource | aws_ec2_transit_gateway_peering_attachment_accepter              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1107 | CKV2_AWS_37     | resource | aws_ec2_transit_gateway_policy_table                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1108 | CKV2_AWS_37     | resource | aws_ec2_transit_gateway_policy_table_association                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1109 | CKV2_AWS_37     | resource | aws_ec2_transit_gateway_prefix_list_reference                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1110 | CKV2_AWS_37     | resource | aws_ec2_transit_gateway_route                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1111 | CKV2_AWS_37     | resource | aws_ec2_transit_gateway_route_table                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1112 | CKV2_AWS_37     | resource | aws_ec2_transit_gateway_route_table_association                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1113 | CKV2_AWS_37     | resource | aws_ec2_transit_gateway_route_table_propagation                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1114 | CKV2_AWS_37     | resource | aws_ec2_transit_gateway_vpc_attachment                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1115 | CKV2_AWS_37     | resource | aws_ec2_transit_gateway_vpc_attachment_accepter                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1116 | CKV2_AWS_37     | resource | aws_ecr_account_setting                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1117 | CKV2_AWS_37     | resource | aws_ecr_lifecycle_policy                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1118 | CKV2_AWS_37     | resource | aws_ecr_pull_through_cache_rule                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1119 | CKV2_AWS_37     | resource | aws_ecr_registry_policy                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1120 | CKV2_AWS_37     | resource | aws_ecr_registry_scanning_configuration                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1121 | CKV2_AWS_37     | resource | aws_ecr_replication_configuration                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1122 | CKV2_AWS_37     | resource | aws_ecr_repository                                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1123 | CKV2_AWS_37     | resource | aws_ecr_repository_creation_template                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1124 | CKV2_AWS_37     | resource | aws_ecr_repository_policy                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1125 | CKV2_AWS_37     | resource | aws_ecrpublic_repository                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1126 | CKV2_AWS_37     | resource | aws_ecrpublic_repository_policy                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1127 | CKV2_AWS_37     | resource | aws_ecs_account_setting_default                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1128 | CKV2_AWS_37     | resource | aws_ecs_capacity_provider                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1129 | CKV2_AWS_37     | resource | aws_ecs_cluster                                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1130 | CKV2_AWS_37     | resource | aws_ecs_cluster_capacity_providers                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1131 | CKV2_AWS_37     | resource | aws_ecs_service                                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1132 | CKV2_AWS_37     | resource | aws_ecs_tag                                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1133 | CKV2_AWS_37     | resource | aws_ecs_task_definition                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1134 | CKV2_AWS_37     | resource | aws_ecs_task_set                                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1135 | CKV2_AWS_37     | resource | aws_efs_access_point                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1136 | CKV2_AWS_37     | resource | aws_efs_backup_policy                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1137 | CKV2_AWS_37     | resource | aws_efs_file_system                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1138 | CKV2_AWS_37     | resource | aws_efs_file_system_policy                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1139 | CKV2_AWS_37     | resource | aws_efs_mount_target                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1140 | CKV2_AWS_37     | resource | aws_efs_replication_configuration                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1141 | CKV2_AWS_37     | resource | aws_egress_only_internet_gateway                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1142 | CKV2_AWS_37     | resource | aws_eip                                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1143 | CKV2_AWS_37     | resource | aws_eip_association                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1144 | CKV2_AWS_37     | resource | aws_eip_domain_name                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1145 | CKV2_AWS_37     | resource | aws_eks_access_entry                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1146 | CKV2_AWS_37     | resource | aws_eks_access_policy_association                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1147 | CKV2_AWS_37     | resource | aws_eks_addon                                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1148 | CKV2_AWS_37     | resource | aws_eks_cluster                                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1149 | CKV2_AWS_37     | resource | aws_eks_fargate_profile                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1150 | CKV2_AWS_37     | resource | aws_eks_identity_provider_config                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1151 | CKV2_AWS_37     | resource | aws_eks_node_group                                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1152 | CKV2_AWS_37     | resource | aws_eks_pod_identity_association                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1153 | CKV2_AWS_37     | resource | aws_elastic_beanstalk_application                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1154 | CKV2_AWS_37     | resource | aws_elastic_beanstalk_application_version                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1155 | CKV2_AWS_37     | resource | aws_elastic_beanstalk_configuration_template                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1156 | CKV2_AWS_37     | resource | aws_elastic_beanstalk_environment                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1157 | CKV2_AWS_37     | resource | aws_elasticache_cluster                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1158 | CKV2_AWS_37     | resource | aws_elasticache_global_replication_group                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1159 | CKV2_AWS_37     | resource | aws_elasticache_parameter_group                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1160 | CKV2_AWS_37     | resource | aws_elasticache_replication_group                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1161 | CKV2_AWS_37     | resource | aws_elasticache_reserved_cache_node                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1162 | CKV2_AWS_37     | resource | aws_elasticache_security_group                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1163 | CKV2_AWS_37     | resource | aws_elasticache_serverless_cache                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1164 | CKV2_AWS_37     | resource | aws_elasticache_subnet_group                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1165 | CKV2_AWS_37     | resource | aws_elasticache_user                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1166 | CKV2_AWS_37     | resource | aws_elasticache_user_group                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1167 | CKV2_AWS_37     | resource | aws_elasticache_user_group_association                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1168 | CKV2_AWS_37     | resource | aws_elasticsearch_domain                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1169 | CKV2_AWS_37     | resource | aws_elasticsearch_domain_policy                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1170 | CKV2_AWS_37     | resource | aws_elasticsearch_domain_saml_options                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1171 | CKV2_AWS_37     | resource | aws_elasticsearch_vpc_endpoint                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1172 | CKV2_AWS_37     | resource | aws_elastictranscoder_pipeline                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1173 | CKV2_AWS_37     | resource | aws_elastictranscoder_preset                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1174 | CKV2_AWS_37     | resource | aws_elb                                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1175 | CKV2_AWS_37     | resource | aws_elb_attachment                                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1176 | CKV2_AWS_37     | resource | aws_emr_block_public_access_configuration                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1177 | CKV2_AWS_37     | resource | aws_emr_cluster                                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1178 | CKV2_AWS_37     | resource | aws_emr_instance_fleet                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1179 | CKV2_AWS_37     | resource | aws_emr_instance_group                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1180 | CKV2_AWS_37     | resource | aws_emr_managed_scaling_policy                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1181 | CKV2_AWS_37     | resource | aws_emr_security_configuration                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1182 | CKV2_AWS_37     | resource | aws_emr_studio                                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1183 | CKV2_AWS_37     | resource | aws_emr_studio_session_mapping                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1184 | CKV2_AWS_37     | resource | aws_emrcontainers_job_template                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1185 | CKV2_AWS_37     | resource | aws_emrcontainers_virtual_cluster                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1186 | CKV2_AWS_37     | resource | aws_emrserverless_application                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1187 | CKV2_AWS_37     | resource | aws_evidently_feature                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1188 | CKV2_AWS_37     | resource | aws_evidently_launch                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1189 | CKV2_AWS_37     | resource | aws_evidently_project                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1190 | CKV2_AWS_37     | resource | aws_evidently_segment                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1191 | CKV2_AWS_37     | resource | aws_finspace_kx_cluster                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1192 | CKV2_AWS_37     | resource | aws_finspace_kx_database                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1193 | CKV2_AWS_37     | resource | aws_finspace_kx_dataview                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1194 | CKV2_AWS_37     | resource | aws_finspace_kx_environment                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1195 | CKV2_AWS_37     | resource | aws_finspace_kx_scaling_group                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1196 | CKV2_AWS_37     | resource | aws_finspace_kx_user                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1197 | CKV2_AWS_37     | resource | aws_finspace_kx_volume                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1198 | CKV2_AWS_37     | resource | aws_fis_experiment_template                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1199 | CKV2_AWS_37     | resource | aws_flow_log                                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1200 | CKV2_AWS_37     | resource | aws_fms_admin_account                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1201 | CKV2_AWS_37     | resource | aws_fms_policy                                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1202 | CKV2_AWS_37     | resource | aws_fms_resource_set                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1203 | CKV2_AWS_37     | resource | aws_fsx_backup                                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1204 | CKV2_AWS_37     | resource | aws_fsx_data_repository_association                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1205 | CKV2_AWS_37     | resource | aws_fsx_file_cache                                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1206 | CKV2_AWS_37     | resource | aws_fsx_lustre_file_system                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1207 | CKV2_AWS_37     | resource | aws_fsx_ontap_file_system                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1208 | CKV2_AWS_37     | resource | aws_fsx_ontap_storage_virtual_machine                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1209 | CKV2_AWS_37     | resource | aws_fsx_ontap_volume                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1210 | CKV2_AWS_37     | resource | aws_fsx_openzfs_file_system                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1211 | CKV2_AWS_37     | resource | aws_fsx_openzfs_snapshot                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1212 | CKV2_AWS_37     | resource | aws_fsx_openzfs_volume                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1213 | CKV2_AWS_37     | resource | aws_fsx_windows_file_system                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1214 | CKV2_AWS_37     | resource | aws_gamelift_alias                                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1215 | CKV2_AWS_37     | resource | aws_gamelift_build                                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1216 | CKV2_AWS_37     | resource | aws_gamelift_fleet                                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1217 | CKV2_AWS_37     | resource | aws_gamelift_game_server_group                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1218 | CKV2_AWS_37     | resource | aws_gamelift_game_session_queue                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1219 | CKV2_AWS_37     | resource | aws_gamelift_script                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1220 | CKV2_AWS_37     | resource | aws_glacier_vault                                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1221 | CKV2_AWS_37     | resource | aws_glacier_vault_lock                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1222 | CKV2_AWS_37     | resource | aws_globalaccelerator_accelerator                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1223 | CKV2_AWS_37     | resource | aws_globalaccelerator_cross_account_attachment                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1224 | CKV2_AWS_37     | resource | aws_globalaccelerator_custom_routing_accelerator                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1225 | CKV2_AWS_37     | resource | aws_globalaccelerator_custom_routing_endpoint_group              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1226 | CKV2_AWS_37     | resource | aws_globalaccelerator_custom_routing_listener                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1227 | CKV2_AWS_37     | resource | aws_globalaccelerator_endpoint_group                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1228 | CKV2_AWS_37     | resource | aws_globalaccelerator_listener                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1229 | CKV2_AWS_37     | resource | aws_glue_catalog_database                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1230 | CKV2_AWS_37     | resource | aws_glue_catalog_table                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1231 | CKV2_AWS_37     | resource | aws_glue_catalog_table_optimizer                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1232 | CKV2_AWS_37     | resource | aws_glue_classifier                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1233 | CKV2_AWS_37     | resource | aws_glue_connection                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1234 | CKV2_AWS_37     | resource | aws_glue_crawler                                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1235 | CKV2_AWS_37     | resource | aws_glue_data_catalog_encryption_settings                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1236 | CKV2_AWS_37     | resource | aws_glue_data_quality_ruleset                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1237 | CKV2_AWS_37     | resource | aws_glue_dev_endpoint                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1238 | CKV2_AWS_37     | resource | aws_glue_job                                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1239 | CKV2_AWS_37     | resource | aws_glue_ml_transform                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1240 | CKV2_AWS_37     | resource | aws_glue_partition                                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1241 | CKV2_AWS_37     | resource | aws_glue_partition_index                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1242 | CKV2_AWS_37     | resource | aws_glue_registry                                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1243 | CKV2_AWS_37     | resource | aws_glue_resource_policy                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1244 | CKV2_AWS_37     | resource | aws_glue_schema                                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1245 | CKV2_AWS_37     | resource | aws_glue_security_configuration                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1246 | CKV2_AWS_37     | resource | aws_glue_trigger                                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1247 | CKV2_AWS_37     | resource | aws_glue_user_defined_function                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1248 | CKV2_AWS_37     | resource | aws_glue_workflow                                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1249 | CKV2_AWS_37     | resource | aws_grafana_license_association                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1250 | CKV2_AWS_37     | resource | aws_grafana_role_association                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1251 | CKV2_AWS_37     | resource | aws_grafana_workspace                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1252 | CKV2_AWS_37     | resource | aws_grafana_workspace_api_key                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1253 | CKV2_AWS_37     | resource | aws_grafana_workspace_saml_configuration                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1254 | CKV2_AWS_37     | resource | aws_grafana_workspace_service_account                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1255 | CKV2_AWS_37     | resource | aws_grafana_workspace_service_account_token                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1256 | CKV2_AWS_37     | resource | aws_guardduty_detector                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1257 | CKV2_AWS_37     | resource | aws_guardduty_detector_feature                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1258 | CKV2_AWS_37     | resource | aws_guardduty_filter                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1259 | CKV2_AWS_37     | resource | aws_guardduty_invite_accepter                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1260 | CKV2_AWS_37     | resource | aws_guardduty_ipset                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1261 | CKV2_AWS_37     | resource | aws_guardduty_malware_protection_plan                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1262 | CKV2_AWS_37     | resource | aws_guardduty_member                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1263 | CKV2_AWS_37     | resource | aws_guardduty_member_detector_feature                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1264 | CKV2_AWS_37     | resource | aws_guardduty_organization_admin_account                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1265 | CKV2_AWS_37     | resource | aws_guardduty_organization_configuration                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1266 | CKV2_AWS_37     | resource | aws_guardduty_organization_configuration_feature                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1267 | CKV2_AWS_37     | resource | aws_guardduty_publishing_destination                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1268 | CKV2_AWS_37     | resource | aws_guardduty_threatintelset                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1269 | CKV2_AWS_37     | resource | aws_iam_access_key                                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1270 | CKV2_AWS_37     | resource | aws_iam_account_alias                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1271 | CKV2_AWS_37     | resource | aws_iam_account_password_policy                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1272 | CKV2_AWS_37     | resource | aws_iam_group                                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1273 | CKV2_AWS_37     | resource | aws_iam_group_membership                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1274 | CKV2_AWS_37     | resource | aws_iam_group_policies_exclusive                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1275 | CKV2_AWS_37     | resource | aws_iam_group_policy                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1276 | CKV2_AWS_37     | resource | aws_iam_group_policy_attachment                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1277 | CKV2_AWS_37     | resource | aws_iam_group_policy_attachments_exclusive                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1278 | CKV2_AWS_37     | resource | aws_iam_instance_profile                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1279 | CKV2_AWS_37     | resource | aws_iam_openid_connect_provider                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1280 | CKV2_AWS_37     | resource | aws_iam_organizations_features                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1281 | CKV2_AWS_37     | resource | aws_iam_policy                                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1282 | CKV2_AWS_37     | resource | aws_iam_policy_attachment                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1283 | CKV2_AWS_37     | resource | aws_iam_policy_document                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1284 | CKV2_AWS_37     | resource | aws_iam_role                                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1285 | CKV2_AWS_37     | resource | aws_iam_role_policies_exclusive                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1286 | CKV2_AWS_37     | resource | aws_iam_role_policy                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1287 | CKV2_AWS_37     | resource | aws_iam_role_policy_attachment                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1288 | CKV2_AWS_37     | resource | aws_iam_role_policy_attachments_exclusive                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1289 | CKV2_AWS_37     | resource | aws_iam_saml_provider                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1290 | CKV2_AWS_37     | resource | aws_iam_security_token_service_preferences                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1291 | CKV2_AWS_37     | resource | aws_iam_server_certificate                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1292 | CKV2_AWS_37     | resource | aws_iam_service_linked_role                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1293 | CKV2_AWS_37     | resource | aws_iam_service_specific_credential                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1294 | CKV2_AWS_37     | resource | aws_iam_signing_certificate                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1295 | CKV2_AWS_37     | resource | aws_iam_user                                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1296 | CKV2_AWS_37     | resource | aws_iam_user_group_membership                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1297 | CKV2_AWS_37     | resource | aws_iam_user_login_profile                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1298 | CKV2_AWS_37     | resource | aws_iam_user_policies_exclusive                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1299 | CKV2_AWS_37     | resource | aws_iam_user_policy                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1300 | CKV2_AWS_37     | resource | aws_iam_user_policy_attachment                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1301 | CKV2_AWS_37     | resource | aws_iam_user_policy_attachments_exclusive                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1302 | CKV2_AWS_37     | resource | aws_iam_user_ssh_key                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1303 | CKV2_AWS_37     | resource | aws_iam_virtual_mfa_device                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1304 | CKV2_AWS_37     | resource | aws_identitystore_group                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1305 | CKV2_AWS_37     | resource | aws_identitystore_group_membership                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1306 | CKV2_AWS_37     | resource | aws_identitystore_user                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1307 | CKV2_AWS_37     | resource | aws_imagebuilder_component                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1308 | CKV2_AWS_37     | resource | aws_imagebuilder_container_recipe                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1309 | CKV2_AWS_37     | resource | aws_imagebuilder_distribution_configuration                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1310 | CKV2_AWS_37     | resource | aws_imagebuilder_image                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1311 | CKV2_AWS_37     | resource | aws_imagebuilder_image_pipeline                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1312 | CKV2_AWS_37     | resource | aws_imagebuilder_image_recipe                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1313 | CKV2_AWS_37     | resource | aws_imagebuilder_infrastructure_configuration                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1314 | CKV2_AWS_37     | resource | aws_imagebuilder_lifecycle_policy                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1315 | CKV2_AWS_37     | resource | aws_imagebuilder_workflow                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1316 | CKV2_AWS_37     | resource | aws_inspector2_delegated_admin_account                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1317 | CKV2_AWS_37     | resource | aws_inspector2_enabler                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1318 | CKV2_AWS_37     | resource | aws_inspector2_member_association                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1319 | CKV2_AWS_37     | resource | aws_inspector2_organization_configuration                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1320 | CKV2_AWS_37     | resource | aws_inspector_assessment_target                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1321 | CKV2_AWS_37     | resource | aws_inspector_assessment_template                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1322 | CKV2_AWS_37     | resource | aws_inspector_resource_group                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1323 | CKV2_AWS_37     | resource | aws_instance                                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1324 | CKV2_AWS_37     | resource | aws_internet_gateway                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1325 | CKV2_AWS_37     | resource | aws_internet_gateway_attachment                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1326 | CKV2_AWS_37     | resource | aws_internetmonitor_monitor                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1327 | CKV2_AWS_37     | resource | aws_iot_authorizer                                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1328 | CKV2_AWS_37     | resource | aws_iot_billing_group                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1329 | CKV2_AWS_37     | resource | aws_iot_ca_certificate                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1330 | CKV2_AWS_37     | resource | aws_iot_certificate                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1331 | CKV2_AWS_37     | resource | aws_iot_domain_configuration                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1332 | CKV2_AWS_37     | resource | aws_iot_event_configurations                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1333 | CKV2_AWS_37     | resource | aws_iot_indexing_configuration                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1334 | CKV2_AWS_37     | resource | aws_iot_logging_options                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1335 | CKV2_AWS_37     | resource | aws_iot_policy                                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1336 | CKV2_AWS_37     | resource | aws_iot_policy_attachment                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1337 | CKV2_AWS_37     | resource | aws_iot_provisioning_template                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1338 | CKV2_AWS_37     | resource | aws_iot_role_alias                                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1339 | CKV2_AWS_37     | resource | aws_iot_thing                                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1340 | CKV2_AWS_37     | resource | aws_iot_thing_group                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1341 | CKV2_AWS_37     | resource | aws_iot_thing_group_membership                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1342 | CKV2_AWS_37     | resource | aws_iot_thing_principal_attachment                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1343 | CKV2_AWS_37     | resource | aws_iot_thing_type                                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1344 | CKV2_AWS_37     | resource | aws_iot_topic_rule                                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1345 | CKV2_AWS_37     | resource | aws_iot_topic_rule_destination                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1346 | CKV2_AWS_37     | resource | aws_ivs_channel                                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1347 | CKV2_AWS_37     | resource | aws_ivs_playback_key_pair                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1348 | CKV2_AWS_37     | resource | aws_ivs_recording_configuration                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1349 | CKV2_AWS_37     | resource | aws_ivschat_logging_configuration                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1350 | CKV2_AWS_37     | resource | aws_ivschat_room                                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1351 | CKV2_AWS_37     | resource | aws_kendra_data_source                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1352 | CKV2_AWS_37     | resource | aws_kendra_experience                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1353 | CKV2_AWS_37     | resource | aws_kendra_faq                                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1354 | CKV2_AWS_37     | resource | aws_kendra_index                                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1355 | CKV2_AWS_37     | resource | aws_kendra_query_suggestions_block_list                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1356 | CKV2_AWS_37     | resource | aws_kendra_thesaurus                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1357 | CKV2_AWS_37     | resource | aws_key_pair                                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1358 | CKV2_AWS_37     | resource | aws_keyspaces_keyspace                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1359 | CKV2_AWS_37     | resource | aws_keyspaces_table                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1360 | CKV2_AWS_37     | resource | aws_kinesis_analytics_application                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1361 | CKV2_AWS_37     | resource | aws_kinesis_firehose_delivery_stream                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1362 | CKV2_AWS_37     | resource | aws_kinesis_resource_policy                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1363 | CKV2_AWS_37     | resource | aws_kinesis_stream                                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1364 | CKV2_AWS_37     | resource | aws_kinesis_stream_consumer                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1365 | CKV2_AWS_37     | resource | aws_kinesis_video_stream                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1366 | CKV2_AWS_37     | resource | aws_kinesisanalyticsv2_application                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1367 | CKV2_AWS_37     | resource | aws_kinesisanalyticsv2_application_snapshot                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1368 | CKV2_AWS_37     | resource | aws_kms_alias                                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1369 | CKV2_AWS_37     | resource | aws_kms_ciphertext                                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1370 | CKV2_AWS_37     | resource | aws_kms_custom_key_store                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1371 | CKV2_AWS_37     | resource | aws_kms_external_key                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1372 | CKV2_AWS_37     | resource | aws_kms_grant                                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1373 | CKV2_AWS_37     | resource | aws_kms_key                                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1374 | CKV2_AWS_37     | resource | aws_kms_key_policy                                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1375 | CKV2_AWS_37     | resource | aws_kms_replica_external_key                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1376 | CKV2_AWS_37     | resource | aws_kms_replica_key                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1377 | CKV2_AWS_37     | resource | aws_lakeformation_data_cells_filter                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1378 | CKV2_AWS_37     | resource | aws_lakeformation_data_lake_settings                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1379 | CKV2_AWS_37     | resource | aws_lakeformation_lf_tag                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1380 | CKV2_AWS_37     | resource | aws_lakeformation_permissions                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1381 | CKV2_AWS_37     | resource | aws_lakeformation_resource                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1382 | CKV2_AWS_37     | resource | aws_lakeformation_resource_lf_tag                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1383 | CKV2_AWS_37     | resource | aws_lakeformation_resource_lf_tags                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1384 | CKV2_AWS_37     | resource | aws_lambda_alias                                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1385 | CKV2_AWS_37     | resource | aws_lambda_code_signing_config                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1386 | CKV2_AWS_37     | resource | aws_lambda_event_source_mapping                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1387 | CKV2_AWS_37     | resource | aws_lambda_function                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1388 | CKV2_AWS_37     | resource | aws_lambda_function_event_invoke_config                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1389 | CKV2_AWS_37     | resource | aws_lambda_function_recursion_config                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1390 | CKV2_AWS_37     | resource | aws_lambda_function_url                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1391 | CKV2_AWS_37     | resource | aws_lambda_invocation                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1392 | CKV2_AWS_37     | resource | aws_lambda_layer_version                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1393 | CKV2_AWS_37     | resource | aws_lambda_layer_version_permission                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1394 | CKV2_AWS_37     | resource | aws_lambda_permission                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1395 | CKV2_AWS_37     | resource | aws_lambda_provisioned_concurrency_config                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1396 | CKV2_AWS_37     | resource | aws_lambda_runtime_management_config                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1397 | CKV2_AWS_37     | resource | aws_launch_configuration                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1398 | CKV2_AWS_37     | resource | aws_launch_template                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1399 | CKV2_AWS_37     | resource | aws_lb                                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1400 | CKV2_AWS_37     | resource | aws_lb_cookie_stickiness_policy                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1401 | CKV2_AWS_37     | resource | aws_lb_listener                                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1402 | CKV2_AWS_37     | resource | aws_lb_listener_certificate                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1403 | CKV2_AWS_37     | resource | aws_lb_listener_rule                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1404 | CKV2_AWS_37     | resource | aws_lb_ssl_negotiation_policy                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1405 | CKV2_AWS_37     | resource | aws_lb_target_group                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1406 | CKV2_AWS_37     | resource | aws_lb_target_group_attachment                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1407 | CKV2_AWS_37     | resource | aws_lb_trust_store                                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1408 | CKV2_AWS_37     | resource | aws_lb_trust_store_revocation                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1409 | CKV2_AWS_37     | resource | aws_lex_bot                                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1410 | CKV2_AWS_37     | resource | aws_lex_bot_alias                                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1411 | CKV2_AWS_37     | resource | aws_lex_intent                                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1412 | CKV2_AWS_37     | resource | aws_lex_slot_type                                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1413 | CKV2_AWS_37     | resource | aws_lexv2models_bot                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1414 | CKV2_AWS_37     | resource | aws_lexv2models_bot_locale                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1415 | CKV2_AWS_37     | resource | aws_lexv2models_bot_version                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1416 | CKV2_AWS_37     | resource | aws_lexv2models_intent                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1417 | CKV2_AWS_37     | resource | aws_lexv2models_slot                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1418 | CKV2_AWS_37     | resource | aws_lexv2models_slot_type                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1419 | CKV2_AWS_37     | resource | aws_licensemanager_association                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1420 | CKV2_AWS_37     | resource | aws_licensemanager_grant                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1421 | CKV2_AWS_37     | resource | aws_licensemanager_grant_accepter                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1422 | CKV2_AWS_37     | resource | aws_licensemanager_license_configuration                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1423 | CKV2_AWS_37     | resource | aws_lightsail_bucket                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1424 | CKV2_AWS_37     | resource | aws_lightsail_bucket_access_key                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1425 | CKV2_AWS_37     | resource | aws_lightsail_bucket_resource_access                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1426 | CKV2_AWS_37     | resource | aws_lightsail_certificate                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1427 | CKV2_AWS_37     | resource | aws_lightsail_container_service                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1428 | CKV2_AWS_37     | resource | aws_lightsail_container_service_deployment_version               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1429 | CKV2_AWS_37     | resource | aws_lightsail_database                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1430 | CKV2_AWS_37     | resource | aws_lightsail_disk                                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1431 | CKV2_AWS_37     | resource | aws_lightsail_disk_attachment                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1432 | CKV2_AWS_37     | resource | aws_lightsail_distribution                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1433 | CKV2_AWS_37     | resource | aws_lightsail_domain                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1434 | CKV2_AWS_37     | resource | aws_lightsail_domain_entry                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1435 | CKV2_AWS_37     | resource | aws_lightsail_instance                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1436 | CKV2_AWS_37     | resource | aws_lightsail_instance_public_ports                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1437 | CKV2_AWS_37     | resource | aws_lightsail_key_pair                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1438 | CKV2_AWS_37     | resource | aws_lightsail_lb                                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1439 | CKV2_AWS_37     | resource | aws_lightsail_lb_attachment                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1440 | CKV2_AWS_37     | resource | aws_lightsail_lb_certificate                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1441 | CKV2_AWS_37     | resource | aws_lightsail_lb_certificate_attachment                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1442 | CKV2_AWS_37     | resource | aws_lightsail_lb_https_redirection_policy                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1443 | CKV2_AWS_37     | resource | aws_lightsail_lb_stickiness_policy                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1444 | CKV2_AWS_37     | resource | aws_lightsail_static_ip                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1445 | CKV2_AWS_37     | resource | aws_lightsail_static_ip_attachment                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1446 | CKV2_AWS_37     | resource | aws_load_balancer_backend_server_policy                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1447 | CKV2_AWS_37     | resource | aws_load_balancer_listener_policy                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1448 | CKV2_AWS_37     | resource | aws_load_balancer_policy                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1449 | CKV2_AWS_37     | resource | aws_location_geofence_collection                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1450 | CKV2_AWS_37     | resource | aws_location_map                                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1451 | CKV2_AWS_37     | resource | aws_location_place_index                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1452 | CKV2_AWS_37     | resource | aws_location_route_calculator                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1453 | CKV2_AWS_37     | resource | aws_location_tracker                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1454 | CKV2_AWS_37     | resource | aws_location_tracker_association                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1455 | CKV2_AWS_37     | resource | aws_m2_application                                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1456 | CKV2_AWS_37     | resource | aws_m2_deployment                                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1457 | CKV2_AWS_37     | resource | aws_m2_environment                                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1458 | CKV2_AWS_37     | resource | aws_macie2_account                                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1459 | CKV2_AWS_37     | resource | aws_macie2_classification_export_configuration                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1460 | CKV2_AWS_37     | resource | aws_macie2_classification_job                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1461 | CKV2_AWS_37     | resource | aws_macie2_custom_data_identifier                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1462 | CKV2_AWS_37     | resource | aws_macie2_findings_filter                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1463 | CKV2_AWS_37     | resource | aws_macie2_invitation_accepter                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1464 | CKV2_AWS_37     | resource | aws_macie2_member                                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1465 | CKV2_AWS_37     | resource | aws_macie2_organization_admin_account                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1466 | CKV2_AWS_37     | resource | aws_macie_member_account_association                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1467 | CKV2_AWS_37     | resource | aws_macie_s3_bucket_association                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1468 | CKV2_AWS_37     | resource | aws_main_route_table_association                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1469 | CKV2_AWS_37     | resource | aws_media_convert_queue                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1470 | CKV2_AWS_37     | resource | aws_media_package_channel                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1471 | CKV2_AWS_37     | resource | aws_media_packagev2_channel_group                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1472 | CKV2_AWS_37     | resource | aws_media_store_container                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1473 | CKV2_AWS_37     | resource | aws_media_store_container_policy                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1474 | CKV2_AWS_37     | resource | aws_medialive_channel                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1475 | CKV2_AWS_37     | resource | aws_medialive_input                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1476 | CKV2_AWS_37     | resource | aws_medialive_input_security_group                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1477 | CKV2_AWS_37     | resource | aws_medialive_multiplex                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1478 | CKV2_AWS_37     | resource | aws_medialive_multiplex_program                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1479 | CKV2_AWS_37     | resource | aws_memorydb_acl                                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1480 | CKV2_AWS_37     | resource | aws_memorydb_cluster                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1481 | CKV2_AWS_37     | resource | aws_memorydb_multi_region_cluster                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1482 | CKV2_AWS_37     | resource | aws_memorydb_parameter_group                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1483 | CKV2_AWS_37     | resource | aws_memorydb_snapshot                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1484 | CKV2_AWS_37     | resource | aws_memorydb_subnet_group                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1485 | CKV2_AWS_37     | resource | aws_memorydb_user                                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1486 | CKV2_AWS_37     | resource | aws_mq_broker                                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1487 | CKV2_AWS_37     | resource | aws_mq_configuration                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1488 | CKV2_AWS_37     | resource | aws_msk_cluster                                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1489 | CKV2_AWS_37     | resource | aws_msk_cluster_policy                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1490 | CKV2_AWS_37     | resource | aws_msk_configuration                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1491 | CKV2_AWS_37     | resource | aws_msk_replicator                                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1492 | CKV2_AWS_37     | resource | aws_msk_scram_secret_association                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1493 | CKV2_AWS_37     | resource | aws_msk_serverless_cluster                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1494 | CKV2_AWS_37     | resource | aws_msk_single_scram_secret_association                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1495 | CKV2_AWS_37     | resource | aws_msk_vpc_connection                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1496 | CKV2_AWS_37     | resource | aws_mskconnect_connector                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1497 | CKV2_AWS_37     | resource | aws_mskconnect_custom_plugin                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1498 | CKV2_AWS_37     | resource | aws_mskconnect_worker_configuration                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1499 | CKV2_AWS_37     | resource | aws_mwaa_environment                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1500 | CKV2_AWS_37     | resource | aws_nat_gateway                                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1501 | CKV2_AWS_37     | resource | aws_neptune_cluster                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1502 | CKV2_AWS_37     | resource | aws_neptune_cluster_endpoint                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1503 | CKV2_AWS_37     | resource | aws_neptune_cluster_instance                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1504 | CKV2_AWS_37     | resource | aws_neptune_cluster_parameter_group                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1505 | CKV2_AWS_37     | resource | aws_neptune_cluster_snapshot                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1506 | CKV2_AWS_37     | resource | aws_neptune_event_subscription                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1507 | CKV2_AWS_37     | resource | aws_neptune_global_cluster                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1508 | CKV2_AWS_37     | resource | aws_neptune_parameter_group                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1509 | CKV2_AWS_37     | resource | aws_neptune_subnet_group                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1510 | CKV2_AWS_37     | resource | aws_network_acl                                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1511 | CKV2_AWS_37     | resource | aws_network_acl_association                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1512 | CKV2_AWS_37     | resource | aws_network_acl_rule                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1513 | CKV2_AWS_37     | resource | aws_network_interface                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1514 | CKV2_AWS_37     | resource | aws_network_interface_attachment                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1515 | CKV2_AWS_37     | resource | aws_network_interface_sg_attachment                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1516 | CKV2_AWS_37     | resource | aws_networkfirewall_firewall                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1517 | CKV2_AWS_37     | resource | aws_networkfirewall_firewall_policy                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1518 | CKV2_AWS_37     | resource | aws_networkfirewall_logging_configuration                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1519 | CKV2_AWS_37     | resource | aws_networkfirewall_resource_policy                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1520 | CKV2_AWS_37     | resource | aws_networkfirewall_rule_group                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1521 | CKV2_AWS_37     | resource | aws_networkfirewall_tls_inspection_configuration                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1522 | CKV2_AWS_37     | resource | aws_networkmanager_attachment_accepter                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1523 | CKV2_AWS_37     | resource | aws_networkmanager_connect_attachment                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1524 | CKV2_AWS_37     | resource | aws_networkmanager_connect_peer                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1525 | CKV2_AWS_37     | resource | aws_networkmanager_connection                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1526 | CKV2_AWS_37     | resource | aws_networkmanager_core_network                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1527 | CKV2_AWS_37     | resource | aws_networkmanager_core_network_policy_attachment                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1528 | CKV2_AWS_37     | resource | aws_networkmanager_customer_gateway_association                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1529 | CKV2_AWS_37     | resource | aws_networkmanager_device                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1530 | CKV2_AWS_37     | resource | aws_networkmanager_dx_gateway_attachment                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1531 | CKV2_AWS_37     | resource | aws_networkmanager_global_network                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1532 | CKV2_AWS_37     | resource | aws_networkmanager_link                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1533 | CKV2_AWS_37     | resource | aws_networkmanager_link_association                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1534 | CKV2_AWS_37     | resource | aws_networkmanager_site                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1535 | CKV2_AWS_37     | resource | aws_networkmanager_site_to_site_vpn_attachment                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1536 | CKV2_AWS_37     | resource | aws_networkmanager_transit_gateway_connect_peer_association      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1537 | CKV2_AWS_37     | resource | aws_networkmanager_transit_gateway_peering                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1538 | CKV2_AWS_37     | resource | aws_networkmanager_transit_gateway_registration                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1539 | CKV2_AWS_37     | resource | aws_networkmanager_transit_gateway_route_table_attachment        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1540 | CKV2_AWS_37     | resource | aws_networkmanager_vpc_attachment                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1541 | CKV2_AWS_37     | resource | aws_networkmonitor_monitor                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1542 | CKV2_AWS_37     | resource | aws_networkmonitor_probe                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1543 | CKV2_AWS_37     | resource | aws_oam_link                                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1544 | CKV2_AWS_37     | resource | aws_oam_sink                                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1545 | CKV2_AWS_37     | resource | aws_oam_sink_policy                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1546 | CKV2_AWS_37     | resource | aws_opensearch_authorize_vpc_endpoint_access                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1547 | CKV2_AWS_37     | resource | aws_opensearch_domain                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1548 | CKV2_AWS_37     | resource | aws_opensearch_domain_policy                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1549 | CKV2_AWS_37     | resource | aws_opensearch_domain_saml_options                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1550 | CKV2_AWS_37     | resource | aws_opensearch_inbound_connection_accepter                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1551 | CKV2_AWS_37     | resource | aws_opensearch_outbound_connection                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1552 | CKV2_AWS_37     | resource | aws_opensearch_package                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1553 | CKV2_AWS_37     | resource | aws_opensearch_package_association                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1554 | CKV2_AWS_37     | resource | aws_opensearch_vpc_endpoint                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1555 | CKV2_AWS_37     | resource | aws_opensearchserverless_access_policy                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1556 | CKV2_AWS_37     | resource | aws_opensearchserverless_collection                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1557 | CKV2_AWS_37     | resource | aws_opensearchserverless_lifecycle_policy                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1558 | CKV2_AWS_37     | resource | aws_opensearchserverless_security_config                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1559 | CKV2_AWS_37     | resource | aws_opensearchserverless_security_policy                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1560 | CKV2_AWS_37     | resource | aws_opensearchserverless_vpc_endpoint                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1561 | CKV2_AWS_37     | resource | aws_opsworks_application                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1562 | CKV2_AWS_37     | resource | aws_opsworks_custom_layer                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1563 | CKV2_AWS_37     | resource | aws_opsworks_ecs_cluster_layer                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1564 | CKV2_AWS_37     | resource | aws_opsworks_ganglia_layer                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1565 | CKV2_AWS_37     | resource | aws_opsworks_haproxy_layer                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1566 | CKV2_AWS_37     | resource | aws_opsworks_instance                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1567 | CKV2_AWS_37     | resource | aws_opsworks_java_app_layer                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1568 | CKV2_AWS_37     | resource | aws_opsworks_memcached_layer                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1569 | CKV2_AWS_37     | resource | aws_opsworks_mysql_layer                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1570 | CKV2_AWS_37     | resource | aws_opsworks_nodejs_app_layer                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1571 | CKV2_AWS_37     | resource | aws_opsworks_permission                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1572 | CKV2_AWS_37     | resource | aws_opsworks_php_app_layer                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1573 | CKV2_AWS_37     | resource | aws_opsworks_rails_app_layer                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1574 | CKV2_AWS_37     | resource | aws_opsworks_rds_db_instance                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1575 | CKV2_AWS_37     | resource | aws_opsworks_stack                                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1576 | CKV2_AWS_37     | resource | aws_opsworks_static_web_layer                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1577 | CKV2_AWS_37     | resource | aws_opsworks_user_profile                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1578 | CKV2_AWS_37     | resource | aws_organizations_account                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1579 | CKV2_AWS_37     | resource | aws_organizations_delegated_administrator                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1580 | CKV2_AWS_37     | resource | aws_organizations_organization                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1581 | CKV2_AWS_37     | resource | aws_organizations_organizational_unit                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1582 | CKV2_AWS_37     | resource | aws_organizations_policy                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1583 | CKV2_AWS_37     | resource | aws_organizations_policy_attachment                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1584 | CKV2_AWS_37     | resource | aws_organizations_resource_policy                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1585 | CKV2_AWS_37     | resource | aws_osis_pipeline                                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1586 | CKV2_AWS_37     | resource | aws_paymentcryptography_key                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1587 | CKV2_AWS_37     | resource | aws_paymentcryptography_key_alias                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1588 | CKV2_AWS_37     | resource | aws_pinpoint_adm_channel                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1589 | CKV2_AWS_37     | resource | aws_pinpoint_apns_channel                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1590 | CKV2_AWS_37     | resource | aws_pinpoint_apns_sandbox_channel                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1591 | CKV2_AWS_37     | resource | aws_pinpoint_apns_voip_channel                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1592 | CKV2_AWS_37     | resource | aws_pinpoint_apns_voip_sandbox_channel                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1593 | CKV2_AWS_37     | resource | aws_pinpoint_app                                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1594 | CKV2_AWS_37     | resource | aws_pinpoint_baidu_channel                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1595 | CKV2_AWS_37     | resource | aws_pinpoint_email_channel                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1596 | CKV2_AWS_37     | resource | aws_pinpoint_email_template                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1597 | CKV2_AWS_37     | resource | aws_pinpoint_event_stream                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1598 | CKV2_AWS_37     | resource | aws_pinpoint_gcm_channel                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1599 | CKV2_AWS_37     | resource | aws_pinpoint_sms_channel                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1600 | CKV2_AWS_37     | resource | aws_pinpointsmsvoicev2_configuration_set                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1601 | CKV2_AWS_37     | resource | aws_pinpointsmsvoicev2_opt_out_list                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1602 | CKV2_AWS_37     | resource | aws_pinpointsmsvoicev2_phone_number                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1603 | CKV2_AWS_37     | resource | aws_pipes_pipe                                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1604 | CKV2_AWS_37     | resource | aws_placement_group                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1605 | CKV2_AWS_37     | resource | aws_prometheus_alert_manager_definition                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1606 | CKV2_AWS_37     | resource | aws_prometheus_rule_group_namespace                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1607 | CKV2_AWS_37     | resource | aws_prometheus_scraper                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1608 | CKV2_AWS_37     | resource | aws_prometheus_workspace                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1609 | CKV2_AWS_37     | resource | aws_proxy_protocol_policy                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1610 | CKV2_AWS_37     | resource | aws_qldb_ledger                                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1611 | CKV2_AWS_37     | resource | aws_qldb_stream                                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1612 | CKV2_AWS_37     | resource | aws_quicksight_account_subscription                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1613 | CKV2_AWS_37     | resource | aws_quicksight_analysis                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1614 | CKV2_AWS_37     | resource | aws_quicksight_dashboard                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1615 | CKV2_AWS_37     | resource | aws_quicksight_data_set                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1616 | CKV2_AWS_37     | resource | aws_quicksight_data_source                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1617 | CKV2_AWS_37     | resource | aws_quicksight_folder                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1618 | CKV2_AWS_37     | resource | aws_quicksight_folder_membership                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1619 | CKV2_AWS_37     | resource | aws_quicksight_group                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1620 | CKV2_AWS_37     | resource | aws_quicksight_group_membership                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1621 | CKV2_AWS_37     | resource | aws_quicksight_iam_policy_assignment                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1622 | CKV2_AWS_37     | resource | aws_quicksight_ingestion                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1623 | CKV2_AWS_37     | resource | aws_quicksight_namespace                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1624 | CKV2_AWS_37     | resource | aws_quicksight_refresh_schedule                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1625 | CKV2_AWS_37     | resource | aws_quicksight_template                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1626 | CKV2_AWS_37     | resource | aws_quicksight_template_alias                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1627 | CKV2_AWS_37     | resource | aws_quicksight_theme                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1628 | CKV2_AWS_37     | resource | aws_quicksight_user                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1629 | CKV2_AWS_37     | resource | aws_quicksight_vpc_connection                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1630 | CKV2_AWS_37     | resource | aws_ram_principal_association                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1631 | CKV2_AWS_37     | resource | aws_ram_resource_association                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1632 | CKV2_AWS_37     | resource | aws_ram_resource_share                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1633 | CKV2_AWS_37     | resource | aws_ram_resource_share_accepter                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1634 | CKV2_AWS_37     | resource | aws_ram_sharing_with_organization                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1635 | CKV2_AWS_37     | resource | aws_rbin_rule                                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1636 | CKV2_AWS_37     | resource | aws_rds_certificate                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1637 | CKV2_AWS_37     | resource | aws_rds_cluster                                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1638 | CKV2_AWS_37     | resource | aws_rds_cluster_activity_stream                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1639 | CKV2_AWS_37     | resource | aws_rds_cluster_endpoint                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1640 | CKV2_AWS_37     | resource | aws_rds_cluster_instance                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1641 | CKV2_AWS_37     | resource | aws_rds_cluster_parameter_group                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1642 | CKV2_AWS_37     | resource | aws_rds_cluster_role_association                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1643 | CKV2_AWS_37     | resource | aws_rds_cluster_snapshot_copy                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1644 | CKV2_AWS_37     | resource | aws_rds_custom_db_engine_version                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1645 | CKV2_AWS_37     | resource | aws_rds_export_task                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1646 | CKV2_AWS_37     | resource | aws_rds_global_cluster                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1647 | CKV2_AWS_37     | resource | aws_rds_instance_state                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1648 | CKV2_AWS_37     | resource | aws_rds_integration                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1649 | CKV2_AWS_37     | resource | aws_rds_reserved_instance                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1650 | CKV2_AWS_37     | resource | aws_redshift_authentication_profile                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1651 | CKV2_AWS_37     | resource | aws_redshift_cluster                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1652 | CKV2_AWS_37     | resource | aws_redshift_cluster_iam_roles                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1653 | CKV2_AWS_37     | resource | aws_redshift_cluster_snapshot                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1654 | CKV2_AWS_37     | resource | aws_redshift_data_share_authorization                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1655 | CKV2_AWS_37     | resource | aws_redshift_data_share_consumer_association                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1656 | CKV2_AWS_37     | resource | aws_redshift_endpoint_access                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1657 | CKV2_AWS_37     | resource | aws_redshift_endpoint_authorization                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1658 | CKV2_AWS_37     | resource | aws_redshift_event_subscription                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1659 | CKV2_AWS_37     | resource | aws_redshift_hsm_client_certificate                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1660 | CKV2_AWS_37     | resource | aws_redshift_hsm_configuration                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1661 | CKV2_AWS_37     | resource | aws_redshift_logging                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1662 | CKV2_AWS_37     | resource | aws_redshift_parameter_group                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1663 | CKV2_AWS_37     | resource | aws_redshift_partner                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1664 | CKV2_AWS_37     | resource | aws_redshift_resource_policy                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1665 | CKV2_AWS_37     | resource | aws_redshift_scheduled_action                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1666 | CKV2_AWS_37     | resource | aws_redshift_security_group                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1667 | CKV2_AWS_37     | resource | aws_redshift_snapshot_copy                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1668 | CKV2_AWS_37     | resource | aws_redshift_snapshot_copy_grant                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1669 | CKV2_AWS_37     | resource | aws_redshift_snapshot_schedule                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1670 | CKV2_AWS_37     | resource | aws_redshift_snapshot_schedule_association                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1671 | CKV2_AWS_37     | resource | aws_redshift_subnet_group                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1672 | CKV2_AWS_37     | resource | aws_redshift_usage_limit                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1673 | CKV2_AWS_37     | resource | aws_redshiftdata_statement                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1674 | CKV2_AWS_37     | resource | aws_redshiftserverless_custom_domain_association                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1675 | CKV2_AWS_37     | resource | aws_redshiftserverless_endpoint_access                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1676 | CKV2_AWS_37     | resource | aws_redshiftserverless_namespace                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1677 | CKV2_AWS_37     | resource | aws_redshiftserverless_resource_policy                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1678 | CKV2_AWS_37     | resource | aws_redshiftserverless_snapshot                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1679 | CKV2_AWS_37     | resource | aws_redshiftserverless_usage_limit                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1680 | CKV2_AWS_37     | resource | aws_redshiftserverless_workgroup                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1681 | CKV2_AWS_37     | resource | aws_region_info                                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1682 | CKV2_AWS_37     | resource | aws_rekognition_collection                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1683 | CKV2_AWS_37     | resource | aws_rekognition_project                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1684 | CKV2_AWS_37     | resource | aws_rekognition_stream_processor                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1685 | CKV2_AWS_37     | resource | aws_resiliencehub_resiliency_policy                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1686 | CKV2_AWS_37     | resource | aws_resourceexplorer2_index                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1687 | CKV2_AWS_37     | resource | aws_resourceexplorer2_view                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1688 | CKV2_AWS_37     | resource | aws_resourcegroups_group                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1689 | CKV2_AWS_37     | resource | aws_resourcegroups_resource                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1690 | CKV2_AWS_37     | resource | aws_rolesanywhere_profile                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1691 | CKV2_AWS_37     | resource | aws_rolesanywhere_trust_anchor                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1692 | CKV2_AWS_37     | resource | aws_root                                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1693 | CKV2_AWS_37     | resource | aws_root_access_key                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1694 | CKV2_AWS_37     | resource | aws_route                                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1695 | CKV2_AWS_37     | resource | aws_route53_cidr_collection                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1696 | CKV2_AWS_37     | resource | aws_route53_cidr_location                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1697 | CKV2_AWS_37     | resource | aws_route53_delegation_set                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1698 | CKV2_AWS_37     | resource | aws_route53_health_check                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1699 | CKV2_AWS_37     | resource | aws_route53_hosted_zone_dnssec                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1700 | CKV2_AWS_37     | resource | aws_route53_key_signing_key                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1701 | CKV2_AWS_37     | resource | aws_route53_query_log                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1702 | CKV2_AWS_37     | resource | aws_route53_record                                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1703 | CKV2_AWS_37     | resource | aws_route53_resolver_config                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1704 | CKV2_AWS_37     | resource | aws_route53_resolver_dnssec_config                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1705 | CKV2_AWS_37     | resource | aws_route53_resolver_endpoint                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1706 | CKV2_AWS_37     | resource | aws_route53_resolver_firewall_config                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1707 | CKV2_AWS_37     | resource | aws_route53_resolver_firewall_domain_list                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1708 | CKV2_AWS_37     | resource | aws_route53_resolver_firewall_rule                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1709 | CKV2_AWS_37     | resource | aws_route53_resolver_firewall_rule_group                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1710 | CKV2_AWS_37     | resource | aws_route53_resolver_firewall_rule_group_association             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1711 | CKV2_AWS_37     | resource | aws_route53_resolver_query_log_config                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1712 | CKV2_AWS_37     | resource | aws_route53_resolver_query_log_config_association                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1713 | CKV2_AWS_37     | resource | aws_route53_resolver_rule                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1714 | CKV2_AWS_37     | resource | aws_route53_resolver_rule_association                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1715 | CKV2_AWS_37     | resource | aws_route53_traffic_policy                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1716 | CKV2_AWS_37     | resource | aws_route53_traffic_policy_instance                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1717 | CKV2_AWS_37     | resource | aws_route53_vpc_association_authorization                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1718 | CKV2_AWS_37     | resource | aws_route53_zone                                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1719 | CKV2_AWS_37     | resource | aws_route53_zone_association                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1720 | CKV2_AWS_37     | resource | aws_route53domains_delegation_signer_record                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1721 | CKV2_AWS_37     | resource | aws_route53domains_domain                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1722 | CKV2_AWS_37     | resource | aws_route53domains_registered_domain                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1723 | CKV2_AWS_37     | resource | aws_route53profiles_association                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1724 | CKV2_AWS_37     | resource | aws_route53profiles_profile                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1725 | CKV2_AWS_37     | resource | aws_route53profiles_resource_association                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1726 | CKV2_AWS_37     | resource | aws_route53recoverycontrolconfig_cluster                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1727 | CKV2_AWS_37     | resource | aws_route53recoverycontrolconfig_control_panel                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1728 | CKV2_AWS_37     | resource | aws_route53recoverycontrolconfig_routing_control                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1729 | CKV2_AWS_37     | resource | aws_route53recoverycontrolconfig_safety_rule                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1730 | CKV2_AWS_37     | resource | aws_route53recoveryreadiness_cell                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1731 | CKV2_AWS_37     | resource | aws_route53recoveryreadiness_readiness_check                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1732 | CKV2_AWS_37     | resource | aws_route53recoveryreadiness_recovery_group                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1733 | CKV2_AWS_37     | resource | aws_route53recoveryreadiness_resource_set                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1734 | CKV2_AWS_37     | resource | aws_route_table                                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1735 | CKV2_AWS_37     | resource | aws_route_table_association                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1736 | CKV2_AWS_37     | resource | aws_rum_app_monitor                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1737 | CKV2_AWS_37     | resource | aws_rum_metrics_destination                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1738 | CKV2_AWS_37     | resource | aws_s3_access_point                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1739 | CKV2_AWS_37     | resource | aws_s3_account_public_access_block                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1740 | CKV2_AWS_37     | resource | aws_s3_bucket                                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1741 | CKV2_AWS_37     | resource | aws_s3_bucket_accelerate_configuration                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1742 | CKV2_AWS_37     | resource | aws_s3_bucket_acl                                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1743 | CKV2_AWS_37     | resource | aws_s3_bucket_analytics_configuration                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1744 | CKV2_AWS_37     | resource | aws_s3_bucket_cors_configuration                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1745 | CKV2_AWS_37     | resource | aws_s3_bucket_intelligent_tiering_configuration                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1746 | CKV2_AWS_37     | resource | aws_s3_bucket_inventory                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1747 | CKV2_AWS_37     | resource | aws_s3_bucket_lifecycle_configuration                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1748 | CKV2_AWS_37     | resource | aws_s3_bucket_logging                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1749 | CKV2_AWS_37     | resource | aws_s3_bucket_metric                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1750 | CKV2_AWS_37     | resource | aws_s3_bucket_notification                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1751 | CKV2_AWS_37     | resource | aws_s3_bucket_object                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1752 | CKV2_AWS_37     | resource | aws_s3_bucket_object_lock_configuration                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1753 | CKV2_AWS_37     | resource | aws_s3_bucket_ownership_controls                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1754 | CKV2_AWS_37     | resource | aws_s3_bucket_policy                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1755 | CKV2_AWS_37     | resource | aws_s3_bucket_public_access_block                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1756 | CKV2_AWS_37     | resource | aws_s3_bucket_replication_configuration                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1757 | CKV2_AWS_37     | resource | aws_s3_bucket_request_payment_configuration                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1758 | CKV2_AWS_37     | resource | aws_s3_bucket_server_side_encryption_configuration               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1759 | CKV2_AWS_37     | resource | aws_s3_bucket_versioning                                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1760 | CKV2_AWS_37     | resource | aws_s3_bucket_website_configuration                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1761 | CKV2_AWS_37     | resource | aws_s3_directory_bucket                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1762 | CKV2_AWS_37     | resource | aws_s3_object                                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1763 | CKV2_AWS_37     | resource | aws_s3_object_copy                                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1764 | CKV2_AWS_37     | resource | aws_s3control_access_grant                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1765 | CKV2_AWS_37     | resource | aws_s3control_access_grants_instance                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1766 | CKV2_AWS_37     | resource | aws_s3control_access_grants_instance_resource_policy             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1767 | CKV2_AWS_37     | resource | aws_s3control_access_grants_location                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1768 | CKV2_AWS_37     | resource | aws_s3control_access_point_policy                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1769 | CKV2_AWS_37     | resource | aws_s3control_bucket                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1770 | CKV2_AWS_37     | resource | aws_s3control_bucket_lifecycle_configuration                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1771 | CKV2_AWS_37     | resource | aws_s3control_bucket_policy                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1772 | CKV2_AWS_37     | resource | aws_s3control_multi_region_access_point                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1773 | CKV2_AWS_37     | resource | aws_s3control_multi_region_access_point_policy                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1774 | CKV2_AWS_37     | resource | aws_s3control_object_lambda_access_point                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1775 | CKV2_AWS_37     | resource | aws_s3control_object_lambda_access_point_policy                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1776 | CKV2_AWS_37     | resource | aws_s3control_storage_lens_configuration                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1777 | CKV2_AWS_37     | resource | aws_s3outposts_endpoint                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1778 | CKV2_AWS_37     | resource | aws_s3tables_namespace                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1779 | CKV2_AWS_37     | resource | aws_s3tables_table                                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1780 | CKV2_AWS_37     | resource | aws_s3tables_table_bucket                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1781 | CKV2_AWS_37     | resource | aws_s3tables_table_bucket_policy                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1782 | CKV2_AWS_37     | resource | aws_s3tables_table_policy                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1783 | CKV2_AWS_37     | resource | aws_sagemaker_app                                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1784 | CKV2_AWS_37     | resource | aws_sagemaker_app_image_config                                   | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1785 | CKV2_AWS_37     | resource | aws_sagemaker_code_repository                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1786 | CKV2_AWS_37     | resource | aws_sagemaker_data_quality_job_definition                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1787 | CKV2_AWS_37     | resource | aws_sagemaker_device                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1788 | CKV2_AWS_37     | resource | aws_sagemaker_device_fleet                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1789 | CKV2_AWS_37     | resource | aws_sagemaker_domain                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1790 | CKV2_AWS_37     | resource | aws_sagemaker_endpoint                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1791 | CKV2_AWS_37     | resource | aws_sagemaker_endpoint_configuration                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1792 | CKV2_AWS_37     | resource | aws_sagemaker_feature_group                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1793 | CKV2_AWS_37     | resource | aws_sagemaker_flow_definition                                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1794 | CKV2_AWS_37     | resource | aws_sagemaker_hub                                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1795 | CKV2_AWS_37     | resource | aws_sagemaker_human_task_ui                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1796 | CKV2_AWS_37     | resource | aws_sagemaker_image                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1797 | CKV2_AWS_37     | resource | aws_sagemaker_image_version                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1798 | CKV2_AWS_37     | resource | aws_sagemaker_mlflow_tracking_server                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1799 | CKV2_AWS_37     | resource | aws_sagemaker_model                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1800 | CKV2_AWS_37     | resource | aws_sagemaker_model_package_group                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1801 | CKV2_AWS_37     | resource | aws_sagemaker_model_package_group_policy                         | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1802 | CKV2_AWS_37     | resource | aws_sagemaker_monitoring_schedule                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1803 | CKV2_AWS_37     | resource | aws_sagemaker_notebook_instance                                  | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1804 | CKV2_AWS_37     | resource | aws_sagemaker_notebook_instance_lifecycle_configuration          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1805 | CKV2_AWS_37     | resource | aws_sagemaker_pipeline                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1806 | CKV2_AWS_37     | resource | aws_sagemaker_project                                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1807 | CKV2_AWS_37     | resource | aws_sagemaker_servicecatalog_portfolio_status                    | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1808 | CKV2_AWS_37     | resource | aws_sagemaker_space                                              | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1809 | CKV2_AWS_37     | resource | aws_sagemaker_studio_lifecycle_config                            | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1810 | CKV2_AWS_37     | resource | aws_sagemaker_user_profile                                       | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1811 | CKV2_AWS_37     | resource | aws_sagemaker_workforce                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1812 | CKV2_AWS_37     | resource | aws_sagemaker_workteam                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1813 | CKV2_AWS_37     | resource | aws_scheduler_schedule                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1814 | CKV2_AWS_37     | resource | aws_scheduler_schedule_group                                     | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1815 | CKV2_AWS_37     | resource | aws_schemas_discoverer                                           | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1816 | CKV2_AWS_37     | resource | aws_schemas_registry                                             | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1817 | CKV2_AWS_37     | resource | aws_schemas_registry_policy                                      | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1818 | CKV2_AWS_37     | resource | aws_schemas_schema                                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1819 | CKV2_AWS_37     | resource | aws_secretsmanager_secret                                        | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1820 | CKV2_AWS_37     | resource | aws_secretsmanager_secret_policy                                 | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1821 | CKV2_AWS_37     | resource | aws_secretsmanager_secret_rotation                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1822 | CKV2_AWS_37     | resource | aws_secretsmanager_secret_version                                | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1823 | CKV2_AWS_37     | resource | aws_security_group                                               | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1824 | CKV2_AWS_37     | resource | aws_security_group_rule                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                                                         |
| 1825 | CKV2_AWS_37     | resource | aws_securityhub_account                                          | Ensure CodeCommit associates an approval rule                                                                                                                                                            | Terraform | [CodecommitApprovalRulesAttached.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/terraform/checks/graph_checks/aws/CodecommitApprovalRulesAttached.yaml)                            